/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.editors;

import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionManager;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.editors.ApplicationOverviewEditorInputFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class ApplicationOverviewEditorInput
implements IEditorInput,
IPersistableElement {
    public static final String EDITOR_ID = "org.eclipse.codewind.ui.editors.appOverview";
    public final String connectionUri;
    public final String projectID;
    public final String projectName;

    public ApplicationOverviewEditorInput(CodewindApplication app) {
        this.connectionUri = app.connection.getBaseURI().toString();
        this.projectID = app.projectID;
        this.projectName = app.name;
    }

    public ApplicationOverviewEditorInput(String connectionUri, String projectID, String projectName) {
        this.connectionUri = connectionUri;
        this.projectID = projectID;
        this.projectName = projectName;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public boolean exists() {
        CodewindConnection conn = CodewindConnectionManager.getActiveConnection((String)this.connectionUri);
        if (conn == null) {
            return false;
        }
        return conn.getAppByID(this.projectID) != null;
    }

    public ImageDescriptor getImageDescriptor() {
        return CodewindUIPlugin.getDefaultIcon();
    }

    public String getName() {
        return this.projectName;
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public String getToolTipText() {
        return null;
    }

    public void saveState(IMemento memento) {
        ApplicationOverviewEditorInputFactory.saveState(memento, this);
    }

    public String getFactoryId() {
        return "org.eclipse.codewind.ui.editors.appOverviewEditorInputFactory";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ApplicationOverviewEditorInput)) {
            return false;
        }
        ApplicationOverviewEditorInput input = (ApplicationOverviewEditorInput)obj;
        return this.connectionUri.equals(input.connectionUri) && this.projectID.equals(input.projectID);
    }
}

