/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.filewatchers.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.codewind.filewatchers.core.PathUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ProjectToWatch {
    private final String projectId;
    private final String pathToMonitor;
    private final List<String> ignoredPaths = new ArrayList<String>();
    private final List<String> ignoredFilenames = new ArrayList<String>();
    private final String projectWatchStateId;
    private boolean external = false;

    public ProjectToWatch(JSONObject json, boolean deleteChangeType) throws JSONException {
        JSONArray ignoredFilenamesJson;
        if (deleteChangeType) {
            this.projectId = json.getString("projectID");
            this.pathToMonitor = null;
            this.projectWatchStateId = null;
            return;
        }
        String projectType = json.optString("type");
        this.external = projectType != null ? projectType.equalsIgnoreCase("non-project") : false;
        this.projectId = json.getString("projectID");
        this.pathToMonitor = PathUtils.normalizeDriveLetter(json.getString("pathToMonitor"));
        this.projectWatchStateId = json.getString("projectWatchStateId");
        this.validatePathToMonitor();
        JSONArray ignoredPathsJson = json.optJSONArray("ignoredPaths");
        if (ignoredPathsJson != null && ignoredPathsJson.length() > 0) {
            for (int x = 0; x < ignoredPathsJson.length(); ++x) {
                this.ignoredPaths.add(ignoredPathsJson.getString(x));
            }
        }
        if ((ignoredFilenamesJson = json.optJSONArray("ignoredFilenames")) != null && ignoredFilenamesJson.length() > 0) {
            for (int x = 0; x < ignoredFilenamesJson.length(); ++x) {
                this.ignoredFilenames.add(ignoredFilenamesJson.getString(x));
            }
        }
    }

    public ProjectToWatch(String projectId, String pathToMonitorParam) {
        this.projectId = projectId;
        this.projectWatchStateId = null;
        this.pathToMonitor = pathToMonitorParam = PathUtils.normalizeDriveLetter(pathToMonitorParam);
        this.validatePathToMonitor();
    }

    private void validatePathToMonitor() {
        if (this.pathToMonitor.contains("\\")) {
            throw new IllegalArgumentException("Path to monitor should not contain Windows-style path separators: " + this.pathToMonitor);
        }
        if (!this.pathToMonitor.startsWith("/")) {
            throw new IllegalArgumentException("Path to monitor should always begin with a forward slash: " + this.pathToMonitor);
        }
        if (this.pathToMonitor.endsWith("/") || this.pathToMonitor.endsWith("\\")) {
            throw new IllegalArgumentException("Path to monitor may not end with path separator: " + this.pathToMonitor);
        }
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getPathToMonitor() {
        return this.pathToMonitor;
    }

    public List<String> getIgnoredPaths() {
        return this.ignoredPaths;
    }

    public List<String> getIgnoredFilenames() {
        return this.ignoredFilenames;
    }

    public String getProjectWatchStateId() {
        return this.projectWatchStateId;
    }

    public boolean isExternal() {
        return this.external;
    }

    public static class ProjectToWatchFromWebSocket
    extends ProjectToWatch {
        private final String changeType;

        public ProjectToWatchFromWebSocket(JSONObject obj, String changeType) throws JSONException {
            super(obj, changeType.equalsIgnoreCase("delete"));
            this.changeType = changeType;
        }

        public String getChangeType() {
            return this.changeType;
        }
    }
}

