/*******************************************************************************
* Copyright (c) 2019 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
import { FileWatcher } from "./FileWatcher";
import { IAuthTokenProvider } from "./IAuthTokenProvider";
import { IWatchService } from "./IWatchService";
/**
 * This is the client-facing constructor for the filewatcher (and should only be called
 * once per Codewind server instance).
 * @param codewindURL - Eg, http://localhost:9090
 * @param logDir - Directory to write logs to, by default ~/.codewind.
 */
export default function createWatcher(codewindURL: string, logDir?: string, externalWatchService?: IWatchService, pathToInstaller?: string, authTokenProvider?: IAuthTokenProvider): Promise<FileWatcher>;
