/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import java.io.File;
import java.util.Scanner;
import org.eclipse.comma.monitoring.lib.CTraceReader;
import org.eclipse.comma.monitoring.lib.messages.CObservedCommand;
import org.eclipse.comma.monitoring.lib.messages.CObservedMessage;
import org.eclipse.comma.monitoring.lib.messages.CObservedNotification;
import org.eclipse.comma.monitoring.lib.messages.CObservedReply;
import org.eclipse.comma.monitoring.lib.messages.CObservedSignal;
import org.eclipse.comma.monitoring.lib.values.CBulkdata;
import org.eclipse.comma.monitoring.lib.values.CEnumValue;
import org.eclipse.comma.monitoring.lib.values.CVector;

public class CFileTraceReader
extends CTraceReader {
    protected Scanner scanner;
    private boolean traceHasErrors = false;
    private boolean traceInWrongFormat = false;
    private int currentLine = 0;
    private double timeDelta = 0.0;

    public CFileTraceReader(String tracePath) throws Exception {
        this.scanner = new Scanner(new File(tracePath));
        this.moveToEvents();
    }

    public boolean traceHasErrors() {
        return this.traceHasErrors;
    }

    public boolean traceInWrongFormat() {
        return this.traceInWrongFormat;
    }

    public int getCurrentLine() {
        return this.currentLine;
    }

    @Override
    public CObservedMessage readMessage() throws Exception {
        if (this.traceHasErrors || this.traceInWrongFormat) {
            throw new Exception("Trace contains errors");
        }
        String messageId = "";
        CObservedMessage result = null;
        while (this.scanner.hasNextLine()) {
            String line = this.scanner.nextLine();
            ++this.currentLine;
            if (line.isEmpty() || line.startsWith("//")) continue;
            String[] words = line.split("\\s+");
            if (words.length == 1) {
                if (words[0].startsWith("id")) {
                    messageId = words[0];
                    continue;
                }
                throw new Exception("Line " + this.currentLine + ": expected message id.");
            }
            if (words.length != 9) {
                throw new Exception("Line " + this.currentLine + ": wrong message format.");
            }
            switch (words[0]) {
                case "Command": {
                    result = new CObservedCommand(words[8], words[3], words[5], words[4], words[6]);
                    break;
                }
                case "Signal": {
                    result = new CObservedSignal(words[8], words[3], words[5], words[4], words[6]);
                    break;
                }
                case "Notification": {
                    result = new CObservedNotification(words[8], words[3], words[5], words[4], words[6]);
                    break;
                }
                case "Reply": {
                    result = new CObservedReply(words[8], words[3], words[5], words[4], words[6]);
                    break;
                }
                default: {
                    throw new Exception("Line " + this.currentLine + ": unknown message kind.");
                }
            }
            result.setInterface(words[7]);
            result.setMessageId(messageId);
            result.setTimestamp(words[1]);
            this.timeDelta += Double.parseDouble(words[2]);
            result.setTimeDelta(this.timeDelta * 1000.0);
            this.processParameters(result);
            break;
        }
        return result;
    }

    private void processParameters(CObservedMessage message) throws Exception {
        while (this.scanner.hasNextLine()) {
            ++this.currentLine;
            String token = this.scanner.next();
            if (token.equals("End")) {
                if (this.scanner.hasNextLine()) {
                    this.scanner.nextLine();
                }
                return;
            }
            message.addParameter(this.processValue(token));
        }
        throw new Exception("Missing closing End for a message");
    }

    protected Object processValue(String type) throws Exception {
        switch (type) {
            case "int": {
                return this.scanner.nextLong();
            }
            case "real": {
                String val = this.scanner.next();
                if (val.equals("NaN")) {
                    return Double.NaN;
                }
                return Double.parseDouble(val);
            }
            case "bool": {
                return this.scanner.nextBoolean();
            }
            case "string": {
                this.scanner.useDelimiter("\"");
                this.scanner.next();
                String value = this.scanner.next();
                while (value.endsWith("\\")) {
                    value = String.valueOf(value.substring(0, value.length() - 1)) + "\"" + this.scanner.next();
                }
                this.scanner.reset();
                this.scanner.next();
                return value;
            }
            case "bulkdata": {
                return new CBulkdata(this.scanner.nextInt());
            }
            case "enum": {
                return new CEnumValue(String.valueOf(this.scanner.next()) + "::" + this.scanner.next());
            }
            case "vector": {
                String baseType = this.scanner.next();
                int size = this.scanner.nextInt();
                CVector vectorValue = new CVector();
                int i = 1;
                while (i <= size) {
                    vectorValue.addNew(this.processValue(baseType));
                    ++i;
                }
                this.scanner.next();
                return vectorValue;
            }
            case "record": {
                return this.processRecord();
            }
        }
        throw new Exception("Line " + this.currentLine + ": unsupported type");
    }

    protected Object processRecord() throws Exception {
        throw new Exception("Line " + this.currentLine + ": unexpected record value. Model does not use record types.");
    }

    private void moveToEvents() {
        while (this.scanner.hasNextLine()) {
            String line = this.scanner.nextLine().trim();
            ++this.currentLine;
            if (line.equals("events")) {
                return;
            }
            if (!line.equals("errors")) continue;
            this.traceHasErrors = true;
            return;
        }
        this.traceInWrongFormat = true;
    }
}

