/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.ui.handler;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.comma.project.generator.ProjectGenerator;
import org.eclipse.comma.project.project.ProjectDescription;
import org.eclipse.comma.project.ui.handler.LaunchShortcut;
import org.eclipse.comma.types.generator.CommaFileSystemAccess;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.xtext.builder.EclipseOutputConfigurationProvider;
import org.eclipse.xtext.builder.EclipseResourceFileSystemAccess2;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.generator.GeneratorContext;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGenerator2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.ui.util.ResourceUtil;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class ProjectUIGenerator
implements IRunnableWithProgress {
    private static final HashMap<String, Object[]> taskSelectionCache = new HashMap();
    private static final Logger LOGGER = Logger.getLogger(ProjectUIGenerator.class.getName());
    protected static final String ERROR_FILE_NOT_FOUND = "Generated {0} was not found.";
    protected static final String ERROR_MESSAGE_TITLE = "CommaSuite generation error";
    protected static final String ERROR_MESSAGE_TEXT = "Errors during generation. Errors are stored in src-gen/errorReport.txt";
    protected static final String ERROR_MESSAGE_REASON = "CommaSuite encounter one or more errors during generation.";
    protected static final String ERROR_RESOURCE_TITLE = "CommaSuite workflow terminated";
    protected static final String ERROR_RESOURCE_TEXT = "The CommaSuite workflow was terminated because the file %s still contains errors.";
    protected static final String ERROR_REPORT = "errorReport.txt";
    protected static final String LOG_ERROR_CREATING_REPORT = "Error while deleting error report";
    protected static final String LOG_ERROR_GENERATION = "Error while generating documentation with error report";
    protected final IFile file;
    protected final IProject project;
    protected final Shell shell;
    protected final IGenerator2 generator;
    protected final EclipseResourceFileSystemAccess2 fsa;
    protected final IResourceSetProvider resourceSetProvider;
    protected final EclipseOutputConfigurationProvider outputConfigurationProvider;
    protected final IResourceValidator validator;
    private final IResource[] javaResource = new IResource[2];
    private final HashSet<IFile> simulators = new HashSet();
    private final LaunchShortcut launch;
    final String mode;
    final LaunchFile launchFile;
    private final boolean taskSelection;

    public ProjectUIGenerator(IFile file, IGenerator2 generator, EclipseResourceFileSystemAccess2 fileAccessProvider, IResourceSetProvider resourceSetProvider, EclipseOutputConfigurationProvider outputConfigurationProvider, IResourceValidator validator, Shell activeShell, LaunchShortcut launchShortcut, String mode, LaunchFile launchFile, boolean taskSelection) {
        this.file = file;
        this.project = file.getProject();
        this.shell = activeShell;
        this.outputConfigurationProvider = outputConfigurationProvider;
        this.generator = generator;
        this.fsa = fileAccessProvider;
        this.resourceSetProvider = resourceSetProvider;
        this.validator = validator;
        this.taskSelection = taskSelection;
        this.mode = mode;
        this.launchFile = launchFile;
        this.launch = launchShortcut;
    }

    public String getMonitorFileName() {
        return "ScenarioPlayer.java";
    }

    public void launch() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    switch (ProjectUIGenerator.this.launchFile) {
                        case MONITOR: {
                            ProjectUIGenerator.this.launch.launchMonitor(ProjectUIGenerator.this.getMonitorJavaFile(), ProjectUIGenerator.this.mode);
                            break;
                        }
                        case SIMULATOR: {
                            ProjectUIGenerator.this.simulators.forEach(s -> ProjectUIGenerator.this.launch.launchSimulator((IFile)s));
                            break;
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    LOGGER.info("Generate then launch: " + e.getMessage());
                }
            }
        });
    }

    public void run(IProgressMonitor monitor) {
        List<String> errors = this.runGeneration(monitor);
        if (this.shell != null && !errors.isEmpty()) {
            ErrorDialog.openError((Shell)this.shell, (String)ERROR_MESSAGE_TITLE, (String)ERROR_MESSAGE_TEXT, (IStatus)this.createErrorStatus(errors));
        }
        monitor.done();
    }

    public List<String> runGeneration(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        Map<String, OutputConfiguration> outputConfigurations = this.getOutputConfigurations(this.file.getProject());
        final ArrayList<String> errors = new ArrayList<String>();
        try {
            URI uri = URI.createPlatformResourceURI((String)this.file.getFullPath().toString(), (boolean)true);
            final Resource res = this.resourceSetProvider.get(this.project).getResource(uri, true);
            if (this.containsErrors(res, (IProgressMonitor)subMonitor)) {
                MessageDialog.openError((Shell)this.shell, (String)ERROR_RESOURCE_TITLE, (String)String.format(ERROR_RESOURCE_TEXT, res.getURI().lastSegment()));
                return errors;
            }
            this.refreshOutputFolders(this.file.getProject(), outputConfigurations, (IProgressMonitor)subMonitor.newChild(1));
            this.fsa.setProject(this.project);
            this.fsa.setMonitor((IProgressMonitor)subMonitor);
            this.fsa.setOutputConfigurations(outputConfigurations);
            for (OutputConfiguration config : this.fsa.getOutputConfigurations().values()) {
                this.cleanOutputs(this.project, config, this.fsa, (IProgressMonitor)subMonitor);
            }
            if (!(IteratorExtensions.head((Iterator)res.getAllContents()) instanceof ProjectDescription)) {
                MessageDialog.openInformation((Shell)this.shell, (String)"File not found", (String)"CommaSuite project file was not found.");
            }
            if (subMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            final ProjectGenerator generator = (ProjectGenerator)this.generator;
            if (this.taskSelection) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        List taskNames = generator.taskNames(res);
                        ListSelectionDialog dialog = new ListSelectionDialog(ProjectUIGenerator.this.shell, taskNames, (IStructuredContentProvider)ArrayContentProvider.getInstance(), (ILabelProvider)new LabelProvider(), "Choose tasks to execute. Tasks required by the chosen tasks will be automatically selected."){

                            public void create() {
                                super.create();
                                final CheckboxTableViewer viewer = this.getViewer();
                                viewer.addCheckStateListener(new ICheckStateListener(){

                                    public void checkStateChanged(CheckStateChangedEvent event) {
                                        Object[] checkedElements = viewer.getCheckedElements();
                                        Set selectedTasks = Arrays.stream(checkedElements).map(t -> (String)t).collect(Collectors.toSet());
                                        for (String t2 : generator.getTasksClosure(res, selectedTasks)) {
                                            viewer.setChecked((Object)t2, true);
                                            if (!selectedTasks.contains(t2)) {
                                                viewer.setGrayed((Object)t2, true);
                                                continue;
                                            }
                                            viewer.setGrayed((Object)t2, false);
                                        }
                                    }
                                });
                            }
                        };
                        dialog.setTitle("Run tasks");
                        String cacheKey = ProjectUIGenerator.this.file.getFullPath().toFile().toString();
                        dialog.setInitialSelections(taskSelectionCache.getOrDefault(cacheKey, new Object[0]));
                        dialog.open();
                        Object[] result = dialog.getResult();
                        if (result != null) {
                            taskSelectionCache.put(cacheKey, result);
                            Set selectedTasks = Arrays.stream(result).map(t -> (String)t).collect(Collectors.toSet());
                            errors.addAll(generator.generateWithErrorReport(res, selectedTasks, (IFileSystemAccess2)ProjectUIGenerator.this.fsa, (IGeneratorContext)new GeneratorContext()));
                        }
                    }
                });
            } else {
                errors.addAll(generator.generateWithErrorReport(res, (IFileSystemAccess2)this.fsa, (IGeneratorContext)new GeneratorContext()));
            }
            this.refreshOutputFolders(this.file.getProject(), outputConfigurations, (IProgressMonitor)subMonitor.newChild(1));
        }
        catch (CoreException e) {
            errors.add(String.valueOf(this.getClass().getSimpleName()) + e.getMessage() + e.getStackTrace());
        }
        return errors;
    }

    private boolean containsErrors(Resource resource, IProgressMonitor monitor) {
        monitor.beginTask("Validating", 1);
        List issues = this.validator.validate(resource, CheckMode.ALL, this.getCancelIndicator(monitor));
        for (Issue issue : issues) {
            if (!issue.getSeverity().equals((Object)Severity.ERROR)) continue;
            return true;
        }
        return false;
    }

    protected void refreshOutputFolders(IProject project, Map<String, OutputConfiguration> outputConfigurations, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)outputConfigurations.size());
        this.simulators.clear();
        for (OutputConfiguration config : outputConfigurations.values()) {
            SubMonitor child = subMonitor.newChild(1);
            for (IContainer container : this.getOutputs(project, config)) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (!container.exists()) continue;
                ResourceUtil.sync((IResource)container, (int)2, (IProgressMonitor)child);
                this.findJavaResource(container);
            }
        }
    }

    private IStatus createErrorStatus(List<String> errors) {
        ArrayList<Status> childStatuses = new ArrayList<Status>();
        for (String error : errors) {
            childStatuses.add(new Status(4, "org.eclipse.comma.project.Project", error));
        }
        return new MultiStatus("org.eclipse.comma.project.Project", 4, (IStatus[])childStatuses.toArray(new Status[0]), ERROR_MESSAGE_REASON, new Throwable(ERROR_MESSAGE_TITLE));
    }

    public boolean cleanOutputs(IProject project, OutputConfiguration config, EclipseResourceFileSystemAccess2 access, IProgressMonitor monitor) {
        for (IContainer container : this.getOutputs(project, config)) {
            if (!container.exists()) continue;
            try {
                IResource[] iResourceArray = container.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    this.delete(resource, config, access, monitor);
                    ++n2;
                }
            }
            catch (CoreException e) {
                return false;
            }
        }
        return true;
    }

    private void delete(IResource resource, OutputConfiguration config, EclipseResourceFileSystemAccess2 access, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (resource instanceof IContainer) {
            IContainer container = (IContainer)resource;
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource child = iResourceArray[n2];
                this.delete(child, config, access, monitor);
                ++n2;
            }
            container.delete(3, monitor);
        } else if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            access.deleteFile(file, config.getName(), monitor);
        } else {
            resource.delete(3, monitor);
        }
    }

    protected Set<IContainer> getOutputs(IProject project, OutputConfiguration outputConfiguration) {
        LinkedHashSet outputs = Sets.newLinkedHashSet();
        for (String outputPath : outputConfiguration.getOutputDirectories()) {
            IContainer output = ResourceUtil.getContainer((IProject)project, (String)outputPath);
            outputs.add(output);
        }
        return outputs;
    }

    protected Map<String, OutputConfiguration> getOutputConfigurations(IProject project) {
        Set configurations = this.outputConfigurationProvider.getOutputConfigurations(project);
        configurations.add(CommaFileSystemAccess.COMMA_OUTPUT_CONF);
        return Maps.uniqueIndex((Iterable)configurations, (Function)new Function<OutputConfiguration, String>(){

            public String apply(OutputConfiguration from) {
                return from.getName();
            }
        });
    }

    protected CancelIndicator getCancelIndicator(final IProgressMonitor monitor) {
        return new CancelIndicator(){

            public boolean isCanceled() {
                return monitor.isCanceled();
            }
        };
    }

    public IFile getMonitorJavaFile() throws FileNotFoundException {
        if (this.javaResource[0] instanceof IFile) {
            return (IFile)this.javaResource[0];
        }
        throw new FileNotFoundException(MessageFormat.format(ERROR_FILE_NOT_FOUND, this.getMonitorFileName()));
    }

    private void findJavaResource(IContainer container) throws CoreException {
        container.accept(new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                IFile file;
                String path;
                IResource resource = proxy.requestResource();
                if (proxy.getName().equals(ProjectUIGenerator.this.getMonitorFileName())) {
                    ProjectUIGenerator.this.javaResource[0] = resource;
                } else if (resource instanceof IFile && (path = (file = (IFile)resource).getFullPath().toString()).contains("/src-gen/simulator/") && path.endsWith(".jar")) {
                    ProjectUIGenerator.this.simulators.add(file);
                }
                return true;
            }
        }, 2);
    }

    public static enum LaunchFile {
        MONITOR,
        GENERATORS,
        GENERATORS_TASK_SELECTION,
        SIMULATOR;

    }
}

