/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.modelqualitychecks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.comma.actions.actions.Action;
import org.eclipse.comma.actions.actions.AssignmentAction;
import org.eclipse.comma.actions.actions.CommandReply;
import org.eclipse.comma.actions.actions.EventCall;
import org.eclipse.comma.actions.actions.IfAction;
import org.eclipse.comma.actions.actions.Multiplicity;
import org.eclipse.comma.actions.actions.PCElement;
import org.eclipse.comma.actions.actions.PCFragmentReference;
import org.eclipse.comma.actions.actions.ParallelComposition;
import org.eclipse.comma.actions.actions.RecordFieldAssignmentAction;
import org.eclipse.comma.behavior.behavior.Clause;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.behavior.Transition;
import org.eclipse.comma.behavior.behavior.TriggeredTransition;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.modelqualitychecks.PGuard;
import org.eclipse.comma.modelqualitychecks.PInput;
import org.eclipse.comma.modelqualitychecks.POutput;
import org.eclipse.comma.modelqualitychecks.PPlace;
import org.eclipse.comma.modelqualitychecks.PToken;
import org.eclipse.comma.modelqualitychecks.PTransition;
import org.eclipse.comma.modelqualitychecks.SnakesHelper;
import org.eclipse.comma.modelqualitychecks.dashboard.DashboardHelper;
import org.eclipse.comma.parameters.parameters.Parameters;
import org.eclipse.comma.parameters.parameters.Params;
import org.eclipse.comma.parameters.parameters.StateParams;
import org.eclipse.comma.parameters.parameters.TriggerParams;
import org.eclipse.comma.python.PythonInterpreter;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.Parameter;

public class PPetriNet {
    private Interface itf;
    private Parameters params;
    private Map<String, PPlace> places = new LinkedHashMap<String, PPlace>();
    private ArrayList<PTransition> transitions = new ArrayList();
    private ArrayList<PInput> inputs = new ArrayList();
    private ArrayList<POutput> outputs = new ArrayList();
    private List<String> globalVariables;
    private boolean build = false;
    private JsonObject executionResult = null;

    public PPetriNet(Interface itf, Parameters params) {
        this.itf = itf;
        this.params = params;
    }

    public PPetriNet build() {
        if (this.build) {
            throw new RuntimeException("Already build");
        }
        this.build = true;
        PTransition.resetIDCounter();
        this.globalVariables = this.itf.getVars().stream().map(v -> v.getName()).collect(Collectors.toList());
        for (StateMachine machine : this.itf.getMachines()) {
            for (State state : machine.getStates()) {
                PPlace source = this.add(PPlace.forState(machine, state));
                ArrayList transitions = new ArrayList(state.getTransitions());
                machine.getInAllStates().stream().filter(s -> !s.getExcludedStates().contains((Object)state)).forEach(s -> {
                    boolean bl = transitions.addAll(s.getTransitions());
                });
                for (Transition transition : transitions) {
                    PPlace intermediate = this.add(PPlace.forTransition(machine, state, transition));
                    TriggeredTransition trigger = transition instanceof TriggeredTransition ? (TriggeredTransition)transition : null;
                    PGuard guard = transition.getGuard() != null ? new PGuard(transition.getGuard()) : null;
                    this.add(new PTransition((Object)trigger, guard), source, intermediate, null);
                    for (Clause clause : transition.getClauses()) {
                        PPlace clausePlace = this.add(PPlace.forClause(intermediate, clause));
                        this.add(new PTransition(), intermediate, clausePlace, null);
                        State targetState = clause.getTarget() == null ? state : clause.getTarget();
                        PPlace target = this.add(PPlace.forState(machine, targetState));
                        if (clause.getActions() == null) {
                            this.add(new PTransition(), clausePlace, target, null);
                            continue;
                        }
                        this.addClause((List<Action>)clause.getActions().getActions(), clausePlace, target, trigger);
                    }
                }
            }
        }
        this.places.values().stream().filter(p -> p.isInitial()).forEach(p -> p.addToken(new PToken()));
        this.transitions.stream().filter(t -> t.event instanceof TriggeredTransition).forEach(t -> {
            PPlace source = this.getSource((PTransition)t);
            PPlace place = this.add(PPlace.forParameters(t));
            this.inputs.add(new PInput(place, (PTransition)t));
            this.outputs.add(new POutput(place, (PTransition)t, null));
            this.getTokens(source, (TriggeredTransition)t.event).forEach(tt -> place.addToken((PToken)tt));
        });
        PPlace variablesPlace = this.add(PPlace.forVariables());
        variablesPlace.addToken(new PToken(this.globalVariables));
        this.outputs.stream().filter(o -> o.place.type == PPlace.PPlaceType.STATE).collect(Collectors.toList()).forEach(o -> {
            boolean bl = this.outputs.add(new POutput(variablesPlace, o.transition));
        });
        this.inputs.stream().filter(i -> i.place.type == PPlace.PPlaceType.STATE).collect(Collectors.toList()).forEach(i -> {
            boolean bl = this.inputs.add(new PInput(variablesPlace, i.transition));
        });
        return this;
    }

    private PPlace getSource(PTransition transition) {
        List inputs = this.inputs.stream().filter(i -> i.transition == transition && i.place.type != PPlace.PPlaceType.VARIABLES).collect(Collectors.toList());
        assert (inputs.size() == 1);
        return ((PInput)inputs.get((int)0)).place;
    }

    private List<PToken> getTokens(PPlace place, TriggeredTransition event) {
        ArrayList<PToken> result = new ArrayList<PToken>();
        if (this.params != null) {
            for (TriggerParams triggerParams : this.params.getTriggerParams()) {
                if (triggerParams.getEvent() != event.getTrigger()) continue;
                List inParameterNames = event.getParameters().stream().filter(p -> ((Parameter)event.getTrigger().getParameters().get(event.getParameters().indexOf(p))).getDirection() != DIRECTION.OUT).map(p -> p.getName()).collect(Collectors.toList());
                for (StateParams stateParams : triggerParams.getStateParams()) {
                    if (stateParams.getState() != place.state) continue;
                    for (Params p2 : stateParams.getParams()) {
                        HashMap<String, Expression> values = new HashMap<String, Expression>();
                        for (Expression expr : p2.getValue()) {
                            values.put((String)inParameterNames.get(p2.getValue().indexOf((Object)expr)), expr);
                        }
                        result.add(new PToken(values));
                    }
                }
            }
        }
        if (result.isEmpty() && event.getTrigger().getParameters().stream().anyMatch(s -> s.getDirection() != DIRECTION.OUT)) {
            throw new RuntimeException(String.format("No parameters provided for: '%s'", event.getTrigger().getName()));
        }
        if (result.isEmpty()) {
            result.add(new PToken(new HashMap<String, Expression>()));
        }
        return result;
    }

    private void addClause(List<Action> actions, PPlace start, PPlace end, TriggeredTransition trigger) {
        ArrayList<Object> outputActions = new ArrayList<Action>();
        boolean skipLastTranstion = false;
        for (Action action : actions) {
            IfAction a;
            if (action instanceof AssignmentAction || action instanceof RecordFieldAssignmentAction) {
                outputActions.add(action);
                continue;
            }
            if (action instanceof IfAction) {
                a = (IfAction)action;
                PPlace splitPlace = this.add(PPlace.forClause(start, String.format("%d_split", actions.indexOf(action))));
                this.add(new PTransition(), start, splitPlace, outputActions);
                outputActions = new ArrayList();
                start = this.add(PPlace.forClause(start, String.format("%d_join", actions.indexOf(action))));
                PPlace ifPlace = this.add(PPlace.forClauseNest(splitPlace, "if_0"));
                this.add(new PTransition(new PGuard(a.getGuard())), splitPlace, ifPlace, outputActions);
                this.addClause((List<Action>)a.getThenList().getActions(), ifPlace, start, trigger);
                PPlace elsePlace = this.add(PPlace.forClauseNest(splitPlace, "else_0"));
                this.add(new PTransition(new PGuard(a.getGuard(), true)), splitPlace, elsePlace, outputActions);
                this.addClause((List<Action>)(a.getElseList() == null ? new ArrayList() : a.getElseList().getActions()), elsePlace, start, trigger);
                continue;
            }
            if (action instanceof CommandReply || action instanceof EventCall) {
                PPlace actionEnd;
                if (!outputActions.isEmpty()) {
                    PPlace next = this.add(PPlace.forClause(start, Integer.toString(actions.indexOf(action))));
                    this.add(new PTransition(), start, next, outputActions);
                    start = next;
                    outputActions = new ArrayList();
                }
                if (actions.indexOf(action) == actions.size() - 1) {
                    actionEnd = end;
                    skipLastTranstion = true;
                } else {
                    actionEnd = this.add(PPlace.forClause(start, Integer.toString(actions.indexOf(action) + 1)));
                }
                this.addMultiplicityAndOccurence(action, start, actionEnd, trigger);
                start = actionEnd;
                continue;
            }
            if (action instanceof ParallelComposition) {
                a = (ParallelComposition)action;
                PPlace anyOrderPlace = this.add(PPlace.forClause(start, String.format("%d_anyorder", actions.indexOf(action))));
                this.add(new PTransition(), start, anyOrderPlace, outputActions);
                outputActions = new ArrayList();
                PTransition anyOrderTransition = this.add(new PTransition(), anyOrderPlace, null, null);
                PPlace joinPlace = this.add(PPlace.forClause(start, String.format("%d_join", actions.indexOf(action))));
                PTransition joinTransition = this.add(new PTransition(), null, joinPlace, null);
                ArrayList pcActions = new ArrayList();
                a.getComponents().forEach(e -> {
                    class RecursiveHelper {
                        final Consumer<PCElement> addRecursive = element -> {
                            if (element instanceof PCFragmentReference) {
                                ((PCFragmentReference)element).getFragment().getComponents().forEach(e -> this.addRecursive.accept((PCElement)e));
                            } else {
                                list.add((Action)element);
                            }
                        };
                        private final /* synthetic */ List val$pcActions;

                        RecursiveHelper(List list) {
                            this.val$pcActions = list;
                        }
                    }
                    (PPetriNet)this.new RecursiveHelper((List)list).addRecursive.accept((PCElement)e);
                });
                for (Action pcAction : pcActions) {
                    PPlace elementStart = this.add(PPlace.forClause(start, String.format("%d_anyorder_%d_start", actions.indexOf(action), pcActions.indexOf(pcAction))));
                    PPlace elementEnd = this.add(PPlace.forClause(start, String.format("%d_anyorder_%d_end", actions.indexOf(action), pcActions.indexOf(pcAction))));
                    this.outputs.add(new POutput(elementStart, anyOrderTransition, null));
                    this.inputs.add(new PInput(elementEnd, joinTransition));
                    this.addClause(Arrays.asList(pcAction), elementStart, elementEnd, trigger);
                }
                start = joinPlace;
                continue;
            }
            assert (false) : "Not supported";
        }
        if (!skipLastTranstion) {
            if (!outputActions.isEmpty() && end.state != null) {
                PPlace next = this.add(PPlace.forClause(start, Integer.toString(actions.size())));
                this.add(new PTransition(), start, next, outputActions);
                start = next;
                outputActions = new ArrayList();
            }
            this.add(new PTransition(), start, end, outputActions);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addMultiplicityAndOccurence(Action action, PPlace start, PPlace end, TriggeredTransition trigger) {
        long max;
        long min;
        if (!(action instanceof EventCall) || ((EventCall)action).getMultiplicity() == null && ((EventCall)action).getOccurence() == null) {
            this.add(new PTransition((Object)action, trigger), start, end, null);
            return;
        }
        EventCall event = (EventCall)action;
        Multiplicity multiplicity = event.getMultiplicity();
        String occurence = event.getOccurence();
        assert (multiplicity != null || occurence != null);
        if (occurence != null) {
            if (occurence.equals("?")) {
                min = 0L;
                max = 1L;
            } else if (occurence.equals("+")) {
                min = 1L;
                max = -1L;
            } else {
                if (!occurence.equals("*")) throw new RuntimeException("Not supported");
                min = 0L;
                max = -1L;
            }
        } else {
            min = multiplicity.getLower();
            max = multiplicity.getUpperInf() != null ? -1L : multiplicity.getUpper();
        }
        List startOutputs = this.outputs.stream().filter(o -> o.place == start).collect(Collectors.toList());
        if (startOutputs.size() != 1) {
            throw new RuntimeException("Not allowed");
        }
        if (min != 0L || max != -1L) {
            ((POutput)startOutputs.get((int)0)).repeatAction = POutput.RepeatAction.INIT;
        }
        PGuard minGuard = min != 0L ? new PGuard(PGuard.PRepeatGuardType.MIN, min) : null;
        this.add(new PTransition(minGuard), start, end, null);
        if (max == 0L) return;
        PGuard maxGuard = max != -1L ? new PGuard(PGuard.PRepeatGuardType.MAX, max) : null;
        this.add(new PTransition((Object)event, maxGuard), start, start, null);
        if (min == 0L && max == -1L) return;
        this.outputs.get((int)(this.outputs.size() - 1)).repeatAction = max == -1L ? POutput.RepeatAction.SET_1 : POutput.RepeatAction.INCREASE;
    }

    private PTransition add(PTransition transition, PPlace from, PPlace to, List<Action> outputActions) {
        this.transitions.add(transition);
        if (from != null) {
            this.inputs.add(new PInput(from, transition));
        }
        if (to != null) {
            this.outputs.add(new POutput(to, transition, outputActions));
        }
        return transition;
    }

    private PPlace add(PPlace place) {
        if (this.places.containsKey(place.name)) {
            return this.places.get(place.name);
        }
        this.places.put(place.name, place);
        return place;
    }

    private void throwIfNotBuild() {
        assert (this.build) : "Not build yet";
    }

    public String toSnakes() {
        this.throwIfNotBuild();
        StringBuilder builder = new StringBuilder();
        builder.append("from typing import Dict, Any\nimport snakes.plugins, json\nsnakes.plugins.load('gv', 'snakes.nets', 'nets')\nfrom nets import PetriNet, Place, Transition, Variable, Expression\n\nclass Variables:\n    def __init__(self, variables):\n        for key in variables.keys():\n            setattr(self, key, variables[key])\n\n    def copy(self):\n        if hasattr(self, \"g\"):\n            v = Variables({\"g\" : self.g.copy() if self.g != None else None, \n                \"l\": self.l.copy() if self.l != None else None})\n        else:\n            v = Variables(json.loads(json.dumps(vars(self))))\n\n        return v\n\n    def combine(self, g, l):\n        return Variables({\"g\" : g.copy(), \"l\": l.copy() if l != None else None})\n\n    def globals(self):\n        return self.g.copy()\n\n    def e(self, expr):\n        l = self.l.copy() if self.l != None else None\n        g = self.g.copy()\n        exec(expr)\n        return Variables({\"g\" : g, \"l\": l})\n\n    def eval(self, expr):\n        l = self.l.copy() if self.l != None else None\n        g = self.g.copy()\n        return eval(expr)\n\n    def er(self, expr):\n        v = Variables({\"g\" : self.g, \"l\": self.l})\n        if hasattr(self, 'r'): v.r = self.r\n        exec(\"v.r %s\" % expr)\n        return v\n\n    def __repr__(self):\n        v = vars(self)\n        return \"{%s}\" % ','.join([\"%s:%s\" % (k, v[k]) for k in v.keys()])\n\n    def __hash__(self):\n        return hash((self.g, self.l)) if hasattr(self, \"g\") else id(self)\n\n    def __eq__(self, obj):\n        return self.l == obj.l and self.g == obj.g if hasattr(self, \"g\") else super.__eq__(self, obj)\n\ndef net():\n    n = PetriNet(\"N\")\n\n    def add_place(place: Place, meta: Dict[str, Any]):\n        n.add_place(place)\n        place.meta = meta\n\n    def add_transition(transition: Transition, meta: Dict[str, Any]):\n        n.add_transition(transition)\n        transition.meta = meta\n\n\n\n");
        Function<String, String> variablePrefix = variable -> this.globalVariables.contains(variable) ? "g." : "l.";
        builder.append("    # Variables\n");
        this.itf.getVars().forEach(v -> {
            StringBuilder stringBuilder2 = builder.append(String.format("    %s = %s\n", v.getName(), SnakesHelper.defaultValue(v.getType().getType())));
        });
        if (this.params != null) {
            this.params.getVars().forEach(v -> {
                StringBuilder stringBuilder2 = builder.append(String.format("    %s = %s\n", v.getName(), SnakesHelper.defaultValue(v.getType().getType())));
            });
        }
        builder.append("\n    # Init\n");
        this.itf.getInitActions().forEach(a -> {
            StringBuilder stringBuilder2 = builder.append("    " + SnakesHelper.action(a, variable -> "") + "\n");
        });
        if (this.params != null) {
            this.params.getInitActions().forEach(a -> {
                StringBuilder stringBuilder2 = builder.append("    " + SnakesHelper.action(a, variable -> "") + "\n");
            });
        }
        builder.append("\n    # Places\n");
        this.places.values().forEach(p -> {
            StringBuilder stringBuilder2 = builder.append("    " + p.toSnakes());
        });
        builder.append("\n    # Transitions\n");
        this.transitions.forEach(p -> {
            StringBuilder stringBuilder2 = builder.append("    " + p.toSnakes(variablePrefix, this.inputs.stream().filter(i -> i.transition == p).collect(Collectors.toList())));
        });
        builder.append("\n    # Inputs \n");
        this.inputs.forEach(p -> {
            StringBuilder stringBuilder2 = builder.append("    " + p.toSnakes(variablePrefix));
        });
        builder.append("\n    # Outputs\n");
        this.outputs.forEach(p -> {
            StringBuilder stringBuilder2 = builder.append("    " + p.toSnakes(variablePrefix));
        });
        builder.append("    return n\n");
        return builder.toString();
    }

    public PPetriNet execute(int depth, boolean generateVerificationReport, List<List<State>> homeStates, Integer clientServerNetQueueSize) {
        String reachabilityGraphPy = this.getResourceText("/reachability_graph.py");
        String verificationReportPy = this.getResourceText("/verification_report.py");
        String clientServerNetPy = this.getResourceText("/client_server_net.py");
        String executorPy = this.getResourceText("/executor.py");
        if (homeStates == null || homeStates.isEmpty()) {
            List initialStates = this.itf.getMachines().stream().map(m -> m.getStates().stream().filter(s -> s.isInitial()).findFirst().get()).collect(Collectors.toList());
            homeStates = new ArrayList<List<State>>();
            homeStates.add(initialStates);
        }
        String homeStatesStr = homeStates.stream().map(l -> l.stream().map(s -> String.format("'%s'", s.getName())).collect(Collectors.joining(","))).map(s -> String.format("[%s]", s)).collect(Collectors.joining(", "));
        String vrBool = generateVerificationReport ? "True" : "False";
        String csQueueSize = clientServerNetQueueSize == null ? "None" : clientServerNetQueueSize.toString();
        String script = String.valueOf(this.toSnakes()) + "\n\n" + reachabilityGraphPy + "\n\n" + clientServerNetPy + "\n\n" + verificationReportPy + "\n\n" + executorPy + "\n\n" + String.format("execute(%d, [%s], %s, %s)", depth, homeStatesStr, vrBool, csQueueSize);
        String json = PythonInterpreter.execute((String)script);
        this.executionResult = (JsonObject)new Gson().fromJson(json, JsonObject.class);
        return this;
    }

    public JsonObject getReachabilityGraph() {
        assert (this.executionResult != null && this.executionResult.has("reachability_graph")) : "Execute first";
        return this.executionResult.getAsJsonObject("reachability_graph");
    }

    public JsonObject getVerificationReport() {
        assert (this.executionResult != null && this.executionResult.has("verification_report")) : "Execute first";
        return this.executionResult.getAsJsonObject("verification_report");
    }

    public InputStream toPicture() throws IOException {
        if (this.transitions.size() > 30) {
            return this.getClass().getResourceAsStream("/net_too_big.png");
        }
        try {
            Runtime.getRuntime().exec("dot -V");
        }
        catch (Exception e) {
            return this.getClass().getResourceAsStream("/dot_not_on_path.png");
        }
        this.throwIfNotBuild();
        File tempFile = File.createTempFile("commasuite", ".png");
        tempFile.deleteOnExit();
        String script = String.valueOf(this.toSnakes()) + "\n\n" + "if 'LD_LIBRARY_PATH' in os.environ: del os.environ['LD_LIBRARY_PATH']\n" + String.format("net().draw('%s')", tempFile.getAbsolutePath().replace("\\", "\\\\"));
        PythonInterpreter.execute((String)script);
        return new FileInputStream(tempFile);
    }

    public String getReachabilityGraphHTML() {
        InputStream stream = this.getClass().getResourceAsStream("/reachability_graph.html");
        String text = new BufferedReader(new InputStreamReader(stream)).lines().collect(Collectors.joining("\n"));
        return text.replace("%JSON_REACHABILITY_GRAPH%", new Gson().toJson((JsonElement)this.getReachabilityGraph()));
    }

    public String getReachabilityGraphJson() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((JsonElement)this.getReachabilityGraph());
    }

    public String getVerificationReportJson() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((JsonElement)this.getVerificationReport());
    }

    public String getClientServerNet() {
        assert (this.executionResult != null && this.executionResult.has("client_server_net")) : "Execute first";
        return this.executionResult.get("client_server_net").getAsString();
    }

    public byte[] getDashboard() {
        return DashboardHelper.create((JsonObject)this.getVerificationReport(), (Interface)this.itf);
    }

    private String getResourceText(String resource) {
        InputStream stream = this.getClass().getResourceAsStream(resource);
        return new BufferedReader(new InputStreamReader(stream)).lines().collect(Collectors.joining("\n"));
    }
}

