/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project;

import com.google.common.base.Objects;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.eclipse.comma.behavior.behavior.Port;
import org.eclipse.comma.behavior.component.component.Component;
import org.eclipse.comma.behavior.component.utilities.ComponentUtilities;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.behavior.interfaces.scoping.InterfaceUtilities;
import org.eclipse.comma.behavior.utilities.StateMachineUtilities;
import org.eclipse.comma.parameters.parameters.Parameters;
import org.eclipse.comma.petrinet.EnvConfig;
import org.eclipse.comma.project.project.CompoundInterface;
import org.eclipse.comma.project.project.CompoundInterfaceBlock;
import org.eclipse.comma.project.project.DocumentationGenerationBlock;
import org.eclipse.comma.project.project.DocumentationGenerationTask;
import org.eclipse.comma.project.project.EnvironmentComponent;
import org.eclipse.comma.project.project.EventMapping;
import org.eclipse.comma.project.project.FilePath;
import org.eclipse.comma.project.project.GeneratorBlock;
import org.eclipse.comma.project.project.InterfaceModel;
import org.eclipse.comma.project.project.ModelQualityChecksGenerationBlock;
import org.eclipse.comma.project.project.ModelQualityChecksGenerationTask;
import org.eclipse.comma.project.project.MonitoringBlock;
import org.eclipse.comma.project.project.MonitoringTask;
import org.eclipse.comma.project.project.ParameterSegment;
import org.eclipse.comma.project.project.Path;
import org.eclipse.comma.project.project.PathMappings;
import org.eclipse.comma.project.project.PathMappingsBlock;
import org.eclipse.comma.project.project.PortSpec;
import org.eclipse.comma.project.project.Project;
import org.eclipse.comma.project.project.RESTAdapterGenerationBlock;
import org.eclipse.comma.project.project.RESTGenerationBlock;
import org.eclipse.comma.project.project.RESTTask;
import org.eclipse.comma.project.project.RESTTraceGenerationBlock;
import org.eclipse.comma.project.project.ReachabilityGraphGenerationBlock;
import org.eclipse.comma.project.project.ReachabilityGraphGenerationTask;
import org.eclipse.comma.project.project.Segment;
import org.eclipse.comma.project.project.SignatureMapping;
import org.eclipse.comma.project.project.SimulatorGenerationBlock;
import org.eclipse.comma.project.project.SimulatorGenerationTask;
import org.eclipse.comma.project.project.Task;
import org.eclipse.comma.project.project.TestApplicationGenerationBlock;
import org.eclipse.comma.project.project.TestApplicationGenerationTask;
import org.eclipse.comma.project.project.TestCasesGenerationBlock;
import org.eclipse.comma.project.project.TestCasesGenerationTask;
import org.eclipse.comma.project.project.TypeMappings;
import org.eclipse.comma.project.project.TypeMappingsBlock;
import org.eclipse.comma.project.project.UMLBlock;
import org.eclipse.comma.project.project.UMLTask;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.Notification;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.signature.interfaceSignature.Signal;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.utilities.TypeUtilities;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;

public class ProjectUtility {
    public static List<Task> getAllTasks(Project prj) {
        return EcoreUtil2.getAllContentsOfType((EObject)prj, Task.class);
    }

    public static List<TypeMappings> getTypeMappings(Project prj) {
        List<TypeMappings> _xblockexpression = null;
        EList<GeneratorBlock> _generatorBlocks = prj.getGeneratorBlocks();
        for (GeneratorBlock block : _generatorBlocks) {
            if (!(block instanceof TypeMappingsBlock)) continue;
            return ((TypeMappingsBlock)block).getTasks();
        }
        _xblockexpression = Collections.emptyList();
        return _xblockexpression;
    }

    public static List<PathMappings> getPathMappings(Project prj) {
        List<PathMappings> _xblockexpression = null;
        EList<GeneratorBlock> _generatorBlocks = prj.getGeneratorBlocks();
        for (GeneratorBlock block : _generatorBlocks) {
            if (!(block instanceof PathMappingsBlock)) continue;
            return ((PathMappingsBlock)block).getTasks();
        }
        _xblockexpression = Collections.emptyList();
        return _xblockexpression;
    }

    public static List<MonitoringTask> getMonitorTasks(Project prj) {
        List<MonitoringTask> _xblockexpression = null;
        EList<GeneratorBlock> _generatorBlocks = prj.getGeneratorBlocks();
        for (GeneratorBlock block : _generatorBlocks) {
            if (!(block instanceof MonitoringBlock)) continue;
            return ((MonitoringBlock)block).getTasks();
        }
        _xblockexpression = Collections.emptyList();
        return _xblockexpression;
    }

    public static boolean runtimeTask(MonitoringTask task) {
        return task.getTracedirs().isEmpty() && task.getTraces().isEmpty();
    }

    public static List<CompoundInterface> getCompoundInterfaces(Project prj) {
        List<CompoundInterface> _xblockexpression = null;
        EList<GeneratorBlock> _generatorBlocks = prj.getGeneratorBlocks();
        for (GeneratorBlock block : _generatorBlocks) {
            if (!(block instanceof CompoundInterfaceBlock)) continue;
            return ((CompoundInterfaceBlock)block).getTasks();
        }
        _xblockexpression = Collections.emptyList();
        return _xblockexpression;
    }

    public static List<DocumentationGenerationTask> getDocumentationTasks(Project prj) {
        List<DocumentationGenerationTask> _xblockexpression = null;
        EList<GeneratorBlock> _generatorBlocks = prj.getGeneratorBlocks();
        for (GeneratorBlock block : _generatorBlocks) {
            if (!(block instanceof DocumentationGenerationBlock)) continue;
            return ((DocumentationGenerationBlock)block).getTasks();
        }
        _xblockexpression = Collections.emptyList();
        return _xblockexpression;
    }

    public static List<UMLTask> getUMLTasks(Project prj) {
        List<UMLTask> _xblockexpression = null;
        EList<GeneratorBlock> _generatorBlocks = prj.getGeneratorBlocks();
        for (GeneratorBlock block : _generatorBlocks) {
            if (!(block instanceof UMLBlock)) continue;
            return ((UMLBlock)block).getTasks();
        }
        _xblockexpression = Collections.emptyList();
        return _xblockexpression;
    }

    public static List<ModelQualityChecksGenerationTask> getModelQualityChecksTasks(Project prj) {
        List<ModelQualityChecksGenerationTask> _xblockexpression = null;
        EList<GeneratorBlock> _generatorBlocks = prj.getGeneratorBlocks();
        for (GeneratorBlock block : _generatorBlocks) {
            if (!(block instanceof ModelQualityChecksGenerationBlock)) continue;
            return ((ModelQualityChecksGenerationBlock)block).getTasks();
        }
        _xblockexpression = Collections.emptyList();
        return _xblockexpression;
    }

    public static List<TestApplicationGenerationTask> getTestApplicationGeneratorTasks(Project prj) {
        List<TestApplicationGenerationTask> _xblockexpression = null;
        EList<GeneratorBlock> _generatorBlocks = prj.getGeneratorBlocks();
        for (GeneratorBlock block : _generatorBlocks) {
            if (!(block instanceof TestApplicationGenerationBlock)) continue;
            return ((TestApplicationGenerationBlock)block).getTasks();
        }
        _xblockexpression = Collections.emptyList();
        return _xblockexpression;
    }

    public static List<? extends Task> getRESTGeneratorTasks(Project prj) {
        List _xblockexpression = null;
        EList<GeneratorBlock> _generatorBlocks = prj.getGeneratorBlocks();
        for (GeneratorBlock block : _generatorBlocks) {
            if (!(block instanceof RESTGenerationBlock)) continue;
            return ((RESTGenerationBlock)block).getTasks();
        }
        _xblockexpression = Collections.emptyList();
        return _xblockexpression;
    }

    public static List<? extends Task> getRESTAdapterTasks(Project prj) {
        List _xblockexpression = null;
        EList<GeneratorBlock> _generatorBlocks = prj.getGeneratorBlocks();
        for (GeneratorBlock block : _generatorBlocks) {
            if (!(block instanceof RESTAdapterGenerationBlock)) continue;
            return ((RESTAdapterGenerationBlock)block).getTasks();
        }
        _xblockexpression = Collections.emptyList();
        return _xblockexpression;
    }

    public static List<? extends Task> getRESTTraceTasks(Project prj) {
        List _xblockexpression = null;
        EList<GeneratorBlock> _generatorBlocks = prj.getGeneratorBlocks();
        for (GeneratorBlock block : _generatorBlocks) {
            if (!(block instanceof RESTTraceGenerationBlock)) continue;
            return ((RESTTraceGenerationBlock)block).getTasks();
        }
        _xblockexpression = Collections.emptyList();
        return _xblockexpression;
    }

    public static List<ReachabilityGraphGenerationTask> getReachabilityGraphGeneratorTasks(Project prj) {
        List<ReachabilityGraphGenerationTask> _xblockexpression = null;
        EList<GeneratorBlock> _generatorBlocks = prj.getGeneratorBlocks();
        for (GeneratorBlock block : _generatorBlocks) {
            if (!(block instanceof ReachabilityGraphGenerationBlock)) continue;
            return ((ReachabilityGraphGenerationBlock)block).getTasks();
        }
        _xblockexpression = Collections.emptyList();
        return _xblockexpression;
    }

    public static List<TestCasesGenerationTask> getTestCasesGenerationTasks(Project prj) {
        List<TestCasesGenerationTask> _xblockexpression = null;
        EList<GeneratorBlock> _generatorBlocks = prj.getGeneratorBlocks();
        for (GeneratorBlock block : _generatorBlocks) {
            if (!(block instanceof TestCasesGenerationBlock)) continue;
            return ((TestCasesGenerationBlock)((Object)block)).getTasks();
        }
        _xblockexpression = Collections.emptyList();
        return _xblockexpression;
    }

    public static List<SimulatorGenerationTask> getSimulatorGenerationTasks(Project prj) {
        List<SimulatorGenerationTask> _xblockexpression = null;
        EList<GeneratorBlock> _generatorBlocks = prj.getGeneratorBlocks();
        for (GeneratorBlock block : _generatorBlocks) {
            if (!(block instanceof SimulatorGenerationBlock)) continue;
            return ((SimulatorGenerationBlock)block).getTasks();
        }
        _xblockexpression = Collections.emptyList();
        return _xblockexpression;
    }

    public static Map<String, Set<String>> getTaskDependencyMap(Project prj) {
        HashMap<String, Set<String>> _xblockexpression = null;
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        List<Task> allTasks = ProjectUtility.getAllTasks(prj);
        for (Task task : allTasks) {
            Collection _find = EcoreUtil.UsageCrossReferencer.find((EObject)task, allTasks);
            for (EStructuralFeature.Setting setting : _find) {
                Task containerTask = (Task)EcoreUtil2.getContainerOfType((EObject)setting.getEObject(), Task.class);
                if (containerTask == null) continue;
                boolean _containsKey = result.containsKey(containerTask.getName());
                if (_containsKey) {
                    result.get(containerTask.getName()).add(task.getName());
                    continue;
                }
                HashSet<String> set = new HashSet<String>();
                set.add(task.getName());
                result.put(containerTask.getName(), set);
            }
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static HashSet<String> requiredTasksClosure(Set<String> tasks, Map<String, Set<String>> dependencies) {
        HashSet<String> _xblockexpression = null;
        HashSet<String> result = new HashSet<String>();
        Consumer<String> _function = it -> result.addAll(ProjectUtility.getDependencyClosure(it, dependencies));
        tasks.forEach(_function);
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static Iterable<String> findReferredTasks(Set<String> tasks, Map<String, Set<String>> dependencies) {
        Functions.Function1 _function = it -> {
            Functions.Function2 _function_1 = (k, v) -> v.contains(it) && !tasks.contains(k);
            boolean _isEmpty = MapExtensions.filter((Map)dependencies, (Functions.Function2)_function_1).isEmpty();
            return !_isEmpty;
        };
        return IterableExtensions.filter(tasks, (Functions.Function1)_function);
    }

    private static Set<String> getDependencyClosure(String task, Map<String, Set<String>> dependencies) {
        HashSet<String> _xblockexpression = null;
        HashSet<String> result = new HashSet<String>();
        result.add(task);
        boolean _containsKey = dependencies.containsKey(task);
        if (_containsKey) {
            Set<String> _get = dependencies.get(task);
            for (String t : _get) {
                result.addAll(ProjectUtility.getDependencyClosure(t, dependencies));
            }
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static long copyPlantUMLJar(File target) {
        try {
            long _xblockexpression = 0L;
            InputStream stream = ProjectUtility.class.getResourceAsStream("/plantuml.jar");
            _xblockexpression = Files.copy(stream, target.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static URI resolveUri(Resource context, String path) {
        URI contextURI = context.getURI();
        URI uri = URI.createFileURI((String)path);
        if (contextURI.isHierarchical() && !contextURI.isRelative() && uri.isRelative() && !uri.isEmpty()) {
            uri = uri.resolve(contextURI);
        }
        return uri;
    }

    public static List<Signature> getSignaturesForRESTTask(RESTTask task, IScopeProvider scopeProvider) {
        boolean _tripleNotEquals;
        ArrayList<Signature> _xblockexpression = null;
        ArrayList<Signature> result = new ArrayList<Signature>();
        Interface _sourceInterface = task.getSourceInterface();
        boolean bl = _tripleNotEquals = _sourceInterface != null;
        if (_tripleNotEquals) {
            result.add(StateMachineUtilities.getSignatureForMachine((EObject)task.getSourceInterface(), (IScopeProvider)scopeProvider));
        } else {
            EList<InterfaceModel> _interfaces = task.getCompoundInterface().getInterfaces();
            for (InterfaceModel itf : _interfaces) {
                result.add(StateMachineUtilities.getSignatureForMachine((EObject)itf.getInterfaceModel(), (IScopeProvider)scopeProvider));
            }
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static String getApiName(RESTTask task) {
        boolean _tripleNotEquals;
        Interface _sourceInterface = task.getSourceInterface();
        boolean bl = _tripleNotEquals = _sourceInterface != null;
        if (_tripleNotEquals) {
            return task.getSourceInterface().getName();
        }
        return task.getCompoundInterface().getName();
    }

    public static TraceResources getTraceResourcesFromDirs(List<FilePath> directories) {
        TraceResources _xblockexpression = null;
        TraceResources result = new TraceResources();
        HashSet<String> fileNames = new HashSet<String>();
        HashSet<String> directoryNames = new HashSet<String>();
        for (FilePath location : directories) {
            URI uri = ProjectUtility.resolveUri(location.eResource(), location.getPath());
            boolean uriOk = true;
            File dir = null;
            boolean _isPlatform = uri.isPlatform();
            if (_isPlatform) {
                String platform = uri.toPlatformString(true);
                IResource eclipseResource = ResourcesPlugin.getWorkspace().getRoot().findMember(platform);
                if (eclipseResource != null) {
                    File _file;
                    uri = URI.createFileURI((String)eclipseResource.getRawLocation().toOSString());
                    String _fileString = uri.toFileString();
                    dir = _file = new File(_fileString);
                } else {
                    uriOk = false;
                }
            } else {
                File _file_1;
                String _fileString_1 = uri.toFileString();
                dir = _file_1 = new File(_fileString_1);
            }
            FilenameFilter traceFilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".traces") || name.endsWith(".events") || name.endsWith(".jsonl");
                }
            };
            if (uriOk && dir.exists() && dir.isDirectory()) {
                File[] _listFiles;
                boolean _not;
                boolean _add = directoryNames.add(dir.toString());
                boolean bl = _not = !_add;
                if (_not) {
                    result.duplicateDirectories.add(location);
                    continue;
                }
                File[] fileArray = _listFiles = dir.listFiles(traceFilter);
                int n = _listFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    URI fileUri = URI.createFileURI((String)file.getPath()).resolve(location.eResource().getURI());
                    boolean _isValidUri = EcoreUtil2.isValidUri((Resource)location.eResource(), (URI)fileUri);
                    if (_isValidUri) {
                        boolean _not_1;
                        String fileName = fileUri.trimFileExtension().lastSegment();
                        boolean _isValidFileName = ProjectUtility.isValidFileName(fileName);
                        boolean bl2 = _not_1 = !_isValidFileName;
                        if (_not_1) {
                            result.wrongnamedTraceFiles.add(fileUri.toString());
                        } else {
                            boolean _not_2;
                            boolean _add_1 = fileNames.add(fileName);
                            boolean bl3 = _not_2 = !_add_1;
                            if (_not_2) {
                                result.duplicateTraceFiles.add(fileUri.toString());
                            } else {
                                result.validURIs.add(fileUri);
                            }
                        }
                    }
                    ++n2;
                }
                continue;
            }
            result.nonexistentDirectories.add(location);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static TraceResources getTraceResourcesFromFiles(List<FilePath> traceSources) {
        TraceResources _xblockexpression = null;
        TraceResources result = new TraceResources();
        HashSet<String> names = new HashSet<String>();
        for (FilePath traceSource : traceSources) {
            boolean _not_3;
            boolean _not_2;
            boolean _not_1;
            boolean _not;
            String path = traceSource.getPath();
            URI uri = URI.createURI((String)path).resolve(traceSource.eResource().getURI());
            boolean _isValidUri = EcoreUtil2.isValidUri((Resource)traceSource.eResource(), (URI)uri);
            boolean bl = _not = !_isValidUri;
            if (_not) {
                result.invalidTraceSources.add(traceSource);
                continue;
            }
            String fileExtension = uri.fileExtension();
            boolean bl2 = _not_1 = !fileExtension.equals("traces") && !fileExtension.equals("events") && !fileExtension.equals("jsonl");
            if (_not_1) {
                result.invalidTraceSources.add(traceSource);
                continue;
            }
            String fileName = uri.trimFileExtension().lastSegment();
            boolean _isValidFileName = ProjectUtility.isValidFileName(fileName);
            boolean bl3 = _not_2 = !_isValidFileName;
            if (_not_2) {
                result.wrongnamedTraceSources.add(traceSource);
                continue;
            }
            boolean _add = names.add(fileName);
            boolean bl4 = _not_3 = !_add;
            if (_not_3) {
                result.duplicateTraceSources.add(traceSource);
                continue;
            }
            result.validURIs.add(uri);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static List<EnvConfig> getComponentEnvironmentConfig(EObject task, Component component, List<EnvironmentComponent> envComponents, List<Parameters> parameters, IScopeProvider scopeProvider) {
        List allInterfaces = ComponentUtilities.getAllInterfaces((EObject)component.eContainer(), (IScopeProvider)scopeProvider);
        ArrayList<EnvConfig> environment = new ArrayList<EnvConfig>();
        boolean _isEmpty = envComponents.isEmpty();
        if (_isEmpty) {
            EList _ports = component.getPorts();
            for (Port port : _ports) {
                Predicate<Interface> _function = ii -> {
                    Signature _signature = InterfaceUtilities.getSignature((Interface)ii, (IScopeProvider)scopeProvider);
                    Signature _interface = port.getInterface();
                    return Objects.equal((Object)_signature, (Object)_interface);
                };
                Interface itf = allInterfaces.stream().filter(_function).findFirst().get();
                Predicate<Parameters> _function_1 = p -> p.getInterface().equals(itf);
                Optional<Parameters> param = parameters.stream().filter(_function_1).findFirst();
                Parameters _xifexpression = null;
                boolean _isPresent = param.isPresent();
                _xifexpression = _isPresent ? param.get() : null;
                EnvConfig _envConfig = new EnvConfig("c", port, _xifexpression);
                environment.add(_envConfig);
            }
        } else {
            for (EnvironmentComponent envComponent : envComponents) {
                EList<PortSpec> _portSpecs = envComponent.getPortSpecs();
                for (PortSpec portSpec : _portSpecs) {
                    boolean _tripleEquals;
                    Parameters param = null;
                    Predicate<Interface> _function = ii -> {
                        Signature _signature = InterfaceUtilities.getSignature((Interface)ii, (IScopeProvider)scopeProvider);
                        Signature _interface = portSpec.getPort().getInterface();
                        return Objects.equal((Object)_signature, (Object)_interface);
                    };
                    Interface itf = allInterfaces.stream().filter(_function).findFirst().get();
                    String _paramFile = portSpec.getParamFile();
                    boolean bl = _tripleEquals = _paramFile == null;
                    if (_tripleEquals) {
                        Predicate<Parameters> _function_1 = p -> p.getInterface().equals(itf);
                        Optional<Parameters> p2 = parameters.stream().filter(_function_1).findFirst();
                        Parameters _xifexpression = null;
                        boolean _isPresent = p2.isPresent();
                        _xifexpression = _isPresent ? p2.get() : null;
                        param = _xifexpression;
                    } else {
                        EObject _head = (EObject)IterableExtensions.head((Iterable)EcoreUtil2.getResource((Resource)task.eResource(), (String)portSpec.getParamFile()).getContents());
                        param = (Parameters)_head;
                    }
                    String _id = envComponent.getId();
                    Port _port = portSpec.getPort();
                    EnvConfig _envConfig = new EnvConfig(_id, _port, param);
                    environment.add(_envConfig);
                }
            }
        }
        return environment;
    }

    public static File uriToFile(URI uri) {
        boolean _isPlatform = uri.isPlatform();
        if (_isPlatform) {
            IWorkspaceRoot _root = ResourcesPlugin.getWorkspace().getRoot();
            String _platformString = uri.toPlatformString(true);
            org.eclipse.core.runtime.Path _path = new org.eclipse.core.runtime.Path(_platformString);
            return _root.getFile((IPath)_path).getLocation().toFile();
        }
        String _fileString = uri.toFileString();
        return new File(_fileString);
    }

    public static boolean isValidFileName(String fileName) {
        return Pattern.matches("[a-zA-Z][a-zA-Z0-9_]*", fileName);
    }

    public static Path getPath(PathMappings mappings, Signature sig, InterfaceEvent event) {
        EList<SignatureMapping> _signatureMappings = mappings.getSignatureMappings();
        for (SignatureMapping sigMapping : _signatureMappings) {
            Signature _signature = sigMapping.getSignature();
            boolean _equals = Objects.equal((Object)_signature, (Object)sig);
            if (!_equals) continue;
            EList<EventMapping> _eventMappings = sigMapping.getEventMappings();
            for (EventMapping eventMapping : _eventMappings) {
                InterfaceEvent _event = eventMapping.getEvent();
                boolean _equals_1 = Objects.equal((Object)_event, (Object)event);
                if (!_equals_1) continue;
                return eventMapping.getPath();
            }
        }
        return null;
    }

    public static boolean isCommandToPUT(PathMappings mappings, Command c) {
        EObject _eContainer = c.eContainer();
        Signature signature = (Signature)_eContainer;
        Functions.Function1 _function = it -> {
            Signature _signature = it.getSignature();
            return Objects.equal((Object)_signature, (Object)signature);
        };
        Functions.Function1 _function_1 = it -> {
            InterfaceEvent _event = it.getEvent();
            return Objects.equal((Object)_event, (Object)c);
        };
        return ((EventMapping[])Conversions.unwrapArray((Object)IterableExtensions.filter(((SignatureMapping[])Conversions.unwrapArray((Object)IterableExtensions.filter(mappings.getSignatureMappings(), (Functions.Function1)_function), SignatureMapping.class))[0].getEventMappings(), (Functions.Function1)_function_1), EventMapping.class))[0].isIsPut();
    }

    public static ArrayList<InterfaceEvent> getNotificationGetters(PathMappings mapping, Signature sig) {
        ArrayList<InterfaceEvent> result = new ArrayList<InterfaceEvent>();
        EList _notifications = sig.getNotifications();
        for (Notification n : _notifications) {
            boolean _not;
            boolean _isEmpty = ProjectUtility.getNonPathParameters(mapping, (InterfaceEvent)n).isEmpty();
            boolean bl = _not = !_isEmpty;
            if (!_not) continue;
            result.add((InterfaceEvent)n);
        }
        return result;
    }

    public static ArrayList<Parameter> getPathParameters(PathMappings mappings, InterfaceEvent event) {
        EObject _eContainer = event.eContainer();
        Signature signature = (Signature)_eContainer;
        Path path = ProjectUtility.getPath(mappings, signature, event);
        ArrayList<Parameter> result = new ArrayList<Parameter>();
        Functions.Function1 _function = it -> it instanceof ParameterSegment;
        Iterable _filter = IterableExtensions.filter(path.getSegments(), (Functions.Function1)_function);
        for (Segment segment : _filter) {
            result.add(((ParameterSegment)segment).getParameter());
        }
        return result;
    }

    public static List<Parameter> getNonPathParameters(PathMappings mappings, InterfaceEvent event) {
        ArrayList<Parameter> pathParameters = ProjectUtility.getPathParameters(mappings, event);
        Functions.Function1 _function = it -> {
            boolean _contains = pathParameters.contains(it);
            return !_contains;
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)event.getParameters(), (Functions.Function1)_function));
    }

    public static RESTOperation getEventRESTMapping(InterfaceEvent e, PathMappings pathMappings) {
        if (e instanceof Signal) {
            return RESTOperation.PUT;
        }
        if (e instanceof Command) {
            boolean _not;
            boolean _isCommandToPUT = ProjectUtility.isCommandToPUT(pathMappings, (Command)e);
            if (_isCommandToPUT) {
                return RESTOperation.PUT;
            }
            boolean _isVoid = TypeUtilities.isVoid((Type)((Command)e).getType());
            boolean bl = _not = !_isVoid;
            if (_not) {
                return RESTOperation.GET;
            }
            Functions.Function1 _function = it -> {
                DIRECTION _direction = it.getDirection();
                return Objects.equal((Object)_direction, (Object)DIRECTION.OUT);
            };
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)((Command)e).getParameters(), (Functions.Function1)_function));
            if (_isEmpty) {
                return RESTOperation.PUT;
            }
            return RESTOperation.GET;
        }
        return RESTOperation.GET;
    }

    public static enum RESTOperation {
        GET,
        PUT,
        DELETE;

    }

    public static class TraceResources {
        public List<FilePath> invalidTraceSources;
        public List<FilePath> wrongnamedTraceSources;
        public List<FilePath> duplicateTraceSources;
        public List<FilePath> nonexistentDirectories;
        public List<FilePath> duplicateDirectories;
        public List<String> wrongnamedTraceFiles;
        public List<String> duplicateTraceFiles;
        public List<String> invalidTraceFiles;
        public List<URI> validURIs;

        public TraceResources() {
            ArrayList<FilePath> _arrayList = new ArrayList<FilePath>();
            this.invalidTraceSources = _arrayList;
            ArrayList<FilePath> _arrayList_1 = new ArrayList<FilePath>();
            this.wrongnamedTraceSources = _arrayList_1;
            ArrayList<FilePath> _arrayList_2 = new ArrayList<FilePath>();
            this.duplicateTraceSources = _arrayList_2;
            ArrayList<URI> _arrayList_3 = new ArrayList<URI>();
            this.validURIs = _arrayList_3;
            ArrayList<String> _arrayList_4 = new ArrayList<String>();
            this.wrongnamedTraceFiles = _arrayList_4;
            ArrayList<String> _arrayList_5 = new ArrayList<String>();
            this.duplicateTraceFiles = _arrayList_5;
            ArrayList<String> _arrayList_6 = new ArrayList<String>();
            this.invalidTraceFiles = _arrayList_6;
            ArrayList<FilePath> _arrayList_7 = new ArrayList<FilePath>();
            this.nonexistentDirectories = _arrayList_7;
            ArrayList<FilePath> _arrayList_8 = new ArrayList<FilePath>();
            this.duplicateDirectories = _arrayList_8;
        }
    }
}

