/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marco Cortella (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.emf;

import java.util.List;

import org.eclipse.ebam.emf.interfaces.IAlarmTransactions;
import org.eclipse.ebam.emf.interfaces.ISbiAlarmContactsTransactions;
import org.eclipse.ebam.emf.interfaces.ISbiAlarmTransactions;
import org.eclipse.ebam.emf.interfaces.ISbiDomainTransactions;
import org.eclipse.ebam.emf.interfaces.ISbiThresholdValueTransactions;
import org.eclipse.ebam.model.entities.SbiAlarm;
import org.eclipse.ebam.model.entities.SbiAlarmContact;
import org.eclipse.ebam.model.entities.SbiAlarmEvent;
import org.eclipse.ebam.model.entities.SbiDomain;
import org.eclipse.ebam.model.entities.SbiThresholdValue;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventManagerTransaction  implements IAlarmTransactions,
ISbiAlarmContactsTransactions,ISbiAlarmTransactions, ISbiDomainTransactions,
ISbiThresholdValueTransactions{
	
	private AlarmTransactions alarmTransactions;
	private SbiAlarmContactsTransactions sbiAlarmContactsTransactions;
	private SbiAlarmTransactions sbiAlarmTransactions;
	private SbiDomainTransactions sbiDomainTransactions;
	private SbiThresholdValueTransactions sbiThresholdValueTransactions;

	
	private static Logger logger = LoggerFactory
	.getLogger(EventManagerTransaction.class);
	
	public EventManagerTransaction(){
		
		
	}
	
	protected void activate(ComponentContext componentContext){

		try{
		
			
			alarmTransactions = new AlarmTransactions();
			sbiAlarmContactsTransactions = new SbiAlarmContactsTransactions();
			sbiAlarmTransactions = new SbiAlarmTransactions();
			sbiDomainTransactions = new SbiDomainTransactions();
			sbiThresholdValueTransactions = new SbiThresholdValueTransactions();
			
		}catch (Exception e) {
			logger.error("activate"+e.getMessage(), e);
		}
	}
	
	protected void deactivate(ComponentContext componentContext){
		try{
			
		}catch (Exception e) {
			logger.error("deactivate :"+e.getMessage(), e);
		}
	
	}
	
	

	// AlarmEventTransaction:
	/*
	public List<SbiAlarmEvent> alarmEventTransactionFindActiveAlarmEvents() 
	throws Exception {
		return alarmEventTransactions.findActiveAlarmEvents();
	}
	
	
	public void alarmEventTransactionUpdateSbiAlarmEvent(SbiAlarmEvent ev) 
	throws Exception {
		 alarmEventTransactions.updateSbiAlarmEvent(ev);
	}
	
	public boolean alarmEventTransactionCreateNewSbiAlarmEvent( SbiAlarmEvent ev) throws Exception {
		return alarmEventTransactions.createNewSbiAlarmEvent(ev);
	}*/
	
	// Alarm Transaction
	
	
	public  List<SbiAlarmEvent> alarmTransactionFindActiveAlarmEvents() 
	throws Exception {
		return alarmTransactions.findActiveAlarmEvents();
	}
	
	public  void alarmTransactionUpdateSbiAlarmEvent(SbiAlarmEvent ev) 
	throws Exception {
		 alarmTransactions.updateSbiAlarmEvent(ev);
	}
	
	public boolean alarmTransactionCreateNewSbiAlarmEvent( SbiAlarmEvent ev) throws Exception {
		return alarmTransactions.createNewSbiAlarmEvent(ev);
	}
	
	public boolean alarmTransactionMergeSbiAlarm( SbiAlarm sbiAlarm) throws Exception {
		return alarmTransactions.mergeSbiAlarm(sbiAlarm);
	}
	
	public  SbiAlarm alarmTransactionloadSbiAlarmByLabel(String alarmLabel) 
	throws Exception {
		return alarmTransactions.loadSbiAlarmByLabel(alarmLabel);
	}
	
	// SbiAlarmContactsTransactions
	
	public List sbiAlarmContactsTransactionsGetSbiAlarmContactList() throws Exception {
		return sbiAlarmContactsTransactions.getSbiAlarmContactList();
	}
	
	public  SbiAlarmContact sbiAlarmContactsTransactionsGetSbiAlarmContactById(Integer id) 
	throws Exception {
		return sbiAlarmContactsTransactions.getSbiAlarmContactById(id);
	}
	
	public boolean sbiAlarmContactsTransactionsMergeSbiAlarmContact(final SbiAlarmContact sbiAlarmContact) throws Exception {
		return sbiAlarmContactsTransactions.mergeSbiAlarmContact(sbiAlarmContact);
	}
	
	public boolean sbiAlarmContactsTransactionsDeleteSbiAlarmContact(final SbiAlarmContact sbiAlarmContact) throws Exception {
		return sbiAlarmContactsTransactions.deleteSbiAlarmContact(sbiAlarmContact);
	}

	// Sbi Alarm Transactions
	
	public  List sbiAlarmTransactionsGetSbiAlarmList() throws Exception {
		return sbiAlarmTransactions.getSbiAlarmList();
	}
	
	public  SbiAlarm sbiAlarmTransactionsGetSbiAlarmById(Integer id) 
	throws Exception {
		return sbiAlarmTransactions.getSbiAlarmById(id);
	}
	
	public  SbiAlarm sbiAlarmTransactionsGetSbiAlarmByLabel(String label) 
	throws Exception {
		return sbiAlarmTransactions.getSbiAlarmByLabel(label);
	}
	
	public boolean sbiAlarmTransactionsCreateNewSbiAlarm(final SbiAlarm sbiAlarm) throws Exception {
		return sbiAlarmTransactions.createNewSbiAlarm(sbiAlarm);
	}
	
	public boolean sbiAlarmTransactionsMergeSbiAlarm(final SbiAlarm sbiAlarm) throws Exception {
		return sbiAlarmTransactions.mergeSbiAlarm(sbiAlarm);
	}
	
	public boolean sbiAlarmTransactionsDeleteSbiAlarm(final SbiAlarm sbiAlarm) throws Exception {
		return sbiAlarmTransactions.deleteSbiAlarm(sbiAlarm);
	}
	
	// SbiDomainTransactions

	
	public  SbiDomain getSbiDomainByCode(String code) throws Exception{
		return sbiDomainTransactions.getSbiDomainByCode(code);
	}
	
	public SbiDomain getDomainById(Integer id) throws Exception{
		return sbiDomainTransactions.getDomainById(id);
	}
	
	public boolean createNewAlarm(final SbiAlarm alarm) throws Exception {
		return sbiDomainTransactions.createNewAlarm(alarm);
	}
	
	
	// SbiThresholdValueTransactions
	
	public  List sbiThresholdValueTransactionsGetSbiThresholdValueList(Integer thresId) throws Exception {
		return sbiThresholdValueTransactions.getSbiThresholdValueList(thresId);
	}
	
	public SbiThresholdValue sbiThresholdValueTransactionsGetSbiThresholdValueByLabel(Integer thresId, String label) throws Exception {
		return sbiThresholdValueTransactions.getSbiThresholdValueByLabel(thresId,label);
	}
	
/**
 * 
 * Getters and setters methods

	public AlarmEventTransactions getAlarmEventTransactions() {
		return alarmEventTransactions;
	}



	public void setAlarmEventTransactions(
			AlarmEventTransactions alarmEventTransactions) {
		this.alarmEventTransactions = alarmEventTransactions;
	}

 */

	public AlarmTransactions getAlarmTransactions() {
		return alarmTransactions;
	}



	public void setAlarmTransactions(AlarmTransactions alarmTransactions) {
		this.alarmTransactions = alarmTransactions;
	}



	public SbiAlarmContactsTransactions getSbiAlarmContactsTransactions() {
		return sbiAlarmContactsTransactions;
	}



	public void setSbiAlarmContactsTransactions(
			SbiAlarmContactsTransactions sbiAlarmContactsTransactions) {
		this.sbiAlarmContactsTransactions = sbiAlarmContactsTransactions;
	}



	public SbiAlarmTransactions getSbiAlarmTransactions() {
		return sbiAlarmTransactions;
	}



	public void setSbiAlarmTransactions(SbiAlarmTransactions sbiAlarmTransactions) {
		this.sbiAlarmTransactions = sbiAlarmTransactions;
	}


	public SbiDomainTransactions getSbiDomainTransactions() {
		return sbiDomainTransactions;
	}



	public void setSbiDomainTransactions(SbiDomainTransactions sbiDomainTransactions) {
		this.sbiDomainTransactions = sbiDomainTransactions;
	}



	public SbiThresholdValueTransactions getSbiThresholdValueTransactions() {
		return sbiThresholdValueTransactions;
	}



	public void setSbiThresholdValueTransactions(
			SbiThresholdValueTransactions sbiThresholdValueTransactions) {
		this.sbiThresholdValueTransactions = sbiThresholdValueTransactions;
	}

	
	public List getDomainByDomainCd(String domainCd)
			throws Exception {
		return sbiDomainTransactions.getDomainByDomainCd(domainCd);
	}

	public SbiDomain getSbiDomainByCodeAndDomainCd(String code, String domainCd)
			throws Exception {
		return sbiDomainTransactions.getSbiDomainByCodeAndDomainCd(code, domainCd);
	}

	public List<SbiAlarm> loadSbiAlarmListByEventId(Double eventId)
			throws Exception {
		return alarmTransactions.loadSbiAlarmListByEventId(eventId);
	}

}
