/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.adapters;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.eclipse.ebam.adapters.ConfigurationReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdapterConfiguration {
    private static Logger logger = LoggerFactory.getLogger(AdapterConfiguration.class);
    private final String confFilePath = "/conf/configuration.xml";
    private Map<String, String> properties;
    private Map<String, Map<String, String>> logadapters;
    private Map<String, String> engines;
    private String typeManager;
    private List<String> nameAdapters;
    private String content = null;
    private Map<String, String> journalRules;
    private Document doc;

    public Map<String, String> getJournalRules() {
        return this.journalRules;
    }

    private AdapterConfiguration() {
        InputStream is;
        URL configFile = ConfigurationReader.getFileURL("/conf/configuration.xml");
        try {
            is = configFile.openStream();
        }
        catch (IOException e1) {
            logger.error(e1.getMessage(), (Throwable)e1);
            return;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            br.close();
            this.content = sb.toString();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            StringBuffer strBufferContent = new StringBuffer(this.content);
            ByteArrayInputStream bais = new ByteArrayInputStream(strBufferContent.toString().getBytes("UTF-8"));
            InputSource inputSource = new InputSource(bais);
            this.doc = db.parse(inputSource);
            this.doc.getDocumentElement().normalize();
            this.logadapters = new ConcurrentHashMap<String, Map<String, String>>();
            this.properties = new ConcurrentHashMap<String, String>();
            this.nameAdapters = new ArrayList<String>();
            this.engines = new ConcurrentHashMap<String, String>();
            this.journalRules = new ConcurrentHashMap<String, String>();
            this.readMap();
        }
        catch (UnsupportedEncodingException e) {
            logger.error("", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            logger.error("", (Throwable)e);
        }
        catch (SAXException e) {
            logger.error("", (Throwable)e);
        }
    }

    public List<String> getNameAdapters() {
        return this.nameAdapters;
    }

    public void setNameAdapters(List<String> nameAdapters) {
        this.nameAdapters = nameAdapters;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Map<String, Map<String, String>> getLogAdapters() {
        return this.logadapters;
    }

    public void setLogAdapters(Map<String, Map<String, String>> logadapters) {
        this.logadapters = logadapters;
    }

    public void readMap() {
        try {
            Node pn;
            NodeIterator rulesNode = XPathAPI.selectNodeIterator((Node)this.doc, (String)"//ebam-configuration/ebam-message-rules/journal/property");
            NodeIterator propertiesNode = XPathAPI.selectNodeIterator((Node)this.doc, (String)"//ebam-configuration/manager/property");
            NodeIterator adaptersNode = XPathAPI.selectNodeIterator((Node)this.doc, (String)"//ebam-configuration/adapter");
            NodeIterator enginesNode = XPathAPI.selectNodeIterator((Node)this.doc, (String)"//ebam-configuration/manager/dispatcher/engine");
            this.properties = new Hashtable<String, String>();
            this.journalRules = new Hashtable<String, String>();
            this.typeManager = XPathAPI.eval((Node)this.doc, (String)"//ebam-configuration/manager/@type").toString();
            while ((pn = adaptersNode.nextNode()) != null) {
                Node n;
                logger.info("Getting the adapter");
                String id = XPathAPI.eval((Node)pn, (String)"@id").toString();
                NodeIterator adaptersPropertyNode = XPathAPI.selectNodeIterator((Node)pn, (String)"property");
                ConcurrentHashMap<String, String> data_adapter = new ConcurrentHashMap<String, String>();
                while ((n = adaptersPropertyNode.nextNode()) != null) {
                    String name = XPathAPI.eval((Node)n, (String)"@name").toString();
                    String value = XPathAPI.eval((Node)n, (String)"@value").toString();
                    logger.info("Adapter name : " + id + " Adapter Property Name " + name + " Adapter Property value " + value);
                    data_adapter.put(name, value);
                }
                this.logadapters.put(id, data_adapter);
                this.nameAdapters.add(id);
            }
            while ((pn = propertiesNode.nextNode()) != null) {
                this.properties.put(XPathAPI.eval((Node)pn, (String)"@name").toString(), XPathAPI.eval((Node)pn, (String)"@value").toString());
            }
            while ((pn = rulesNode.nextNode()) != null) {
                this.journalRules.put(XPathAPI.eval((Node)pn, (String)"@name").toString(), XPathAPI.eval((Node)pn, (String)"@value").toString());
            }
            while ((pn = enginesNode.nextNode()) != null) {
                this.engines.put(XPathAPI.eval((Node)pn, (String)"@name").toString(), XPathAPI.eval((Node)pn, (String)"@value").toString());
            }
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public static AdapterConfiguration getInstance() {
        return Singleton.INSTANCE;
    }

    public Map<String, String> getEventProcessors() {
        return this.engines;
    }

    public String getManagerType() {
        return this.typeManager;
    }

    /* synthetic */ AdapterConfiguration(AdapterConfiguration adapterConfiguration) {
        this();
    }

    private static class Singleton {
        private static final AdapterConfiguration INSTANCE = new AdapterConfiguration(null);

        private Singleton() {
        }
    }
}

