/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.jms.marshaler;

import java.util.Enumeration;
import java.util.Map;
import javax.jms.JMSException;
import org.eclipse.ebpm.messaging.api.Message;

public abstract class BaseJmsMarshaler {
    public static final String CONTENT_TYPE_PROPERTY = "SOAPJMS_contentType";
    private boolean copyProperties = true;
    private boolean needJavaIdentifiers = true;

    protected void copyPropertiesFromJMSMessage(javax.jms.Message jmsMessage, Message inMessage) throws JMSException {
        Enumeration propertyNames = jmsMessage.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            inMessage.setHeader(propertyName, jmsMessage.getObjectProperty(propertyName));
        }
    }

    protected void copyPropertiesFromNormalizedMessage(Message outMessage, javax.jms.Message jmsMessage) throws JMSException {
        for (Map.Entry header : outMessage.getHeaders().entrySet()) {
            if (!this.shouldIncludeHeaderValue((String)header.getKey(), header.getValue())) continue;
            jmsMessage.setObjectProperty((String)header.getKey(), header.getValue());
        }
    }

    protected boolean shouldIncludeHeaderValue(String name, Object value) {
        return !(!(value instanceof Boolean) && !(value instanceof Byte) && !(value instanceof Short) && !(value instanceof Integer) && !(value instanceof Long) && !(value instanceof Float) && !(value instanceof Double) && !(value instanceof String) || this.isNeedJavaIdentifiers() && !BaseJmsMarshaler.isJavaIdentifier(name));
    }

    private static boolean isJavaIdentifier(String s) {
        int n = s.length();
        if (n == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < n) {
            if (!Character.isJavaIdentifierPart(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isNeedJavaIdentifiers() {
        return this.needJavaIdentifiers;
    }

    public void setNeedJavaIdentifiers(boolean needJavaIdentifiers) {
        this.needJavaIdentifiers = needJavaIdentifiers;
    }

    public boolean isCopyProperties() {
        return this.copyProperties;
    }

    public void setCopyProperties(boolean copyProperties) {
        this.copyProperties = copyProperties;
    }
}

