/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.core;

import org.eclipse.ebpm.core.AbstractSpagicService;
import org.eclipse.ebpm.core.ExchangeUtils;
import org.eclipse.ebpm.core.IConnector;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;
import org.eclipse.ebpm.messaging.api.Status;
import org.eclipse.ebpm.messaging.core.MessageImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSpagicConnector
extends AbstractSpagicService
implements IConnector {
    private static Logger logger = LoggerFactory.getLogger(AbstractSpagicConnector.class);

    @Override
    public void process(Exchange exchange) {
        if (exchange.getStatus() == Status.Done) {
            return;
        }
        if (exchange.getStatus() == Status.Error) {
            return;
        }
        try {
            Exchange outExchange = null;
            Message in = exchange.getIn();
            Message out = null;
            if (ExchangeUtils.isInAndOut(exchange)) {
                out = exchange.getOut(true);
            } else if (this.target != null) {
                outExchange = this.createInOnlyExchange();
                outExchange.setProperty("SPAGIC_SENDER", (Object)this.getSpagicId());
                String processCorrelationId = (String)exchange.getProperty("CORRELATION_ID");
                if (processCorrelationId != null) {
                    outExchange.setProperty("CORRELATION_ID", (Object)processCorrelationId);
                }
                out = exchange.getIn(true);
            }
            if (out != null) {
                this.copyMessage(in, out);
                this.copyPropertiesAndAttachments(exchange, in, out);
            }
            if (this.run(exchange, in, out)) {
                if (ExchangeUtils.isInAndOut(exchange)) {
                    this.configureForResponse(exchange);
                    exchange.setOut(out);
                    this.send(exchange);
                } else {
                    if (outExchange != null) {
                        outExchange.setIn(out);
                        this.send(outExchange);
                    }
                    this.done(exchange);
                }
            } else {
                this.fail(exchange, new Exception("Generic Error in Run Method of " + this.getSpagicId()));
            }
        }
        catch (Exception e) {
            logger.error("Error in connection execution", (Throwable)e);
            this.fail(exchange, e);
        }
    }

    public boolean run(Exchange exchange, Message in, Message out) throws Exception {
        throw new UnsupportedOperationException("run method not implemented on connector");
    }

    protected void copyPropertiesAndAttachments(Exchange exchange, Message in, Message out) throws Exception {
        out.setHeaders(in.getHeaders());
        String attachmentsIn = ((MessageImpl)in)._encodeAttachments();
        ((MessageImpl)out)._decodeAttachments(attachmentsIn);
    }

    protected void copyMessage(Message in, Message out) throws Exception {
        out.setBody(in.getBody());
    }
}

