/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.core;

import org.eclipse.ebpm.core.AbstractSpagicService;
import org.eclipse.ebpm.core.ExchangeUtils;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;
import org.eclipse.ebpm.messaging.api.Status;
import org.eclipse.ebpm.messaging.core.MessageImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSpagicService
extends AbstractSpagicService {
    protected Logger logger = LoggerFactory.getLogger(BaseSpagicService.class);
    private boolean copyAttachments = true;
    private boolean copyProperties = true;

    public boolean isCopyAttachments() {
        return this.copyAttachments;
    }

    public void setCopyAttachments(boolean copyAttachments) {
        this.copyAttachments = copyAttachments;
    }

    public boolean isCopyProperties() {
        return this.copyProperties;
    }

    public void setCopyProperties(boolean copyProperties) {
        this.copyProperties = copyProperties;
    }

    @Override
    public void process(Exchange exchange) {
        try {
            if (this.isStopped()) {
                this.fail(exchange, new UnsupportedOperationException("Trying to invoke a stopped component. Component Id: " + this.getSpagicId()));
                return;
            }
        }
        catch (Exception whatTheHell) {
            this.logger.error("Complettly unexpected exception checking service status", (Throwable)whatTheHell);
            throw new RuntimeException(whatTheHell);
        }
        if (exchange.getStatus() == Status.Done) {
            return;
        }
        if (exchange.getStatus() == Status.Error) {
            return;
        }
        try {
            Message out;
            Exchange outExchange = null;
            Message in = exchange.getIn();
            if (ExchangeUtils.isInAndOut(exchange)) {
                out = exchange.getOut(true);
            } else {
                outExchange = this.createInOnlyExchange();
                outExchange.setProperty("SPAGIC_SENDER", (Object)this.getSpagicId());
                String processCorrelationId = (String)exchange.getProperty("CORRELATION_ID");
                if (processCorrelationId != null) {
                    outExchange.setProperty("CORRELATION_ID", (Object)processCorrelationId);
                }
                out = exchange.getIn(true);
            }
            this.copyPropertiesAndAttachments(exchange, in, out);
            if (this.run(exchange, in, out)) {
                if (ExchangeUtils.isInAndOut(exchange)) {
                    this.configureForResponse(exchange);
                    exchange.setOut(out);
                    this.send(exchange);
                } else {
                    if (this.target != null) {
                        outExchange.setIn(out);
                        this.send(outExchange);
                    } else {
                        this.logger.info("Target for service " + this.spagicId + "not configured. In-only message will not be sent.");
                    }
                    this.done(exchange);
                }
            } else {
                this.fail(exchange, new Exception("Generic Error in Run Method of " + this.getSpagicId()));
            }
        }
        catch (Throwable e) {
            Exception ex = new Exception(e);
            this.fail(exchange, ex);
        }
    }

    protected void copyPropertiesAndAttachments(Exchange exchange, Message in, Message out) throws Exception {
        if (this.isCopyProperties()) {
            out.setHeaders(in.getHeaders());
        }
        if (this.isCopyAttachments()) {
            String attachmentsIn = ((MessageImpl)in)._encodeAttachments();
            ((MessageImpl)out)._decodeAttachments(attachmentsIn);
        }
    }

    public boolean run(Exchange exchange, Message in, Message out) throws Exception {
        return false;
    }
}

