/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jms.activemq.application;

import java.util.ArrayList;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerFactory;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.internal.provider.jms.activemq.Activator;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.osgi.util.tracker.ServiceTracker;

public class ActiveMQJMSServer
implements IApplication {
    private IContainer managerContainer = null;
    private ServiceTracker containerManagerTracker;
    private boolean done = false;
    private Object appLock = new Object();

    private String[] mungeArguments(String[] originalArgs) {
        if (originalArgs == null) {
            return new String[0];
        }
        ArrayList<String> l = new ArrayList<String>();
        int i = 0;
        while (i < originalArgs.length) {
            if (!originalArgs[i].equals("-pdelaunch")) {
                l.add(originalArgs[i]);
            }
            ++i;
        }
        return l.toArray(new String[0]);
    }

    public Object start(IApplicationContext context) throws Exception {
        String[] args = this.mungeArguments((String[])context.getArguments().get("application.args"));
        if (args.length < 1) {
            this.usage();
            return IApplication.EXIT_OK;
        }
        this.managerContainer = this.createContainer("ecf.jms.activemq.tcp.manager", args[0]);
        System.out.println("ActiveMQ Manager started with id=" + this.managerContainer.getID());
        this.waitForDone();
        return IApplication.EXIT_OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void waitForDone() {
        Object object = this.appLock;
        synchronized (object) {
            while (true) {
                if (this.done) {
                    return;
                }
                try {
                    this.appLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.managerContainer != null) {
            this.managerContainer.dispose();
            this.getContainerManager().removeAllContainers();
            this.managerContainer = null;
        }
        if (this.containerManagerTracker != null) {
            this.containerManagerTracker.close();
            this.containerManagerTracker = null;
        }
        Object object = this.appLock;
        synchronized (object) {
            this.done = true;
            this.appLock.notifyAll();
        }
    }

    protected IContainerManager getContainerManager() {
        if (this.containerManagerTracker == null) {
            this.containerManagerTracker = new ServiceTracker(Activator.getDefault().getContext(), IContainerManager.class.getName(), null);
            this.containerManagerTracker.open();
        }
        return (IContainerManager)this.containerManagerTracker.getService();
    }

    protected IContainer createContainer(String containerType, String containerId) throws ContainerCreateException {
        IContainerFactory containerFactory = this.getContainerManager().getContainerFactory();
        return containerId == null ? containerFactory.createContainer(containerType) : containerFactory.createContainer(containerType, new Object[]{containerId});
    }

    private void usage() {
        System.out.println("Usage: eclipse.exe -application " + this.getClass().getName() + "<jmsprotocol>://<jmsserver>:<jmsport>/<jmstopic>");
        System.out.println("   Examples: eclipse -application org.eclipse.ecf.provider.jms.ActiveMQJMSServer tcp://localhost:61616/exampleTopic");
    }
}

