/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jms.activemq.container;

import java.io.IOException;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.provider.comm.ConnectionCreateException;
import org.eclipse.ecf.provider.comm.ISynchAsynchConnection;
import org.eclipse.ecf.provider.jms.channel.AbstractJMSClientChannel;
import org.eclipse.ecf.provider.jms.container.AbstractJMSClient;
import org.eclipse.ecf.provider.jms.container.JMSContainerConfig;
import org.eclipse.ecf.provider.jms.identity.JMSID;

public class ActiveMQJMSClientContainer
extends AbstractJMSClient {
    private int keepAlive;

    private int getKeepAlive() {
        return this.keepAlive;
    }

    public ActiveMQJMSClientContainer(int keepAlive) throws Exception {
        this.keepAlive = keepAlive;
    }

    public ActiveMQJMSClientContainer(String name, int keepAlive) throws Exception {
        super(new JMSContainerConfig(name, keepAlive));
        this.keepAlive = keepAlive;
    }

    protected ISynchAsynchConnection createConnection(ID remoteSpace, Object data) throws ConnectionCreateException {
        return new ActiveMQClientChannel();
    }

    class ActiveMQClientChannel
    extends AbstractJMSClientChannel {
        private static final long serialVersionUID = -5581778054975360068L;

        public ActiveMQClientChannel() {
            super(ActiveMQJMSClientContainer.this.getReceiver(), ActiveMQJMSClientContainer.this.getKeepAlive());
        }

        protected ConnectionFactory createJMSConnectionFactory(JMSID targetID) throws IOException {
            return new ActiveMQConnectionFactory(this.getActiveMQUsername(targetID), this.getActiveMQPassword(targetID), targetID.getName());
        }

        private String getActiveMQPassword(JMSID targetID) {
            String pw = (String)ActiveMQJMSClientContainer.this.getConfig().getProperties().get("password");
            return pw == null ? "defaultPassword" : pw;
        }

        private String getActiveMQUsername(JMSID targetID) {
            String username = (String)ActiveMQJMSClientContainer.this.getConfig().getProperties().get("username");
            return username == null ? "defaultUsername" : username;
        }
    }
}

