/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.filesystem.reader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.ebpm.connectors.filesystem.adapters.IFileAdapter;
import org.eclipse.ebpm.core.AbstractSpagicConnector;
import org.eclipse.ebpm.core.routing.IMessageRouter;
import org.eclipse.ebpm.dirwatcher.SnapshotDirectoryPoller;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemPollerConnector
extends AbstractSpagicConnector {
    protected Logger logger = LoggerFactory.getLogger(FileSystemPollerConnector.class);
    private Timer pollingScheduler = null;
    private TimerTask pollingTask = null;
    private File directory;
    private String extensionFilter;
    private boolean deleteFile = true;
    private long pollingPeriod;
    private ConcurrentHashMap<String, IFileAdapter> marshalers = new ConcurrentHashMap();
    private String marshalerId;
    private ConcurrentHashMap<String, InputStream> openedStream = new ConcurrentHashMap();
    private ConcurrentHashMap<String, File> openedFiles = new ConcurrentHashMap();

    public void init() {
        String directoryString = this.propertyConfigurator.getString("directory");
        this.directory = new File(directoryString);
        this.extensionFilter = this.propertyConfigurator.getString("filter", null);
        this.marshalerId = this.propertyConfigurator.getString("marshaller", "DEFAULT");
        this.pollingPeriod = this.propertyConfigurator.getLong("pollingPeriod", new Long(5000L));
        this.deleteFile = this.propertyConfigurator.getBoolean("flagDeletePolledFile", Boolean.valueOf(true));
    }

    public void start() throws Exception {
        super.start();
        String[] filters = null;
        filters = this.extensionFilter != null ? new String[]{this.extensionFilter} : new String[]{};
        this.pollingTask = new SnapshotDirectoryPoller(this.directory, filters){

            public void fireEvent(File file, String action) {
                try {
                    if (action.equalsIgnoreCase("add")) {
                        IFileAdapter adapter = (IFileAdapter)FileSystemPollerConnector.this.marshalers.get(FileSystemPollerConnector.this.marshalerId);
                        if (!file.isDirectory()) {
                            FileSystemPollerConnector.this.processFile(file, adapter);
                        }
                    }
                }
                catch (Exception e) {
                    FileSystemPollerConnector.this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        };
        this.pollingScheduler = new Timer();
        this.pollingScheduler.schedule(this.pollingTask, new Date(), this.pollingPeriod);
    }

    public void stop() throws Exception {
        super.stop();
        this.pollingScheduler.cancel();
    }

    public void process(Exchange exchange) {
        String exchangeId = exchange.getId();
        InputStream is = this.openedStream.remove(exchangeId);
        if (is == null) {
            throw new Error("Cannot Get The Opened File For Stream for Exchange" + exchangeId);
        }
        try {
            is.close();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        File f = this.openedFiles.remove(exchangeId);
        if (f == null) {
            throw new IllegalStateException("Cannot Get The Opened file Stream for Exchange" + exchangeId);
        }
        if (this.deleteFile && !f.delete()) {
            throw new IllegalStateException("Could not delete file " + f);
        }
    }

    public void processFile(File f, IFileAdapter adapter) {
        try {
            IMessageRouter router = this.getMessageRouter();
            if (!router.isServiceRegistered(this.target)) {
                this.logger.warn("Target Service [" + this.target + "] is not Registered, cannot fire message");
                return;
            }
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(f));
            Exchange exchange = this.createInOnlyExchange();
            Message inMessage = exchange.getIn(true);
            adapter.readFile(exchange, inMessage, (InputStream)stream, f.getCanonicalPath());
            this.openedStream.put(exchange.getId(), stream);
            this.openedFiles.put(exchange.getId(), f);
            this.send(exchange);
        }
        catch (Exception e) {
            this.logger.error("Error in Process File " + e.getMessage(), (Throwable)e);
        }
    }

    public void setMarshaler(IFileAdapter adapter) {
        this.marshalers.put(adapter.getAdapterId(), adapter);
    }

    public void unsetMarshaler(IFileAdapter marshaler) {
        this.marshalers.remove(marshaler.getAdapterId());
    }
}

