/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.components.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import javax.xml.namespace.NamespaceContext;
import org.apache.commons.dbutils.DbUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.eclipse.ebpm.components.jdbc.JDBCComponent;
import org.eclipse.ebpm.components.jdbc.StoreProcedureRunner;
import org.eclipse.ebpm.components.jdbc.config.JDBCQueryConfig;
import org.eclipse.ebpm.components.jdbc.config.QueryParameterConfig;
import org.eclipse.ebpm.components.jdbc.config.XmlResultSetHandler;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;
import org.eclipse.ebpm.xmlutil.DOM4JUtils;
import org.eclipse.ebpm.xmlutil.EXMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StoreProcedureComponent
extends JDBCComponent {
    private static final Logger log = LoggerFactory.getLogger(StoreProcedureComponent.class);

    @Override
    public boolean run(Exchange exchange, Message in, Message out) throws Exception {
        log.info("StoreProcedureComponent Component [" + this.getSpagicId() + "] process Exchange Method");
        List<String> orderedParameterNameList = this.getStringParameterNames(this.queryConfig.getQuery(), this.queryConfig.getMatchParamRegexp());
        String jdbcQuery = this.queryConfig.getQuery().replaceAll(this.queryConfig.getMatchParamRegexp(), "?");
        ArrayList<QueryParameterConfig> queryParametersConfig = this.queryConfig.getQueryParams();
        Object[] results = null;
        Connection conn = null;
        DataSource ds = this.getDataSourceManager().getDataSource(this.dsIdentifier);
        try {
            try {
                conn = ds.getConnection();
                StoreProcedureRunner spRunner = new StoreProcedureRunner();
                results = (Object[])spRunner.call(conn, jdbcQuery, in, queryParametersConfig, orderedParameterNameList, new XmlResultSetHandler(this.queryConfig.getRowsXmlEnvelope(), this.queryConfig.getRowXmlEnvelope()));
            }
            catch (SQLException sqle) {
                if (JDBCQueryConfig.FAULT_FLOW.equals(this.queryConfig.getFaultManagement())) {
                    Message fault = exchange.getFault(true);
                    org.dom4j.Element faultElem = DocumentHelper.createElement((String)"Fault");
                    org.dom4j.Element sqlStateElem = DocumentHelper.createElement((String)"sql-state");
                    sqlStateElem.setText(sqle.getSQLState());
                    org.dom4j.Element errorCodeElem = DocumentHelper.createElement((String)"error-code");
                    errorCodeElem.setText("" + sqle.getErrorCode());
                    faultElem.add(sqlStateElem);
                    faultElem.add(errorCodeElem);
                    fault.setBody(faultElem.asXML());
                    out.setBody(fault.getBody());
                    DbUtils.close((Connection)conn);
                    return true;
                }
                throw sqle;
            }
        }
        finally {
            DbUtils.close((Connection)conn);
        }
        out.setBody(in.getBody());
        String strContent = out.getBodyText();
        Document docContent = DocumentHelper.parseText((String)strContent);
        NamespaceContext nsContextMap = DOM4JUtils.getNamespaceContext((Document)docContent);
        org.w3c.dom.Document docContentDOM = DOM4JUtils.dom4j_to_dom((Document)docContent);
        EXMLUtils xmlUtils = new EXMLUtils(nsContextMap);
        Element contentEnvelop = null;
        if (this.isValidStr(this.queryConfig.getXmlEnvelope())) {
            contentEnvelop = xmlUtils.selectNode((Node)docContentDOM, "/" + this.queryConfig.getXmlEnvelope());
            if (contentEnvelop == null) {
                log.warn("Envelope to enrich not found [/" + this.queryConfig.getXmlEnvelope() + "]: " + "the result will be the original message");
            }
        } else {
            log.info("Xml Envelope is null we will keep the original message ");
        }
        if (this.queryConfig.isEnrichMessage() && contentEnvelop != null) {
            this.getResultsNodes(docContentDOM, results, contentEnvelop, orderedParameterNameList);
            out.setBody(docContent.asXML());
        }
        if (this.queryConfig.isEnrichMessage() && contentEnvelop == null) {
            out.setBody(docContent.asXML());
        } else {
            docContentDOM = xmlUtils.createBuilder().newDocument();
            String resultEnvelop = this.queryConfig.getXmlEnvelope();
            if (!this.isValidStr(resultEnvelop)) {
                resultEnvelop = "ENVELOPE";
            }
            Element el = docContentDOM.createElement(resultEnvelop);
            docContentDOM.appendChild(el);
            this.getResultsNodes(docContentDOM, results, docContentDOM.getDocumentElement(), orderedParameterNameList);
            out.setBody(docContent.asXML());
        }
        return true;
    }

    private void getResultsNodes(org.w3c.dom.Document originalDoc, Object[] results, Element parent, List<String> orderedParameterNameList) {
        Object elemObj = null;
        List<String> output = this.setOutputParameterNameList(orderedParameterNameList);
        int i = 0;
        while (i < results.length) {
            elemObj = results[i];
            if (elemObj instanceof org.dom4j.Element) {
                parent.appendChild((Element)elemObj);
            } else {
                Element elem = originalDoc.createElement(output.get(i));
                elem.setTextContent(elemObj != null ? elemObj.toString() : "");
                parent.appendChild(elem);
            }
            ++i;
        }
    }

    private List<String> setOutputParameterNameList(List<String> orderedParameterNameList) {
        ArrayList<String> orderedOutputParameterNameList = new ArrayList<String>();
        int i = 0;
        while (i < orderedParameterNameList.size()) {
            String paramName = orderedParameterNameList.get(i);
            for (QueryParameterConfig qpc : this.queryConfig.getQueryParams()) {
                if (qpc.getPlaceHolder().compareToIgnoreCase(paramName) != 0 || !qpc.isOutputParam()) continue;
                orderedOutputParameterNameList.add(paramName);
                break;
            }
            ++i;
        }
        return orderedOutputParameterNameList;
    }
}

