/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.metadb.model;

import java.io.Serializable;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.eclipse.ebpm.metadb.model.Property;
import org.eclipse.ebpm.metadb.model.Service;
import org.eclipse.ebpm.metadb.model.TypeService;

@Entity
@Table(name="component")
public class Component
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="component_gen")
    @Column(name="id_component")
    @SequenceGenerator(name="component_gen", sequenceName="seq_component", allocationSize=1)
    private Long idComponent;
    private String name;
    private int state;
    @ManyToOne
    @JoinColumn(name="id_ts")
    private TypeService typeService;
    @ManyToMany(mappedBy="components")
    private List<Property> properties;
    @OneToMany(mappedBy="component")
    private List<Service> services;

    public Component() {
    }

    public Component(TypeService typeService, String name, int state) {
        this.typeService = typeService;
        this.name = name;
        this.state = state;
    }

    public Component(TypeService typeService, String name, int state, List<Service> services, List<Property> properties) {
        this.typeService = typeService;
        this.name = name;
        this.state = state;
        this.services = services;
        this.properties = properties;
    }

    public Long getIdComponent() {
        return this.idComponent;
    }

    public void setIdComponent(Long idComponent) {
        this.idComponent = idComponent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public TypeService getTypeService() {
        return this.typeService;
    }

    public void setTypeService(TypeService typeService) {
        this.typeService = typeService;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public List<Service> getServices() {
        return this.services;
    }

    public void setServices(List<Service> services) {
        this.services = services;
    }
}

