/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.remoteservice.eventadmin;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.event.Event;

public class DistributedEventAdminMessage
implements Serializable {
    private static final long serialVersionUID = 2743430591605178391L;
    private String topic;
    private Map properties;
    private transient Event localEvent;

    public DistributedEventAdminMessage(Event event) throws NotSerializableException {
        this.topic = event.getTopic();
        this.properties = this.createPropertiesFromEvent(event);
    }

    private Map createPropertiesFromEvent(Event event) throws NotSerializableException {
        String[] propertyNames = event.getPropertyNames();
        Hashtable<String, Object> ht = propertyNames == null ? new Hashtable<String, Object>(1) : new Hashtable(propertyNames.length);
        int i = 0;
        while (i < propertyNames.length) {
            Object val = event.getProperty(propertyNames[i]);
            if (!(val instanceof Serializable)) {
                throw new NotSerializableException(NLS.bind((String)"Cannot serialize property value of name={0} and value={1}", (Object)propertyNames[i], (Object)val));
            }
            ht.put(propertyNames[i], val);
            ++i;
        }
        return ht;
    }

    public synchronized Event getEvent() {
        if (this.localEvent == null) {
            this.localEvent = new Event(this.topic, this.properties);
        }
        return this.localEvent;
    }
}

