/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.soap.core.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.ebpm.soap.api.InterceptorChain;
import org.eclipse.ebpm.soap.api.InterceptorProvider;
import org.eclipse.ebpm.soap.api.Message;
import org.eclipse.ebpm.soap.api.model.Binding;
import org.eclipse.ebpm.soap.api.model.Operation;
import org.eclipse.ebpm.soap.core.AbstractInterceptorProvider;
import org.eclipse.ebpm.soap.core.MessageImpl;
import org.eclipse.ebpm.soap.core.PhaseInterceptorChain;

public class AbstractBinding<T extends Operation>
extends AbstractInterceptorProvider
implements Binding<T> {
    private QName interfaceName;
    private Map<QName, T> operations = new HashMap<QName, T>();
    private String location;

    @Override
    public Message createMessage() {
        MessageImpl in = new MessageImpl();
        in.put(Binding.class, this);
        return in;
    }

    @Override
    public Message createMessage(Message request) {
        MessageImpl out = new MessageImpl();
        out.put("request.message", request);
        out.put(Binding.class, this);
        Operation op = request.get(Operation.class);
        if (op != null) {
            out.put(Operation.class, op);
            out.put(org.eclipse.ebpm.soap.api.model.Message.class, op.getOutput());
        }
        return out;
    }

    @Override
    public InterceptorChain getInterceptorChain(InterceptorProvider.Phase phase) {
        PhaseInterceptorChain chain = new PhaseInterceptorChain();
        chain.add(this.getInterceptors(phase));
        return chain;
    }

    @Override
    public QName getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(QName interfaceName) {
        this.interfaceName = interfaceName;
    }

    @Override
    public T getOperation(QName name) {
        return (T)((Operation)this.operations.get(name));
    }

    @Override
    public Collection<T> getOperations() {
        return this.operations.values();
    }

    public void addOperation(T operation) {
        this.operations.put(operation.getName(), operation);
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }
}

