/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.components.base64;

import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.ebpm.core.BaseSpagicService;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Base64Component
extends BaseSpagicService {
    protected Logger logger = LoggerFactory.getLogger(Base64Component.class);
    public String base64 = null;
    public String charset = null;
    public boolean forcedEncoding = false;

    public void init() {
        try {
            this.base64 = this.propertyConfigurator.getString("base64");
            this.charset = "UTF-8";
            this.forcedEncoding = false;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(" Cannot instantiate Base64Component Component", e);
        }
    }

    public boolean run(Exchange exchange, Message in, Message out) throws Exception {
        try {
            Element base64row;
            Document outDocument;
            Document inDocument;
            if (this.base64.equalsIgnoreCase("encoder")) {
                try {
                    inDocument = DocumentHelper.parseText((String)in.getBodyText());
                    outDocument = DocumentHelper.createDocument();
                    base64row = DocumentHelper.createElement((String)"base64");
                    base64row.setText(this.base64EncoderWrapper(inDocument.getDocument().getRootElement().asXML()));
                    outDocument.add(base64row);
                    out.setBody(outDocument.getDocument().getRootElement().asXML());
                }
                catch (DocumentException exx) {
                    if (this.forcedEncoding) {
                        out.setBody("<base64>" + this.base64EncoderWrapper(in.getBodyText()) + "</base64>");
                    }
                    throw new DocumentException("ENCODER: Illegal Xml in Input: " + (Object)((Object)exx));
                }
            }
            if (this.base64.equalsIgnoreCase("decoder")) {
                try {
                    inDocument = DocumentHelper.parseText((String)in.getBodyText());
                    base64row = inDocument.getRootElement();
                    if (base64row == null) {
                        throw new DocumentException("DECODER: NO base64 TAG in Input.");
                    }
                    outDocument = DocumentHelper.parseText((String)this.base64DecoderWrapper(base64row.getText()));
                    out.setBody(outDocument.getDocument().getRootElement().asXML());
                }
                catch (DocumentException exx) {
                    throw new DocumentException("DECODER: Illegal Xml in Input: " + (Object)((Object)exx));
                }
            }
            return true;
        }
        catch (Throwable e) {
            this.logger.error(e.getMessage(), e);
            e.fillInStackTrace();
            throw new Exception();
        }
    }

    public String base64EncoderWrapper(String string) {
        try {
            return new String(Base64.encodeBase64Chunked((byte[])string.getBytes(this.charset)));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("encodeBase64Chunked " + this.charset + ": " + e);
        }
    }

    public String base64DecoderWrapper(String string) {
        if (Base64.isArrayByteBase64((byte[])string.getBytes())) {
            try {
                return new String(Base64.decodeBase64((byte[])string.getBytes()), this.charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("base64DecoderWrapper " + this.charset + " INVALID: " + e);
            }
        }
        return null;
    }
}

