/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.util;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Type;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class ClassTree {
    private List baseclasses = new ArrayList();
    private Map subclasses = new HashMap();
    private List baseinterfaces = new ArrayList();
    private Map subinterfaces = new HashMap();
    private List baseEnums = new ArrayList();
    private Map subEnums = new HashMap();
    private List baseAnnotationTypes = new ArrayList();
    private Map subAnnotationTypes = new HashMap();
    private Map implementingclasses = new HashMap();

    public ClassTree(Configuration configuration, boolean bl) {
        configuration.message.notice("doclet.Building_Tree");
        this.buildTree(configuration.root.classes(), configuration);
    }

    public ClassTree(RootDoc rootDoc, Configuration configuration) {
        this.buildTree(rootDoc.classes(), configuration);
    }

    public ClassTree(ClassDoc[] classDocArray, Configuration configuration) {
        this.buildTree(classDocArray, configuration);
    }

    private void buildTree(ClassDoc[] classDocArray, Configuration configuration) {
        for (int i = 0; i < classDocArray.length; ++i) {
            if (configuration.nodeprecated && classDocArray[i].tags("deprecated").length > 0) continue;
            if (classDocArray[i].isEnum()) {
                this.processType(classDocArray[i], configuration, this.baseEnums, this.subEnums);
                continue;
            }
            if (classDocArray[i].isClass()) {
                this.processType(classDocArray[i], configuration, this.baseclasses, this.subclasses);
                continue;
            }
            if (classDocArray[i].isInterface()) {
                this.processInterface(classDocArray[i]);
                List list = (List)this.implementingclasses.get(classDocArray[i]);
                if (list == null) continue;
                Collections.sort(list);
                continue;
            }
            if (!classDocArray[i].isAnnotationType()) continue;
            this.processType(classDocArray[i], configuration, this.baseAnnotationTypes, this.subAnnotationTypes);
        }
        Collections.sort(this.baseinterfaces);
        Iterator iterator = this.subinterfaces.values().iterator();
        while (iterator.hasNext()) {
            Collections.sort((List)iterator.next());
        }
        iterator = this.subclasses.values().iterator();
        while (iterator.hasNext()) {
            Collections.sort((List)iterator.next());
        }
    }

    private void processType(ClassDoc classDoc, Configuration configuration, List list, Map map) {
        ClassDoc classDoc2 = Util.getFirstVisibleSuperClassCD(classDoc, configuration);
        if (classDoc2 != null) {
            if (!this.add(map, classDoc2, classDoc)) {
                return;
            }
            this.processType(classDoc2, configuration, list, map);
        } else if (!list.contains(classDoc)) {
            list.add(classDoc);
        }
        List list2 = Util.getAllInterfaces(classDoc, configuration);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            this.add(this.implementingclasses, ((Type)iterator.next()).asClassDoc(), classDoc);
        }
    }

    private void processInterface(ClassDoc classDoc) {
        ClassDoc[] classDocArray = classDoc.interfaces();
        if (classDocArray.length > 0) {
            for (int i = 0; i < classDocArray.length; ++i) {
                if (!this.add(this.subinterfaces, classDocArray[i], classDoc)) {
                    return;
                }
                this.processInterface(classDocArray[i]);
            }
        } else if (!this.baseinterfaces.contains(classDoc)) {
            this.baseinterfaces.add(classDoc);
        }
    }

    private boolean add(Map map, ClassDoc classDoc, ClassDoc classDoc2) {
        ArrayList<ClassDoc> arrayList = (ArrayList<ClassDoc>)map.get(classDoc);
        if (arrayList == null) {
            arrayList = new ArrayList<ClassDoc>();
            map.put(classDoc, arrayList);
        }
        if (arrayList.contains(classDoc2)) {
            return false;
        }
        arrayList.add(classDoc2);
        return true;
    }

    private List get(Map map, ClassDoc classDoc) {
        List list = (List)map.get(classDoc);
        if (list == null) {
            return new ArrayList();
        }
        return list;
    }

    public List subclasses(ClassDoc classDoc) {
        return this.get(this.subclasses, classDoc);
    }

    public List subinterfaces(ClassDoc classDoc) {
        return this.get(this.subinterfaces, classDoc);
    }

    public List implementingclasses(ClassDoc classDoc) {
        List list = this.get(this.implementingclasses, classDoc);
        List list2 = this.allSubs(classDoc, false);
        ListIterator listIterator = list2.listIterator();
        while (listIterator.hasNext()) {
            ListIterator listIterator2 = this.implementingclasses((ClassDoc)listIterator.next()).listIterator();
            while (listIterator2.hasNext()) {
                ClassDoc classDoc2 = (ClassDoc)listIterator2.next();
                if (list.contains(classDoc2)) continue;
                list.add(classDoc2);
            }
        }
        Collections.sort(list);
        return list;
    }

    public List subs(ClassDoc classDoc, boolean bl) {
        if (bl) {
            return this.get(this.subEnums, classDoc);
        }
        if (classDoc.isAnnotationType()) {
            return this.get(this.subAnnotationTypes, classDoc);
        }
        if (classDoc.isInterface()) {
            return this.get(this.subinterfaces, classDoc);
        }
        if (classDoc.isClass()) {
            return this.get(this.subclasses, classDoc);
        }
        return null;
    }

    public List allSubs(ClassDoc classDoc, boolean bl) {
        List list = this.subs(classDoc, bl);
        for (int i = 0; i < list.size(); ++i) {
            classDoc = (ClassDoc)list.get(i);
            List list2 = this.subs(classDoc, bl);
            for (int j = 0; j < list2.size(); ++j) {
                ClassDoc classDoc2 = (ClassDoc)list2.get(j);
                if (list.contains(classDoc2)) continue;
                list.add(classDoc2);
            }
        }
        Collections.sort(list);
        return list;
    }

    public List baseclasses() {
        return this.baseclasses;
    }

    public List baseinterfaces() {
        return this.baseinterfaces;
    }

    public List baseEnums() {
        return this.baseEnums;
    }

    public List baseAnnotationTypes() {
        return this.baseAnnotationTypes;
    }
}

