/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.di.context.internal;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.fx.core.Callback;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.adapter.AdapterService;
import org.eclipse.fx.core.di.ContextBoundValue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class EclipseContextBoundValue<T>
implements ContextBoundValue<T> {
    @NonNull
    private IEclipseContext context;
    @Nullable
    private String contextKey;
    @Nullable
    List<Callback<T>> callbacks;
    @Nullable
    List<Callback<Void>> disposalCallbacks;
    @NonNull
    private AdapterService adapterService;
    @Nullable
    private T value;

    @Inject
    public EclipseContextBoundValue(@NonNull IEclipseContext context, @NonNull AdapterService adapterService) {
        this.context = context;
        this.adapterService = adapterService;
    }

    public void setContextKey(final @NonNull String contextKey) {
        this.contextKey = contextKey;
        this.context.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                EclipseContextBoundValue.this.setCurrentValue(context.get(contextKey));
                return true;
            }
        });
    }

    void setCurrentValue(@Nullable T o) {
        this.value = o;
        if (this.callbacks != null) {
            Callback[] callbackArray = this.callbacks.toArray(new Callback[0]);
            int n = callbackArray.length;
            int n2 = 0;
            while (n2 < n) {
                Callback c = callbackArray[n2];
                c.call(o);
                ++n2;
            }
        }
    }

    @Nullable
    public T getValue() {
        return this.value;
    }

    public void publish(@Nullable T value) {
        this.context.modify(this.contextKey, value);
    }

    public Subscription subscribeOnValueChange(final Callback<T> callback) {
        if (this.callbacks == null) {
            this.callbacks = new ArrayList<Callback<T>>();
        }
        if (this.callbacks != null) {
            this.callbacks.add(callback);
        }
        return new Subscription(){

            public void dispose() {
                List callbacks = EclipseContextBoundValue.this.callbacks;
                if (callbacks != null) {
                    callbacks.remove(callback);
                }
            }
        };
    }

    public Subscription subscribeOnDispose(final Callback<Void> callback) {
        if (this.disposalCallbacks == null) {
            this.disposalCallbacks = new ArrayList<Callback<Void>>();
        }
        if (this.disposalCallbacks != null) {
            this.disposalCallbacks.add(callback);
        }
        return new Subscription(){

            public void dispose() {
                List<Callback<Void>> disposalCallbacks = EclipseContextBoundValue.this.disposalCallbacks;
                if (disposalCallbacks != null) {
                    disposalCallbacks.remove(callback);
                }
            }
        };
    }

    public <A> A adaptTo(Class<A> adapt) {
        return (A)this.adapterService.adapt((Object)this, adapt, new AdapterService.ValueAccess[]{new ValueAccessImpl(this.context)});
    }

    public boolean canAdaptTo(Class<?> adapt) {
        return this.adapterService.canAdapt((Object)this, adapt);
    }

    @PreDestroy
    void dispose() {
        List<Callback<Void>> disposalCallbacks = this.disposalCallbacks;
        if (disposalCallbacks != null) {
            Callback[] callbackArray = disposalCallbacks.toArray(new Callback[0]);
            int n = callbackArray.length;
            int n2 = 0;
            while (n2 < n) {
                Callback callback = callbackArray[n2];
                callback.call(null);
                ++n2;
            }
            disposalCallbacks.clear();
        }
        if (this.callbacks != null) {
            this.callbacks.clear();
        }
        this.value = null;
    }

    static class ValueAccessImpl
    implements AdapterService.ValueAccess {
        private final IEclipseContext context;

        public ValueAccessImpl(IEclipseContext context) {
            this.context = context;
        }

        public <O> O getValue(String key) {
            return (O)this.context.get(key);
        }

        public <O> O getValue(Class<O> key) {
            return (O)this.context.get(key);
        }
    }
}

