/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base.addons;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WCallback;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMinMaxableWidget;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class MinMaxAddon {
    @Inject
    IEventBroker eventBroker;
    static String MINIMIZED = "Minimized";
    static String MAXIMIZED = "Maximized";
    private EventHandler widgetListener = new EventHandler(){

        public void handleEvent(Event event) {
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (!(changedElement instanceof MPartStack) && !(changedElement instanceof MArea)) {
                return;
            }
            WMinMaxableWidget widget = this.getWidget(changedElement);
            if (widget == null) {
                return;
            }
            this.adjustState(changedElement, widget);
            widget.setMinMaxCallback(new WCallback<WMinMaxableWidget.WMinMaxState, Void>(){

                @Override
                public Void call(WMinMaxableWidget.WMinMaxState param) {
                    return null;
                }
            });
        }

        private void adjustState(MUIElement changedElement, WMinMaxableWidget widget) {
            if (changedElement.getTags().contains(MAXIMIZED)) {
                widget.setMinMaxState(WMinMaxableWidget.WMinMaxState.MAXIMIZED);
            } else if (changedElement.getTags().contains(MINIMIZED)) {
                widget.setMinMaxState(WMinMaxableWidget.WMinMaxState.MINIMIZED);
            } else {
                widget.setMinMaxState(WMinMaxableWidget.WMinMaxState.RESTORED);
            }
        }

        private WMinMaxableWidget getWidget(MUIElement changedElement) {
            if (changedElement instanceof MPlaceholder) {
                return this.getWidget(((MPlaceholder)changedElement).getRef());
            }
            if (changedElement.getWidget() instanceof WMinMaxableWidget) {
                return (WMinMaxableWidget)changedElement.getWidget();
            }
            return null;
        }
    };

    @PostConstruct
    void hookListeners() {
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/widget/*", this.widgetListener);
    }
}

