/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.analysis;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.analysis.IContextProvider;
import org.eclipse.xtext.serializer.analysis.TypeFinderNFAProvider;
import org.eclipse.xtext.util.EmfFormatter;

@Singleton
public class ContextProvider
implements IContextProvider {
    @Inject
    protected TypeFinderNFAProvider nfaProvider2;

    protected void collectTypesForContext(TypeFinderNFAProvider.TypeFinderState state, Set<EClass> types, boolean allowLocal, boolean hasAssignment, Set<Object> visited) {
        boolean bl = hasAssignment = hasAssignment || state.getGrammarElement() instanceof Assignment;
        if (allowLocal && state.getGrammarElement() instanceof Action) {
            types.add((EClass)((Action)state.getGrammarElement()).getType().getClassifier());
            return;
        }
        if (state.isEndState() && !GrammarUtil.isUnassignedEObjectRuleCall(state.getGrammarElement())) {
            if (hasAssignment) {
                types.add((EClass)GrammarUtil.containingRule(state.getGrammarElement()).getType().getClassifier());
            } else {
                types.add(null);
            }
        }
        if (!visited.add(state)) {
            return;
        }
        for (TypeFinderNFAProvider.TypeFinderTransition t : state.getAllOutgoing()) {
            if (t.isRuleCall() && state.getGrammarElement() instanceof Assignment) continue;
            this.collectTypesForContext((TypeFinderNFAProvider.TypeFinderState)t.getTarget(), types, true, hasAssignment, visited);
        }
    }

    @Override
    public List<EObject> getAllContexts(Grammar grammar) {
        ArrayList result = Lists.newArrayList();
        for (ParserRule pr : GrammarUtil.allParserRules(grammar)) {
            if (!GrammarUtil.isEObjectRule(pr)) continue;
            result.add(pr);
            for (Action action : GrammarUtil.containedActions(pr)) {
                if (!GrammarUtil.isAssignedAction(action)) continue;
                result.add(action);
            }
        }
        return result;
    }

    @Override
    public Set<EClass> getTypesForContext(EObject context) {
        HashSet result = Sets.newHashSet();
        if (context instanceof AbstractElement) {
            AbstractElement ele = (AbstractElement)context;
            this.collectTypesForContext((TypeFinderNFAProvider.TypeFinderState)this.nfaProvider2.getNFA(ele), result, false, false, Sets.newHashSet());
        } else if (context instanceof AbstractRule) {
            AbstractElement ele = ((AbstractRule)context).getAlternatives();
            this.collectTypesForContext((TypeFinderNFAProvider.TypeFinderState)this.nfaProvider2.getNFA(ele), result, true, false, Sets.newHashSet());
            if (GrammarUtil.isOptionalCardinality(ele)) {
                result.add(null);
            }
        } else {
            throw new RuntimeException("This is not a valid context: " + EmfFormatter.objPath((EObject)context));
        }
        return result;
    }
}

