/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext;

import com.sun.javafx.css.converters.PaintConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.ParsedValue;
import javafx.css.SimpleStyleableIntegerProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextBoundsType;
import org.eclipse.fx.core.Util;
import org.eclipse.fx.ui.controls.styledtext.DecorationStrategyFactory;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class StyledTextNode
extends Region {
    private static final @NonNull CssMetaData<StyledTextNode, @NonNull Paint> FILL = new CssMetaData<StyledTextNode, Paint>("-fx-fill", PaintConverter.getInstance(), (Paint)Color.BLACK){

        public boolean isSettable(StyledTextNode styleable) {
            return !styleable.fillProperty().isBound();
        }

        public StyleableProperty<@NonNull Paint> getStyleableProperty(StyledTextNode styleable) {
            return (StyleableProperty)styleable.fill;
        }
    };
    final @NonNull ObjectProperty<@NonNull Paint> fill = new SimpleStyleableObjectProperty(FILL, (Object)this, "fill", (Object)Color.BLACK);
    private static final @NonNull DecorationStyleConverter CONVERTER = new DecorationStyleConverter();
    private static final @NonNull CssMetaData<StyledTextNode, @Nullable DecorationStrategy> DECORATIONSTRATEGY = new CssMetaData<StyledTextNode, DecorationStrategy>("-efx-decoration", (StyleConverter)CONVERTER, null){

        public boolean isSettable(StyledTextNode node) {
            return !node.decorationStrategyProperty().isBound();
        }

        public StyleableProperty<@Nullable DecorationStrategy> getStyleableProperty(StyledTextNode node) {
            return (StyleableProperty)node.decorationStrategyProperty();
        }
    };
    private static final @NonNull CssMetaData<StyledTextNode, @NonNull Number> TABCHARADANCE = new CssMetaData<StyledTextNode, Number>("-efx-tab-char-advance", StyleConverter.getSizeConverter(), (Number)4){

        public boolean isSettable(StyledTextNode styleable) {
            return !styleable.tabCharAdvanceProperty().isBound();
        }

        public StyleableProperty<@NonNull Number> getStyleableProperty(StyledTextNode styleable) {
            return (StyleableProperty)styleable.tabCharAdvance;
        }
    };
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;
    private @NonNull ObjectProperty<@Nullable DecorationStrategy> decorationStrategy = new SimpleStyleableObjectProperty(DECORATIONSTRATEGY, (Object)this, "decorationStrategy");
    @NonNull IntegerProperty tabCharAdvance = new SimpleStyleableIntegerProperty(TABCHARADANCE, (Object)this, "tabCharAdvance", Integer.valueOf(4));
    private int startOffset;
    private List<Integer> tabPositions = new ArrayList<Integer>();
    private String originalText;
    private final HBox textNode;

    static {
        ArrayList<Object> styleables = new ArrayList<Object>(Region.getClassCssMetaData());
        styleables.add(DECORATIONSTRATEGY);
        styleables.add(FILL);
        STYLEABLES = Collections.unmodifiableList(styleables);
    }

    public final @NonNull ObjectProperty<@NonNull Paint> fillProperty() {
        return this.fill;
    }

    public final @NonNull Paint getFill() {
        return (Paint)this.fillProperty().get();
    }

    public final void setFill(@NonNull Paint color) {
        this.fillProperty().set((Object)color);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return StyledTextNode.getClassCssMetaData();
    }

    public final @NonNull ObjectProperty<@Nullable DecorationStrategy> decorationStrategyProperty() {
        return this.decorationStrategy;
    }

    public final @Nullable DecorationStrategy getDecorationStrategy() {
        return (DecorationStrategy)this.decorationStrategyProperty().get();
    }

    public final void setDecorationStrategy(@Nullable DecorationStrategy strategy) {
        this.decorationStrategyProperty().set((Object)strategy);
    }

    public final IntegerProperty tabCharAdvanceProperty() {
        return this.tabCharAdvance;
    }

    public final int getTabCharAdvance() {
        return this.tabCharAdvanceProperty().get();
    }

    public final void setTabCharAdvance(int tabCharAdvance) {
        this.tabCharAdvanceProperty().set(tabCharAdvance);
    }

    public StyledTextNode(String text) {
        this.getStyleClass().add((Object)"styled-text-node");
        this.originalText = text;
        this.textNode = new HBox();
        this.textNode.getChildren().setAll(this.rebuildText(text));
        this.getChildren().add((Object)this.textNode);
        this.decorationStrategy.addListener(this::handleDecorationChange);
        this.tabCharAdvance.addListener(o -> this.textNode.getChildren().setAll(this.rebuildText(text)));
    }

    private List<Text> rebuildText(String text) {
        ArrayList<Text> l = new ArrayList<Text>();
        char[] cArray = this.processText(text).toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            Text textNode = new Text(String.valueOf(c));
            textNode.setBoundsType(TextBoundsType.LOGICAL_VERTICAL_CENTER);
            textNode.fillProperty().bind(this.fillProperty());
            l.add(textNode);
            ++n2;
        }
        return l;
    }

    private String processText(String text) {
        String tmp = text;
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < this.tabCharAdvance.get()) {
            b.append(" ");
            ++i;
        }
        int position = -1;
        this.tabPositions.clear();
        while ((position = tmp.indexOf(9)) != -1) {
            tmp = tmp.replaceFirst("\t", b.toString());
            this.tabPositions.add(position);
        }
        return tmp;
    }

    private void handleDecorationChange(ObservableValue<? extends DecorationStrategy> observable, DecorationStrategy oldValue, DecorationStrategy newValue) {
        if (oldValue != null) {
            oldValue.unattach(this, (Node)this.textNode);
        }
        if (newValue != null) {
            newValue.attach(this, (Node)this.textNode);
        }
    }

    void setStartOffset(int startOffset) {
        this.startOffset = startOffset;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.startOffset + this.getText().length();
    }

    public boolean intersectOffset(int start, int end) {
        if (this.getStartOffset() > end) {
            return false;
        }
        return this.getEndOffset() >= start;
    }

    public String toString() {
        return "'" + this.originalText + "'";
    }

    public ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    public String getText() {
        return this.originalText;
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.textNode.relocate(0.0, 0.0);
        DecorationStrategy decorationStrategy2 = (DecorationStrategy)this.decorationStrategy.get();
        if (decorationStrategy2 != null) {
            decorationStrategy2.layout(this, (Node)this.textNode);
        }
    }

    public int getCaretIndexAtPoint(Point2D point) {
        Point2D local = this.textNode.sceneToLocal(this.localToScene(point));
        Optional<Node> charNode = this.textNode.getChildren().stream().filter(n -> n.getBoundsInParent().contains(local)).findFirst();
        if (charNode.isPresent()) {
            Node node = charNode.get();
            int idx = this.textNode.getChildren().indexOf((Object)node);
            Bounds bounds = node.getBoundsInParent();
            if (bounds.getMinX() + bounds.getWidth() / 2.0 < local.getX()) {
                ++idx;
            }
            int toRemove = 0;
            for (Integer i : this.tabPositions) {
                if (i <= idx && idx < i + this.tabCharAdvance.get()) {
                    toRemove += idx - i;
                    if ((idx - i) % this.tabCharAdvance.get() < this.tabCharAdvance.get() / 2) break;
                    ++idx;
                    break;
                }
                if (i >= idx) continue;
                toRemove += this.tabCharAdvance.get() - 1;
            }
            return idx -= toRemove;
        }
        return -1;
    }

    public double getCharLocation(int index) {
        int realIndex = index;
        for (Integer i : this.tabPositions) {
            if (i >= realIndex) continue;
            realIndex += this.tabCharAdvance.get() - 1;
        }
        if (realIndex >= 0 && realIndex < this.textNode.getChildren().size()) {
            return this.textNode.localToParent(((Node)this.textNode.getChildren().get(realIndex)).getBoundsInParent()).getMinX();
        }
        if (!this.textNode.getChildren().isEmpty()) {
            return this.textNode.localToParent(((Node)this.textNode.getChildren().get(this.textNode.getChildren().size() - 1)).getBoundsInParent()).getMaxX();
        }
        return 0.0;
    }

    public static interface DecorationStrategy {
        public void attach(StyledTextNode var1, Node var2);

        public void unattach(StyledTextNode var1, Node var2);

        public void layout(StyledTextNode var1, Node var2);
    }

    static class DecorationStyleConverter
    extends StyleConverter<ParsedValue<?, DecorationStrategy>, DecorationStrategy> {
        private static Map<String, DecorationStrategyFactory> FACTORIES;

        DecorationStyleConverter() {
        }

        public DecorationStrategy convert(ParsedValue<ParsedValue<?, DecorationStrategy>, DecorationStrategy> value, Font font) {
            String type;
            DecorationStrategyFactory strategy;
            String definition = "" + value.getValue();
            if (FACTORIES == null) {
                FACTORIES = Util.lookupServiceList(((Object)((Object)this)).getClass(), DecorationStrategyFactory.class).stream().sorted((f1, f2) -> -1 * Integer.compare(f1.getRanking(), f2.getRanking())).collect(Collectors.toMap(f -> f.getDecorationStrategyName(), f -> f));
            }
            if ((strategy = FACTORIES.get(type = definition.contains("(") ? definition.substring(0, definition.indexOf(40)) : String.valueOf(definition))) != null) {
                return strategy.create(definition.contains("(") ? definition.substring(definition.indexOf(40) + 1, definition.lastIndexOf(41)) : null);
            }
            return null;
        }
    }
}

