/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.fx;

import jakarta.inject.Inject;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.input.DragEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import org.eclipse.fx.code.editor.services.EditorOpener;
import org.eclipse.fx.core.preferences.Preference;
import org.eclipse.fx.core.preferences.Value;
import org.eclipse.fx.ui.controls.filesystem.DirItem;
import org.eclipse.fx.ui.controls.filesystem.FileItem;
import org.eclipse.fx.ui.controls.filesystem.ResourceEvent;
import org.eclipse.fx.ui.controls.filesystem.ResourceItem;
import org.eclipse.fx.ui.controls.filesystem.ResourceTreeView;

public class FilesystemViewer {
    @Inject
    EditorOpener textEditorOpener;
    private final ObservableList<DirItem> rootDirectories = FXCollections.observableArrayList();
    private final RootResourceList resourceList;
    private Value<RootResourceList> value;

    @Inject
    public FilesystemViewer(@Preference(key="rootPaths") Value<RootResourceList> value) {
        this.value = value;
        RootResourceList resourceList = (RootResourceList)value.getValue();
        if (resourceList == null) {
            resourceList = new RootResourceList();
        }
        this.resourceList = resourceList;
    }

    @Inject
    public void initUI(BorderPane pane) {
        this.rootDirectories.addAll((Collection)this.resourceList.resourceList.stream().map(p -> Paths.get(URI.create(p))).filter(p -> Files.exists(p, new LinkOption[0])).map(p -> ResourceItem.createObservedPath((Path)p)).collect(Collectors.toList()));
        ResourceTreeView viewer = new ResourceTreeView();
        viewer.setRootDirectories(this.rootDirectories);
        viewer.addEventHandler(ResourceEvent.openResourceEvent(), this::handleEvent);
        viewer.setOnDragDropped(this::handleDrop);
        viewer.setOnDragOver(this::handleDragOver);
        pane.setCenter((Node)viewer);
    }

    private void handleDragOver(DragEvent e) {
        if (e.getDragboard().hasFiles()) {
            e.acceptTransferModes(TransferMode.ANY);
        }
    }

    private void handleDrop(DragEvent e) {
        if (e.getDragboard().hasFiles()) {
            this.addDirectories(e.getDragboard().getFiles().stream().filter(f -> f.isDirectory()).map(f -> f.toPath()).collect(Collectors.toList()));
        }
    }

    private void addDirectories(List<Path> pathList) {
        this.rootDirectories.addAll((Collection)pathList.stream().filter(p -> Files.isDirectory(p, new LinkOption[0])).map(p -> ResourceItem.createObservedPath((Path)p)).collect(Collectors.toList()));
        this.value.publish((Object)new RootResourceList((List<DirItem>)this.rootDirectories));
    }

    private void handleEvent(ResourceEvent<ResourceItem> e) {
        e.getResourceItems().stream().filter(r -> r instanceof FileItem).map(r -> (FileItem)r).forEach(this::handle);
    }

    private void handle(FileItem item) {
        this.textEditorOpener.openEditor(item.getUri());
    }

    @XmlRootElement
    public static class RootResourceList {
        private List<String> resourceList = new ArrayList<String>();

        public RootResourceList() {
        }

        public RootResourceList(List<DirItem> pathList) {
            this.resourceList.addAll(pathList.stream().map(p -> p.getUri()).collect(Collectors.toList()));
        }

        @XmlElement(name="resourceList")
        public List<String> getResourceList() {
            return this.resourceList;
        }
    }
}

