/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.configuration.gson;

import com.google.gson.JsonObject;
import org.eclipse.fx.code.editor.configuration.Check;
import org.eclipse.fx.code.editor.configuration.EditorGModel;
import org.eclipse.fx.code.editor.configuration.Range;
import org.eclipse.fx.code.editor.configuration.gson.GsonBase;

public final class GsonRangeImpl
implements GsonBase,
Range,
Check {
    private final int max;
    private final boolean maxIncl;
    private final int min;
    private final boolean minIncl;

    public GsonRangeImpl(JsonObject jsonObject) {
        this.max = jsonObject.has("max") ? jsonObject.get("max").getAsInt() : 1;
        this.maxIncl = jsonObject.has("maxIncl") ? jsonObject.get("maxIncl").getAsBoolean() : false;
        this.min = jsonObject.has("min") ? jsonObject.get("min").getAsInt() : 1;
        this.minIncl = jsonObject.has("minIncl") ? jsonObject.get("minIncl").getAsBoolean() : false;
    }

    public GsonRangeImpl(int max, boolean maxIncl, int min, boolean minIncl) {
        this.max = max;
        this.maxIncl = maxIncl;
        this.min = min;
        this.minIncl = minIncl;
    }

    @Override
    public JsonObject toJSONObject() {
        JsonObject o = new JsonObject();
        o.addProperty("$gtype", "Range");
        o.addProperty("max", (Number)this.getMax());
        o.addProperty("maxIncl", Boolean.valueOf(this.isMaxIncl()));
        o.addProperty("min", (Number)this.getMin());
        o.addProperty("minIncl", Boolean.valueOf(this.isMinIncl()));
        return o;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + " { max : " + this.max + ", maxIncl : " + this.maxIncl + ", min : " + this.min + ", minIncl : " + this.minIncl + " }";
    }

    @Override
    public int getMax() {
        return this.max;
    }

    @Override
    public boolean isMaxIncl() {
        return this.maxIncl;
    }

    @Override
    public int getMin() {
        return this.min;
    }

    @Override
    public boolean isMinIncl() {
        return this.minIncl;
    }

    public static class Builder
    implements Range.Builder {
        private final EditorGModel instance;
        private int max;
        private boolean maxIncl;
        private int min;
        private boolean minIncl;

        public Builder(EditorGModel instance) {
            this.instance = instance;
        }

        @Override
        public Builder max(int max) {
            this.max = max;
            return this;
        }

        @Override
        public Builder maxIncl(boolean maxIncl) {
            this.maxIncl = maxIncl;
            return this;
        }

        @Override
        public Builder min(int min) {
            this.min = min;
            return this;
        }

        @Override
        public Builder minIncl(boolean minIncl) {
            this.minIncl = minIncl;
            return this;
        }

        @Override
        public Range build() {
            return new GsonRangeImpl(this.max, this.maxIncl, this.min, this.minIncl);
        }
    }
}

