/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.validation;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.SimpleAttributeResolver;
import org.eclipse.xtext.validation.INamesAreUniqueValidationHelper;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;

public class NamesAreUniqueValidationHelper
implements INamesAreUniqueValidationHelper {
    private ImmutableSet<EClass> clusterTypes = this.getClusterTypes();
    @Inject
    private OperationCanceledManager operationCanceledManager = new OperationCanceledManager();

    protected ImmutableSet<EClass> getClusterTypes() {
        return ImmutableSet.of((Object)EcorePackage.Literals.EOBJECT);
    }

    @Override
    public void checkUniqueNames(Iterable<IEObjectDescription> descriptions, ValidationMessageAcceptor acceptor) {
        this.checkUniqueNames(descriptions, null, acceptor);
    }

    @Override
    public void checkUniqueNames(Iterable<IEObjectDescription> descriptions, CancelIndicator cancelIndicator, ValidationMessageAcceptor acceptor) {
        Iterator<IEObjectDescription> iter = descriptions.iterator();
        if (!iter.hasNext()) {
            return;
        }
        HashMap clusterToNames = Maps.newHashMap();
        while (iter.hasNext()) {
            IEObjectDescription description = iter.next();
            this.checkDescriptionForDuplicatedName(description, clusterToNames, acceptor);
            this.operationCanceledManager.checkCanceled(cancelIndicator);
        }
    }

    protected void checkDescriptionForDuplicatedName(IEObjectDescription description, Map<EClass, Map<QualifiedName, IEObjectDescription>> clusterTypeToName, ValidationMessageAcceptor acceptor) {
        EObject object = description.getEObjectOrProxy();
        EClass eClass = object.eClass();
        QualifiedName qualifiedName = description.getName();
        EClass clusterType = this.getAssociatedClusterType(eClass);
        HashMap nameToDescription = clusterTypeToName.get(clusterType);
        if (nameToDescription == null) {
            nameToDescription = Maps.newHashMap();
            nameToDescription.put(qualifiedName, description);
            clusterTypeToName.put(clusterType, nameToDescription);
        } else if (nameToDescription.containsKey(qualifiedName)) {
            IEObjectDescription prevDescription = (IEObjectDescription)nameToDescription.get(qualifiedName);
            if (prevDescription != null) {
                this.createDuplicateNameError(prevDescription, clusterType, acceptor);
                nameToDescription.put(qualifiedName, null);
            }
            this.createDuplicateNameError(description, clusterType, acceptor);
        } else {
            nameToDescription.put(qualifiedName, description);
        }
    }

    protected void createDuplicateNameError(IEObjectDescription description, EClass clusterType, ValidationMessageAcceptor acceptor) {
        EObject object = description.getEObjectOrProxy();
        EStructuralFeature feature = this.getNameFeature(object);
        acceptor.acceptError(this.getDuplicateNameErrorMessage(description, clusterType, feature), object, feature, -1, this.getErrorCode(), new String[0]);
    }

    protected String getErrorCode() {
        return null;
    }

    public String getDuplicateNameErrorMessage(IEObjectDescription description, EClass clusterType, EStructuralFeature feature) {
        EStructuralFeature containerNameFeature;
        String containerTypeLabel;
        EObject container;
        EObject object = description.getEObjectOrProxy();
        String shortName = String.valueOf(feature != null ? object.eGet(feature) : "<unnamed>");
        StringBuilder result = new StringBuilder(64);
        result.append("Duplicate ");
        result.append(this.getTypeLabel(clusterType));
        result.append(" '");
        result.append(shortName);
        result.append("'");
        if (this.isContainerInformationHelpful(description, shortName) && (container = this.getContainerForErrorMessage(object)) != null && this.isContainerInformationHelpful(description, container, containerTypeLabel = this.getTypeLabel(container.eClass()), containerNameFeature = this.getNameFeature(container))) {
            String containerName;
            result.append(" in ");
            result.append(containerTypeLabel);
            if (containerNameFeature != null && (containerName = String.valueOf(container.eGet(containerNameFeature))) != null) {
                result.append(" '");
                result.append(containerName);
                result.append("'");
            }
        }
        return result.toString();
    }

    protected boolean isContainerInformationHelpful(IEObjectDescription description, EObject container, String containerTypeLabel, EStructuralFeature containerNameFeature) {
        return containerTypeLabel != null && containerNameFeature != null;
    }

    protected boolean isContainerInformationHelpful(IEObjectDescription description, String shortName) {
        return true;
    }

    protected EObject getContainerForErrorMessage(EObject object) {
        return object.eContainer();
    }

    protected String getTypeLabel(EClass eClass) {
        String name = eClass.getName();
        return name;
    }

    protected EStructuralFeature getNameFeature(EObject object) {
        return SimpleAttributeResolver.NAME_RESOLVER.getAttribute(object);
    }

    protected EClass getAssociatedClusterType(EClass eClass) {
        if (this.clusterTypes.contains((Object)eClass)) {
            return eClass;
        }
        EList superTypes = eClass.getESuperTypes();
        if (superTypes.isEmpty()) {
            return eClass;
        }
        return this.getAssociatedClusterType((EClass)superTypes.get(0));
    }
}

