/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.fx.core.Resource;
import org.eclipse.fx.core.ServiceUtils;
import org.eclipse.fx.core.URLResolver;
import org.eclipse.fx.core.function.ExExecutor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class IOUtils {
    public static String readToString(InputStream in, Charset charset) {
        return IOUtils.readToString(in, 1024, charset);
    }

    public static String readToString(InputStream in, int bufferLength, Charset charset) {
        StringBuilder b = new StringBuilder();
        char[] buf = new char[bufferLength];
        InputStreamReader r = new InputStreamReader(in, charset);
        try {
            int l;
            while ((l = r.read(buf, 0, bufferLength)) != -1) {
                b.append(buf, 0, l);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return b.toString();
    }

    public static void copyToStream(InputStream sourceStream, OutputStream targetStream) throws IOException {
        int l;
        byte[] buf = new byte[1024];
        while ((l = sourceStream.read(buf)) != -1) {
            targetStream.write(buf, 0, l);
        }
    }

    public static @NonNull Path zipDirectory(@NonNull Path dir, @Nullable Path zipFile) throws IOException {
        Path target = zipFile;
        if (target == null) {
            target = Files.createTempFile("generated-zip", ".zip", new FileAttribute[0]);
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(target, new OpenOption[0]));){
            for (Path c : Files.list(dir).collect(Collectors.toList())) {
                if (c.equals(target)) continue;
                IOUtils.addEntry(out, dir, c);
            }
            out.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return target;
    }

    public static String slurpFileContent(Path path) throws IOException {
        byte[] buf = new byte[(int)Files.size(path)];
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            in.read(buf);
            return new String(buf);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Optional<Resource<@NonNull Path>> getLocalPath(@NonNull URL url, boolean copyIfNeeded) {
        return ServiceUtils.getServiceList(URLResolver.class).stream().filter(r -> r.test(url)).findFirst().map(r -> Optional.of(Resource.createResource(r.resolveToLocalPath(url)))).orElseGet(() -> copyIfNeeded ? ExExecutor.executeSupplier(() -> IOUtils.copyToTempFile(url), "Unable to copy resource") : Optional.empty());
    }

    public static Optional<URL> getLocalURL(@NonNull URL url) {
        return ServiceUtils.getServiceList(URLResolver.class).stream().filter(r -> r.test(url)).findFirst().map(r -> r.resolveToLocalURL(url));
    }

    private static Resource<@NonNull Path> copyToTempFile(@NonNull URL url) throws IOException {
        Path path = Files.createTempFile("tmp", Paths.get(url.getPath(), new String[0]).getFileName().toString(), new FileAttribute[0]);
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream stream = url.openStream();){
            Files.copy(stream, path, new CopyOption[0]);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (path == null) {
            return null;
        }
        return Resource.createTempResource(path);
    }

    private static void addEntry(ZipOutputStream out, Path rootPath, Path p) throws IOException {
        if (Files.isDirectory(p, new LinkOption[0])) {
            for (Path c : Files.list(p).collect(Collectors.toList())) {
                IOUtils.addEntry(out, rootPath, c);
            }
        } else {
            ZipEntry e = new ZipEntry(rootPath.relativize(p).toString());
            out.putNextEntry(e);
            Throwable throwable = null;
            Object var5_8 = null;
            try (InputStream s = Files.newInputStream(p, new OpenOption[0]);){
                IOUtils.copyToStream(s, out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            out.closeEntry();
        }
    }
}

