/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.impl.AuthenticationHandlerImpl;

public abstract class HTTPAuthorizationHandler<T extends AuthenticationProvider>
extends AuthenticationHandlerImpl<T> {
    protected final Type type;
    protected final String realm;

    public HTTPAuthorizationHandler(T authProvider, Type type, String realm) {
        super(authProvider);
        this.type = type;
        String string = this.realm = realm == null ? null : realm.replaceAll("\"", "\\\"");
        if (this.realm != null && (this.realm.indexOf(13) != -1 || this.realm.indexOf(10) != -1)) {
            throw new IllegalArgumentException("Not allowed [\\r|\\n] characters detected on realm name");
        }
    }

    protected final void parseAuthorization(RoutingContext ctx, Handler<AsyncResult<String>> handler) {
        this.parseAuthorization(ctx, false, handler);
    }

    protected final void parseAuthorization(RoutingContext ctx, boolean optional, Handler<AsyncResult<String>> handler) {
        HttpServerRequest request = ctx.request();
        String authorization = request.headers().get(HttpHeaders.AUTHORIZATION);
        if (authorization == null) {
            if (optional) {
                handler.handle(Future.succeededFuture());
            } else {
                handler.handle(Future.failedFuture(UNAUTHORIZED));
            }
            return;
        }
        try {
            int idx = authorization.indexOf(32);
            if (idx <= 0) {
                handler.handle(Future.failedFuture(BAD_REQUEST));
                return;
            }
            if (!this.type.is(authorization.substring(0, idx))) {
                handler.handle(Future.failedFuture(UNAUTHORIZED));
                return;
            }
            handler.handle(Future.succeededFuture(authorization.substring(idx + 1)));
        }
        catch (RuntimeException e) {
            handler.handle(Future.failedFuture(e));
        }
    }

    @Override
    public String authenticateHeader(RoutingContext context) {
        if (this.realm != null && this.realm.length() > 0) {
            return (Object)((Object)this.type) + " realm=\"" + this.realm + "\"";
        }
        return null;
    }

    public static enum Type {
        BASIC("Basic"),
        DIGEST("Digest"),
        BEARER("Bearer"),
        HOBA("HOBA"),
        MUTUAL("Mutual"),
        NEGOTIATE("Negotiate"),
        OAUTH("OAuth"),
        SCRAM_SHA_1("SCRAM-SHA-1"),
        SCRAM_SHA_256("SCRAM-SHA-256");

        private final String label;

        private Type(String label) {
            this.label = label;
        }

        public boolean is(String other) {
            return this.label.equalsIgnoreCase(other);
        }

        public String toString() {
            return this.label;
        }
    }
}

