/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.config;

import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.TrustOptions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.config.FileFormat;
import org.eclipse.hono.config.GenericOptions;
import org.eclipse.hono.util.PortConfigurationHelper;
import org.eclipse.hono.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfig {
    public static final String PREFIX_FILE = "file:";
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private TrustOptions trustOptions = null;
    private String trustStorePath = null;
    private String trustStorePassword = null;
    private String pathSeparator = "/";
    private String keyStorePath = null;
    private String keyStorePassword = null;
    private String certPath = null;
    private String keyPath = null;
    private KeyCertOptions keyCertOptions = null;
    private FileFormat trustStoreFormat = null;
    private FileFormat keyFormat = null;
    private List<String> secureProtocols;
    private List<String> supportedCipherSuites;

    protected AbstractConfig() {
        ArrayList<String> initialProtocols = new ArrayList<String>();
        initialProtocols.add("TLSv1.3");
        initialProtocols.add("TLSv1.2");
        this.secureProtocols = Collections.unmodifiableList(initialProtocols);
        ArrayList initialCiphers = new ArrayList();
        this.supportedCipherSuites = Collections.unmodifiableList(initialCiphers);
    }

    protected AbstractConfig(AbstractConfig other) {
        this();
        this.certPath = other.certPath;
        this.keyFormat = other.keyFormat;
        this.keyPath = other.keyPath;
        this.keyStorePassword = other.keyStorePassword;
        this.keyStorePath = other.keyStorePath;
        this.pathSeparator = other.pathSeparator;
        this.secureProtocols = Collections.unmodifiableList(new ArrayList<String>(other.secureProtocols));
        this.supportedCipherSuites = Collections.unmodifiableList(new ArrayList<String>(other.supportedCipherSuites));
        this.trustStoreFormat = other.trustStoreFormat;
        this.trustStorePassword = other.trustStorePassword;
        this.trustStorePath = other.trustStorePath;
    }

    protected AbstractConfig(GenericOptions other) {
        this();
        this.certPath = other.certPath().orElse(null);
        this.keyFormat = other.keyFormat().orElse(null);
        this.keyPath = other.keyPath().orElse(null);
        this.keyStorePassword = other.keyStorePassword().orElse(null);
        this.keyStorePath = other.keyStorePath().orElse(null);
        this.pathSeparator = other.pathSeparator();
        this.secureProtocols = Collections.unmodifiableList(new ArrayList<String>(other.secureProtocols()));
        this.supportedCipherSuites = Collections.unmodifiableList(new ArrayList(other.supportedCipherSuites().orElse(Collections.emptyList())));
        this.trustStoreFormat = other.trustStoreFormat().orElse(null);
        this.trustStorePassword = other.trustStorePassword().orElse(null);
        this.trustStorePath = other.trustStorePath().orElse(null);
    }

    protected final String getPassword(String purpose, String value) {
        String string;
        Objects.requireNonNull(purpose);
        Objects.requireNonNull(value);
        if (!value.startsWith(PREFIX_FILE)) {
            return value;
        }
        String fsPath = value.substring(PREFIX_FILE.length());
        File file = new File(fsPath);
        if (!file.exists()) {
            this.LOG.warn("cannot read {} password, file [{}] does not exist", (Object)purpose, (Object)fsPath);
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        try {
            this.LOG.debug("reading {} password from [{}]", (Object)purpose, (Object)fsPath);
            string = reader.readLine();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.LOG.warn("could not read {} password from file [{}]", purpose, fsPath, e);
                return null;
            }
        }
        reader.close();
        return string;
    }

    protected boolean isValidPort(int port) {
        return PortConfigurationHelper.isValidPort(port);
    }

    public final String getPathSeparator() {
        return this.pathSeparator;
    }

    public final void setPathSeparator(String pathSeparator) {
        this.pathSeparator = Objects.requireNonNull(pathSeparator);
    }

    public final String getTrustStorePath() {
        return this.trustStorePath;
    }

    public final void setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
    }

    public final String getTrustStorePassword() {
        this.trustStorePassword = Optional.ofNullable(this.trustStorePassword).map(v -> this.getPassword("trust store", (String)v)).orElse(null);
        return this.trustStorePassword;
    }

    public final void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public final TrustOptions getTrustOptions() {
        if (this.trustOptions == null) {
            this.trustOptions = this.createTrustOptions();
        }
        return this.trustOptions;
    }

    private TrustOptions createTrustOptions() {
        if (this.trustOptions != null) {
            return this.trustOptions;
        }
        if (Strings.isNullOrEmpty(this.trustStorePath)) {
            return null;
        }
        if (!Files.exists(Paths.get(this.trustStorePath, new String[0]), new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("Configured trust store file does not exist: %s", this.trustStorePath));
        }
        FileFormat format = FileFormat.orDetect(this.trustStoreFormat, this.trustStorePath);
        if (format == null) {
            this.LOG.debug("unsupported trust store format");
            return null;
        }
        switch (format) {
            case PEM: {
                this.LOG.debug("using certificates from file [{}] as trust anchor", (Object)this.trustStorePath);
                return new PemTrustOptions().addCertPath(this.trustStorePath);
            }
            case PKCS12: {
                this.LOG.debug("using certificates from PKCS12 key store [{}] as trust anchor", (Object)this.trustStorePath);
                return new PfxOptions().setPath(this.getTrustStorePath()).setPassword(this.getTrustStorePassword());
            }
            case JKS: {
                this.LOG.debug("using certificates from JKS key store [{}] as trust anchor", (Object)this.trustStorePath);
                return new JksOptions().setPath(this.getTrustStorePath()).setPassword(this.getTrustStorePassword());
            }
        }
        this.LOG.debug("unsupported trust store format: {}", (Object)format);
        return null;
    }

    public final String getKeyStorePath() {
        return this.keyStorePath;
    }

    public final void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public final String getKeyStorePassword() {
        this.keyStorePassword = Optional.ofNullable(this.keyStorePassword).map(v -> this.getPassword("key store", (String)v)).orElse(null);
        return this.keyStorePassword;
    }

    public final void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public final KeyCertOptions getKeyCertOptions() {
        if (this.keyCertOptions == null) {
            this.keyCertOptions = this.createKeyCertOptions();
        }
        return this.keyCertOptions;
    }

    private KeyCertOptions createKeyCertOptions() {
        if (!Strings.isNullOrEmpty(this.keyPath) && !Strings.isNullOrEmpty(this.certPath)) {
            if (!Files.exists(Paths.get(this.keyPath, new String[0]), new LinkOption[0])) {
                throw new IllegalArgumentException(String.format("Configured key file does not exist: %s", this.keyPath));
            }
            if (!Files.exists(Paths.get(this.certPath, new String[0]), new LinkOption[0])) {
                throw new IllegalArgumentException(String.format("Configured certificate file does not exist: %s", this.certPath));
            }
            FileFormat format = FileFormat.orDetect(this.keyFormat, this.keyPath);
            FileFormat certFormat = FileFormat.orDetect(this.keyFormat, this.certPath);
            if (format == null) {
                this.LOG.warn("Unable to detect key file format for: {}", (Object)this.keyPath);
                return null;
            }
            if (certFormat == null) {
                this.LOG.warn("Unable to detect cert file format for: {}", (Object)this.certPath);
                return null;
            }
            if (certFormat != format) {
                this.LOG.warn("Key file is {}, but cert file is {}, it must be {} as well", new Object[]{format, certFormat, format});
                return null;
            }
            switch (format) {
                case PEM: {
                    this.LOG.debug("using key [{}] and certificate [{}] for identity", (Object)this.keyPath, (Object)this.certPath);
                    return new PemKeyCertOptions().setKeyPath(this.keyPath).setCertPath(this.certPath);
                }
            }
            this.LOG.warn("unsupported key & cert format: {}", (Object)format);
            return null;
        }
        if (!Strings.isNullOrEmpty(this.keyStorePath)) {
            if (!Files.exists(Paths.get(this.keyStorePath, new String[0]), new LinkOption[0])) {
                throw new IllegalArgumentException(String.format("Configured keystore file does not exist: %s", this.keyStorePath));
            }
            FileFormat format = FileFormat.orDetect(this.keyFormat, this.keyStorePath);
            switch (format) {
                case PKCS12: {
                    this.LOG.debug("using key & certificate from PKCS12 key store [{}] for identity", (Object)this.keyStorePath);
                    return new PfxOptions().setPath(this.keyStorePath).setPassword(this.getKeyStorePassword());
                }
                case JKS: {
                    this.LOG.debug("using key & certificate from JKS key store [{}] for server identity", (Object)this.keyStorePath);
                    return new JksOptions().setPath(this.keyStorePath).setPassword(this.getKeyStorePassword());
                }
            }
            this.LOG.warn("unsupported key store format: {}", (Object)format);
            return null;
        }
        this.LOG.debug("neither key/cert nor keystore is configured");
        return null;
    }

    public final String getCertPath() {
        return this.certPath;
    }

    public final void setCertPath(String certPath) {
        this.certPath = certPath;
    }

    public final String getKeyPath() {
        return this.keyPath;
    }

    public final void setKeyPath(String keyPath) {
        this.keyPath = keyPath;
    }

    public final void setTrustStoreFormat(FileFormat trustStoreFormat) {
        this.trustStoreFormat = trustStoreFormat;
    }

    public final FileFormat getTrustStoreFormat() {
        return this.trustStoreFormat;
    }

    public final void setKeyFormat(FileFormat keyFormat) {
        this.keyFormat = keyFormat;
    }

    public final FileFormat getKeyFormat() {
        return this.keyFormat;
    }

    public final List<String> getSecureProtocols() {
        return this.secureProtocols;
    }

    public final void setSecureProtocols(List<String> enabledProtocols) {
        Objects.requireNonNull(enabledProtocols);
        this.secureProtocols = Collections.unmodifiableList(enabledProtocols);
    }

    public final List<String> getSupportedCipherSuites() {
        return this.supportedCipherSuites;
    }

    public final void setSupportedCipherSuites(List<String> cipherSuites) {
        Objects.requireNonNull(cipherSuites);
        this.supportedCipherSuites = Collections.unmodifiableList(cipherSuites);
    }
}

