/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi.builders;

import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.reactivestreams.Subscription;

public class StreamBasedMulti<T>
extends AbstractMulti<T> {
    private final Supplier<? extends Stream<? extends T>> supplier;

    public StreamBasedMulti(Supplier<? extends Stream<? extends T>> supplier) {
        this.supplier = supplier;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        Iterator iterator;
        Stream<T> stream;
        ParameterValidation.nonNullNpe(downstream, "subscriber");
        try {
            stream = this.supplier.get();
        }
        catch (Throwable e) {
            Subscriptions.fail(downstream, e);
            return;
        }
        if (stream == null) {
            Subscriptions.fail(downstream, new NullPointerException("The supplier returned `null`"));
            return;
        }
        try {
            iterator = stream.iterator();
            if (!iterator.hasNext()) {
                Subscriptions.complete(downstream);
                StreamBasedMulti.closeQuietly(stream);
                return;
            }
        }
        catch (Throwable ex) {
            Subscriptions.fail(downstream, ex);
            StreamBasedMulti.closeQuietly(stream);
            return;
        }
        downstream.onSubscribe(new StreamSubscription<T>(downstream, iterator, stream));
    }

    private static void closeQuietly(AutoCloseable source) {
        if (source == null) {
            return;
        }
        try {
            source.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class StreamSubscription<T>
    implements Subscription {
        private final Iterator<? extends T> iterator;
        private final AutoCloseable closeable;
        private final AtomicLong requested = new AtomicLong();
        private final MultiSubscriber<T> downstream;
        private volatile boolean cancelled;

        StreamSubscription(MultiSubscriber<T> downstream, Iterator<? extends T> iterator, AutoCloseable closeable) {
            this.iterator = iterator;
            this.closeable = closeable;
            this.downstream = downstream;
        }

        @Override
        public void request(long n) {
            if (n > 0L) {
                if (Subscriptions.add(this.requested, n) == 0L) {
                    this.pull(n);
                }
            } else {
                this.downstream.onFailure(Subscriptions.getInvalidRequestException());
            }
        }

        public void pull(long n) {
            long emitted = 0L;
            while (true) {
                T item;
                if (this.cancelled) {
                    StreamBasedMulti.closeQuietly(this.closeable);
                    return;
                }
                try {
                    item = this.iterator.next();
                    if (item == null) {
                        throw new NullPointerException("The stream iterator produced `null`");
                    }
                }
                catch (Throwable ex) {
                    this.downstream.onFailure(ex);
                    this.cancelled = true;
                    continue;
                }
                this.downstream.onItem(item);
                if (this.cancelled || this.handleCompletion() || ++emitted != n || emitted != (n = this.requested.get())) continue;
                if (this.requested.compareAndSet(n, 0L)) break;
                n = this.requested.get();
            }
        }

        private boolean handleCompletion() {
            try {
                if (!this.iterator.hasNext()) {
                    this.downstream.onCompletion();
                    this.cancelled = true;
                    return true;
                }
            }
            catch (Throwable ex) {
                this.downstream.onFailure(ex);
                this.cancelled = true;
                return true;
            }
            return false;
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.request(1L);
        }
    }
}

