/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.util;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.client.util.ClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CachingClientFactory<T>
extends ClientFactory<T> {
    static final int MAX_CREATION_RETRIES = 3;
    static final int CREATION_RETRY_INTERVAL_MILLIS = 20;
    private static final Logger log = LoggerFactory.getLogger(CachingClientFactory.class);
    private final Vertx vertx;
    private final Predicate<T> livenessCheck;
    private final Map<String, T> activeClients = new HashMap<String, T>();
    private final Map<String, Boolean> creationLocks = new HashMap<String, Boolean>();

    public CachingClientFactory(Vertx vertx, Predicate<T> livenessCheck) {
        this.vertx = vertx;
        this.livenessCheck = Objects.requireNonNull(livenessCheck);
    }

    public void removeClient(String key) {
        this.activeClients.remove(key);
    }

    public void removeClient(String key, Handler<T> postProcessor) {
        T client = this.activeClients.remove(key);
        if (client != null) {
            postProcessor.handle(client);
        }
    }

    @Override
    protected void doClearState() {
        this.activeClients.clear();
        this.creationLocks.clear();
    }

    public boolean isEmpty() {
        return this.activeClients.isEmpty() && this.creationLocks.isEmpty() && this.creationRequests.isEmpty();
    }

    public T getClient(String key) {
        return this.activeClients.get(key);
    }

    public void getOrCreateClient(String key, Supplier<Future<T>> clientInstanceSupplier, Handler<AsyncResult<T>> result) {
        this.getOrCreateClient(key, clientInstanceSupplier, result, 0);
    }

    private void getOrCreateClient(String key, Supplier<Future<T>> clientInstanceSupplier, Handler<AsyncResult<T>> result, int retry) {
        T sender = this.activeClients.get(key);
        if (sender != null && this.livenessCheck.test(sender)) {
            log.debug("reusing cached client [{}]", (Object)key);
            result.handle(Future.succeededFuture(sender));
        } else if (!this.creationLocks.computeIfAbsent(key, k -> Boolean.FALSE).booleanValue()) {
            Handler<Void> connectionFailureHandler = connectionLost -> {
                if (this.creationLocks.remove(key, Boolean.TRUE)) {
                    result.handle(Future.failedFuture(new ServerErrorException(503, "no connection to service")));
                } else {
                    log.debug("creation attempt already finished for [{}]", (Object)key);
                }
            };
            this.creationRequests.add(connectionFailureHandler);
            this.creationLocks.put(key, Boolean.TRUE);
            log.debug("creating new client for [{}]", (Object)key);
            try {
                clientInstanceSupplier.get().onComplete(creationAttempt -> {
                    this.creationRequests.remove(connectionFailureHandler);
                    if (this.creationLocks.remove(key, Boolean.TRUE)) {
                        if (creationAttempt.succeeded()) {
                            Object newClient = creationAttempt.result();
                            log.debug("successfully created new client for [{}]", (Object)key);
                            this.activeClients.put(key, newClient);
                            result.handle(Future.succeededFuture(newClient));
                        } else {
                            log.debug("failed to create new client for [{}]", (Object)key, (Object)creationAttempt.cause());
                            this.activeClients.remove(key);
                            result.handle(Future.failedFuture(creationAttempt.cause()));
                        }
                    } else {
                        log.debug("creation attempt already finished for [{}]", (Object)key);
                    }
                });
            }
            catch (Exception ex) {
                this.creationLocks.remove(key);
                this.creationRequests.remove(connectionFailureHandler);
                log.error("exception creating new client for [{}]", (Object)key, (Object)ex);
                this.activeClients.remove(key);
                result.handle(Future.failedFuture(new ServerErrorException(500, String.format("exception creating new client for [%s]: %s", key, ex.getMessage()))));
            }
        } else if (retry < 3) {
            log.debug("already trying to create a client for [{}], retrying in {}ms", (Object)key, (Object)20);
            this.vertx.setTimer(20L, id -> this.getOrCreateClient(key, clientInstanceSupplier, result, retry + 1));
        } else {
            log.debug("already trying to create a client for [{}] (max retries reached)", (Object)key);
            result.handle(Future.failedFuture(new ServerErrorException(503, "already creating client for key")));
        }
    }
}

