/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.util;

import io.jsonwebtoken.SignatureAlgorithm;
import io.vertx.core.Vertx;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Supplier;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.hono.config.KeyLoader;
import org.eclipse.hono.config.SignatureSupportingConfigProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JwtHelper {
    private static final Logger LOG = LoggerFactory.getLogger(JwtHelper.class);
    protected Key key;
    protected Duration tokenLifetime;
    private final Vertx vertx;

    protected JwtHelper(Vertx vertx) {
        this.vertx = vertx;
    }

    protected static final byte[] getBytes(String secret) {
        return secret.getBytes(StandardCharsets.UTF_8);
    }

    protected final void setSharedSecret(byte[] secret) {
        if (Objects.requireNonNull(secret).length < 32) {
            throw new IllegalArgumentException("shared secret must be at least 32 bytes");
        }
        this.key = new SecretKeySpec(secret, SignatureAlgorithm.HS256.getJcaName());
    }

    protected final void setPrivateKey(String keyPath) {
        Objects.requireNonNull(keyPath);
        this.key = KeyLoader.fromFiles(this.vertx, keyPath, null).getPrivateKey();
        if (this.key == null) {
            throw new IllegalArgumentException("cannot load private key: " + keyPath);
        }
        if (!(this.key instanceof ECKey) && !(this.key instanceof RSAKey)) {
            throw new IllegalArgumentException("unsupported private key type: " + this.key.getClass());
        }
    }

    protected final void setPublicKey(String keyPath) {
        Objects.requireNonNull(keyPath);
        this.key = KeyLoader.fromFiles(this.vertx, null, keyPath).getPublicKey();
        if (this.key == null) {
            throw new IllegalArgumentException("cannot load public key: " + keyPath);
        }
        if (!(this.key instanceof ECKey) && !(this.key instanceof RSAKey)) {
            throw new IllegalArgumentException("unsupported public key type: " + this.key.getClass());
        }
    }

    public final Duration getTokenLifetime() {
        return this.tokenLifetime;
    }

    protected static <T extends JwtHelper> T forSharedSecret(String sharedSecret, long tokenExpiration, Supplier<T> instanceSupplier) {
        Objects.requireNonNull(sharedSecret);
        Objects.requireNonNull(instanceSupplier);
        JwtHelper result = (JwtHelper)instanceSupplier.get();
        result.setSharedSecret(JwtHelper.getBytes(sharedSecret));
        result.tokenLifetime = Duration.ofSeconds(tokenExpiration);
        return (T)result;
    }

    protected static <T extends JwtHelper> T forSigning(SignatureSupportingConfigProperties config, Supplier<T> instanceSupplier) {
        Objects.requireNonNull(config);
        Objects.requireNonNull(instanceSupplier);
        if (!config.isAppropriateForCreating()) {
            throw new IllegalArgumentException("configuration does not specify any signing tokens");
        }
        JwtHelper result = (JwtHelper)instanceSupplier.get();
        result.tokenLifetime = Duration.ofSeconds(config.getTokenExpiration());
        LOG.info("using token lifetime of {} seconds", (Object)result.tokenLifetime.getSeconds());
        if (config.getSharedSecret() != null) {
            byte[] secret = JwtHelper.getBytes(config.getSharedSecret());
            result.setSharedSecret(secret);
            LOG.info("using shared secret [{} bytes] for signing tokens", (Object)secret.length);
        } else if (config.getKeyPath() != null) {
            result.setPrivateKey(config.getKeyPath());
            LOG.info("using private key [{}] for signing tokens", (Object)config.getKeyPath());
        }
        return (T)result;
    }

    protected static <T extends JwtHelper> T forValidating(SignatureSupportingConfigProperties config, Supplier<T> instanceSupplier) {
        Objects.requireNonNull(config);
        Objects.requireNonNull(instanceSupplier);
        if (!config.isAppropriateForValidating()) {
            throw new IllegalArgumentException("configuration does not specify any key material for validating tokens");
        }
        JwtHelper result = (JwtHelper)instanceSupplier.get();
        if (config.getSharedSecret() != null) {
            byte[] secret = JwtHelper.getBytes(config.getSharedSecret());
            result.setSharedSecret(secret);
            LOG.info("using shared secret [{} bytes] for validating tokens", (Object)secret.length);
        } else if (config.getCertPath() != null) {
            result.setPublicKey(config.getCertPath());
            LOG.info("using public key from certificate [{}] for validating tokens", (Object)config.getCertPath());
        }
        return (T)result;
    }
}

