/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.common.utils;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private static final String[] NO_STRINGS = new String[0];
    private static final Pattern ITEM_PATTERN = Pattern.compile("(,+)|([^\\\\,]+)|\\\\(.)");

    private StringUtil() {
    }

    public static String[] split(String text) {
        if (text == null || text.isEmpty()) {
            return NO_STRINGS;
        }
        Matcher matcher = ITEM_PATTERN.matcher(text);
        String item = null;
        StringBuilder b = null;
        ArrayList<String> list = new ArrayList<String>(4);
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                if (item == null) continue;
                list.add(item);
                item = null;
                continue;
            }
            if (matcher.group(2) != null) {
                assert (item == null) : "Regular expression matching malfunctioned";
                item = matcher.group(2);
                continue;
            }
            if (matcher.group(3) != null) {
                if (b == null) {
                    b = new StringBuilder();
                }
                if (item != null) {
                    b.append(item);
                    item = null;
                }
                b.append(matcher.group(3));
                while (matcher.find() && matcher.group(1) == null) {
                    if (matcher.group(2) != null) {
                        b.append(matcher.group(2));
                        continue;
                    }
                    if (matcher.group(3) != null) {
                        b.append(matcher.group(3));
                        continue;
                    }
                    throw new IllegalStateException();
                }
                list.add(b.toString());
                b.setLength(0);
                continue;
            }
            throw new IllegalStateException();
        }
        if (item != null) {
            list.add(item);
        }
        return list.toArray(NO_STRINGS);
    }

    public static String replaceNonAlphanumericByUnderscores(String name) {
        int length = name.length();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9') {
                sb.append(c);
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }

    public static String toLowerCaseAndDotted(String name) {
        int length = name.length();
        int beginSegment = 0;
        boolean quotesOpen = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if ('_' == c) {
                int j;
                String segment = sb.substring(beginSegment, i);
                try {
                    Integer.parseInt(segment);
                    sb.replace(beginSegment - 1, beginSegment, "[").append("]");
                    j = i + 1;
                    if (j >= length || '_' != name.charAt(j)) continue;
                    sb.append(".");
                    i = j;
                }
                catch (NumberFormatException j2) {
                    j = i + 1;
                    if (j < length) {
                        if ('_' == name.charAt(j) && !quotesOpen) {
                            sb.append(".");
                            sb.append("\"");
                            i = j;
                            quotesOpen = true;
                        } else if ('_' == name.charAt(j) && quotesOpen) {
                            sb.append("\"");
                            sb.append(".");
                            i = j;
                            quotesOpen = false;
                        } else {
                            sb.append(".");
                        }
                    } else {
                        sb.append(".");
                    }
                    beginSegment = j;
                }
                continue;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String skewer(String camelHumps) {
        return StringUtil.skewer(camelHumps, '-');
    }

    public static String skewer(String camelHumps, char separator) {
        return StringUtil.skewer(camelHumps, 0, camelHumps.length(), new StringBuilder(), separator);
    }

    public static String hyphenate(String camelHumps) {
        return StringUtil.skewer(camelHumps).replaceAll("_", "-");
    }

    private static String skewer(String camelHumps, int start, int end, StringBuilder b, char separator) {
        if (camelHumps.isEmpty()) {
            throw new IllegalArgumentException("Method seems to have an empty name");
        }
        int cp = camelHumps.codePointAt(start);
        b.appendCodePoint(Character.toLowerCase(cp));
        if ((start += Character.charCount(cp)) == end) {
            return b.toString();
        }
        if (Character.isUpperCase(cp)) {
            int nextCp = camelHumps.codePointAt(start);
            if (Character.isUpperCase(nextCp)) {
                do {
                    b.appendCodePoint(Character.toLowerCase(nextCp));
                    cp = nextCp;
                    if ((start += Character.charCount(cp)) != end) continue;
                    return b.toString();
                } while (!Character.isLowerCase(nextCp = camelHumps.codePointAt(start)));
                b.append(separator);
                return StringUtil.skewer(camelHumps, start, end, b, separator);
            }
            b.appendCodePoint(nextCp);
            start += Character.charCount(nextCp);
            while (true) {
                if (start == end) {
                    return b.toString();
                }
                cp = camelHumps.codePointAt(start);
                if (Character.isUpperCase(cp)) {
                    b.append(separator);
                    return StringUtil.skewer(camelHumps, start, end, b, separator);
                }
                b.appendCodePoint(cp);
                start += Character.charCount(cp);
            }
        }
        do {
            if (Character.isUpperCase(cp = camelHumps.codePointAt(start))) {
                b.append(separator);
                return StringUtil.skewer(camelHumps, start, end, b, separator);
            }
            b.appendCodePoint(cp);
        } while ((start += Character.charCount(cp)) != end);
        return b.toString();
    }
}

