/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.net;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingConsumerHandler;
import io.smallrye.mutiny.vertx.DelegatingHandler;
import io.smallrye.mutiny.vertx.MultiHelper;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.MutinyHelper;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.smallrye.mutiny.vertx.WriteStreamSubscriber;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.core.net.SocketAddress;
import io.vertx.mutiny.core.streams.Pipe;
import io.vertx.mutiny.core.streams.ReadStream;
import io.vertx.mutiny.core.streams.WriteStream;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.net.ssl.SSLSession;

@MutinyGen(value=io.vertx.core.net.NetSocket.class)
public class NetSocket
implements ReadStream<Buffer>,
WriteStream<Buffer> {
    public static final TypeArg<NetSocket> __TYPE_ARG = new TypeArg<NetSocket>(obj -> new NetSocket((io.vertx.core.net.NetSocket)obj), NetSocket::getDelegate);
    private final io.vertx.core.net.NetSocket delegate;
    static final TypeArg<Buffer> TYPE_ARG_0 = new TypeArg<Buffer>(o1 -> Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
    private WriteStreamSubscriber<Buffer> subscriber;
    private SocketAddress cached_0;
    private SocketAddress cached_1;
    private Multi<Buffer> multi;

    public NetSocket(io.vertx.core.net.NetSocket delegate) {
        this.delegate = delegate;
    }

    public NetSocket(Object delegate) {
        this.delegate = (io.vertx.core.net.NetSocket)delegate;
    }

    NetSocket() {
        this.delegate = null;
    }

    @Override
    public io.vertx.core.net.NetSocket getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetSocket that = (NetSocket)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @CheckReturnValue
    public synchronized WriteStreamSubscriber<Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<Buffer, io.vertx.core.buffer.Buffer> conv = Buffer::getDelegate;
            this.subscriber = MutinyHelper.toSubscriber(this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public Pipe<Buffer> pipe() {
        Pipe<Buffer> ret = Pipe.newInstance(this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    @Override
    @CheckReturnValue
    public Uni<Void> pipeTo(WriteStream<Buffer> dst) {
        return AsyncResultUni.toUni(handler -> this.delegate.pipeTo(dst.getDelegate(), (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void pipeToAndAwait(WriteStream<Buffer> dst) {
        return this.pipeTo(dst).await().indefinitely();
    }

    @Override
    public void pipeToAndForget(WriteStream<Buffer> dst) {
        this.pipeTo(dst).subscribe().with(UniHelper.NOOP);
    }

    @Override
    @CheckReturnValue
    public Uni<Void> end(Buffer data) {
        return AsyncResultUni.toUni(handler -> this.delegate.end(data.getDelegate(), (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void endAndAwait(Buffer data) {
        return this.end(data).await().indefinitely();
    }

    @Override
    public void endAndForget(Buffer data) {
        this.end(data).subscribe().with(UniHelper.NOOP);
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Fluent
    private NetSocket __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler((Handler)handler);
        return this;
    }

    @Override
    public NetSocket exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler((Handler<Throwable>)(handler != null ? new DelegatingConsumerHandler<Throwable>(handler) : null));
    }

    @Fluent
    private NetSocket __handler(Handler<Buffer> handler) {
        this.delegate.handler(new DelegatingHandler<io.vertx.core.buffer.Buffer, Buffer>(handler, event -> Buffer.newInstance(event)));
        return this;
    }

    public NetSocket handler(Consumer<Buffer> handler) {
        return this.__handler((Handler<Buffer>)(handler != null ? new DelegatingConsumerHandler<Buffer>(handler) : null));
    }

    @Fluent
    public NetSocket pause() {
        this.delegate.pause();
        return this;
    }

    @Fluent
    public NetSocket resume() {
        this.delegate.resume();
        return this;
    }

    @Fluent
    public NetSocket fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @Fluent
    private NetSocket __endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler((Handler)endHandler);
        return this;
    }

    public NetSocket endHandler(Runnable endHandler) {
        return this.__endHandler(ignored -> endHandler.run());
    }

    @Fluent
    public NetSocket setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    @Fluent
    private NetSocket __drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler((Handler)handler);
        return this;
    }

    public NetSocket drainHandler(Runnable handler) {
        return this.__drainHandler(ignored -> handler.run());
    }

    public String writeHandlerID() {
        String ret = this.delegate.writeHandlerID();
        return ret;
    }

    @Override
    @CheckReturnValue
    public Uni<Void> write(String str) {
        return AsyncResultUni.toUni(handler -> this.delegate.write(str, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void writeAndAwait(String str) {
        return this.write(str).await().indefinitely();
    }

    @Override
    public void writeAndForget(String str) {
        this.write(str).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> write(String str, String enc) {
        return AsyncResultUni.toUni(handler -> this.delegate.write(str, enc, (Handler<AsyncResult<Void>>)handler));
    }

    public Void writeAndAwait(String str, String enc) {
        return this.write(str, enc).await().indefinitely();
    }

    public void writeAndForget(String str, String enc) {
        this.write(str, enc).subscribe().with(UniHelper.NOOP);
    }

    @Override
    @CheckReturnValue
    public Uni<Void> write(Buffer message) {
        return AsyncResultUni.toUni(handler -> this.delegate.write(message.getDelegate(), (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void writeAndAwait(Buffer message) {
        return this.write(message).await().indefinitely();
    }

    @Override
    public void writeAndForget(Buffer message) {
        this.write(message).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> sendFile(String filename) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.sendFile(filename, (Handler<AsyncResult<Void>>)resultHandler));
    }

    public Void sendFileAndAwait(String filename) {
        return this.sendFile(filename).await().indefinitely();
    }

    @Fluent
    public NetSocket sendFileAndForget(String filename) {
        this.sendFile(filename).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> sendFile(String filename, long offset) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.sendFile(filename, offset, (Handler<AsyncResult<Void>>)resultHandler));
    }

    public Void sendFileAndAwait(String filename, long offset) {
        return this.sendFile(filename, offset).await().indefinitely();
    }

    @Fluent
    public NetSocket sendFileAndForget(String filename, long offset) {
        this.sendFile(filename, offset).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> sendFile(String filename, long offset, long length) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.sendFile(filename, offset, length, (Handler<AsyncResult<Void>>)resultHandler));
    }

    public Void sendFileAndAwait(String filename, long offset, long length) {
        return this.sendFile(filename, offset, length).await().indefinitely();
    }

    @Fluent
    public NetSocket sendFileAndForget(String filename, long offset, long length) {
        this.sendFile(filename, offset, length).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.remoteAddress());
        return ret;
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    @Override
    @CheckReturnValue
    public Uni<Void> end() {
        return AsyncResultUni.toUni(handler -> this.delegate.end((Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void endAndAwait() {
        return this.end().await().indefinitely();
    }

    @Override
    public void endAndForget() {
        this.end().subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.delegate.close((Handler<AsyncResult<Void>>)handler));
    }

    public Void closeAndAwait() {
        return this.close().await().indefinitely();
    }

    public void closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
    }

    @Fluent
    private NetSocket __closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public NetSocket closeHandler(Runnable handler) {
        return this.__closeHandler(ignored -> handler.run());
    }

    @CheckReturnValue
    public Uni<Void> upgradeToSsl() {
        return AsyncResultUni.toUni(handler -> this.delegate.upgradeToSsl((Handler<AsyncResult<Void>>)handler));
    }

    public Void upgradeToSslAndAwait() {
        return this.upgradeToSsl().await().indefinitely();
    }

    @Fluent
    public NetSocket upgradeToSslAndForget() {
        this.upgradeToSsl().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> upgradeToSsl(String serverName) {
        return AsyncResultUni.toUni(handler -> this.delegate.upgradeToSsl(serverName, (Handler<AsyncResult<Void>>)handler));
    }

    public Void upgradeToSslAndAwait(String serverName) {
        return this.upgradeToSsl(serverName).await().indefinitely();
    }

    @Fluent
    public NetSocket upgradeToSslAndForget(String serverName) {
        this.upgradeToSsl(serverName).subscribe().with(UniHelper.NOOP);
        return this;
    }

    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    public String indicatedServerName() {
        String ret = this.delegate.indicatedServerName();
        return ret;
    }

    public String applicationLayerProtocol() {
        String ret = this.delegate.applicationLayerProtocol();
        return ret;
    }

    public SSLSession sslSession() {
        SSLSession ret = this.delegate.sslSession();
        return ret;
    }

    @Override
    @CheckReturnValue
    public synchronized Multi<Buffer> toMulti() {
        if (this.multi == null) {
            Function<io.vertx.core.buffer.Buffer, Buffer> conv = Buffer::newInstance;
            this.multi = MultiHelper.toMulti(this.delegate, conv);
        }
        return this.multi;
    }

    public Iterable<Buffer> toBlockingIterable() {
        return this.toMulti().subscribe().asIterable();
    }

    public Stream<Buffer> toBlockingStream() {
        return this.toMulti().subscribe().asStream();
    }

    public static NetSocket newInstance(io.vertx.core.net.NetSocket arg) {
        return arg != null ? new NetSocket(arg) : null;
    }
}

