/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import java.io.Serializable;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.Priority;
import org.eclipse.microprofile.config.spi.Converter;

@Priority(value=200)
public class LocaleConverter
implements Converter<Locale>,
Serializable {
    private static final Pattern NORMALIZE_LOCALE_PATTERN = Pattern.compile("_");

    @Override
    public Locale convert(String value) {
        String localeValue = value.trim();
        if (localeValue.isEmpty()) {
            return null;
        }
        Locale locale = Locale.forLanguageTag(NORMALIZE_LOCALE_PATTERN.matcher(localeValue).replaceAll("-"));
        if (locale != Locale.ROOT && (locale.getLanguage() == null || locale.getLanguage().isEmpty())) {
            throw new IllegalArgumentException("Unable to resolve locale: " + value);
        }
        return locale;
    }
}

