/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.application.client.amqp;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.proton.ProtonHelper;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.application.client.CommandSender;
import org.eclipse.hono.application.client.DownstreamMessage;
import org.eclipse.hono.application.client.amqp.AmqpMessageContext;
import org.eclipse.hono.application.client.amqp.ProtonBasedRequestResponseCommandClient;
import org.eclipse.hono.client.amqp.SenderCachingServiceClient;
import org.eclipse.hono.client.amqp.connection.HonoConnection;
import org.eclipse.hono.client.amqp.connection.SendMessageSampler;
import org.eclipse.hono.client.util.StatusCodeMapper;
import org.eclipse.hono.util.ResourceIdentifier;

public class ProtonBasedCommandSender
extends SenderCachingServiceClient
implements CommandSender<AmqpMessageContext> {
    private final ProtonBasedRequestResponseCommandClient requestResponseClient;

    public ProtonBasedCommandSender(HonoConnection connection, SendMessageSampler.Factory samplerFactory) {
        super(connection, samplerFactory);
        this.requestResponseClient = new ProtonBasedRequestResponseCommandClient(connection, samplerFactory);
    }

    @Override
    public Future<DownstreamMessage<AmqpMessageContext>> sendCommand(String tenantId, String deviceId, String command, Buffer data, String contentType, String replyId, Duration timeout, SpanContext context) {
        return this.requestResponseClient.sendCommand(tenantId, deviceId, command, contentType, data, replyId, timeout, context);
    }

    @Override
    public Future<Void> sendAsyncCommand(String tenantId, String deviceId, String command, String correlationId, String replyId, Buffer data, String contentType, SpanContext context) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(command);
        Objects.requireNonNull(correlationId);
        Objects.requireNonNull(replyId);
        return this.sendCommand(tenantId, deviceId, command, contentType, data, correlationId, replyId, this.newChildSpan(context, "send command"));
    }

    @Override
    public Future<Void> sendOneWayCommand(String tenantId, String deviceId, String command, Buffer data, String contentType, SpanContext context) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(command);
        return this.sendCommand(tenantId, deviceId, command, contentType, data, null, null, this.newChildSpan(context, "send one-way command"));
    }

    private Future<Void> sendCommand(String tenantId, String deviceId, String command, String contentType, Buffer data, String correlationId, String replyId, Span span) {
        return this.getOrCreateSenderLink("command", tenantId).recover(thr -> Future.failedFuture(StatusCodeMapper.toServerError(thr))).compose(sender -> {
            Message msg = ProtonBasedCommandSender.createMessage(tenantId, deviceId, command, contentType, data, correlationId, replyId);
            return sender.sendAndWaitForOutcome(msg, span);
        }).mapEmpty();
    }

    private static Message createMessage(String tenantId, String deviceId, String command, String contentType, Buffer data, String correlationId, String replyId) {
        ResourceIdentifier target = ResourceIdentifier.from("command", tenantId, deviceId);
        Message msg = ProtonHelper.message();
        msg.setCreationTime(Instant.now().toEpochMilli());
        msg.setAddress(target.toString());
        msg.setSubject(command);
        Optional.ofNullable(correlationId).ifPresent(msg::setCorrelationId);
        Optional.ofNullable(replyId).ifPresent(id -> msg.setReplyTo(ResourceIdentifier.fromPath("command_response", tenantId, id).toString()));
        Optional.ofNullable(data).map(Buffer::getBytes).map(Binary::new).map(Data::new).ifPresent(msg::setBody);
        Optional.ofNullable(contentType).ifPresent(msg::setContentType);
        return msg;
    }
}

