/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.kafka.client.consumer;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.streams.ReadStream;
import io.vertx.kafka.client.common.KafkaClientOptions;
import io.vertx.kafka.client.consumer.impl.KafkaReadStreamImpl;
import io.vertx.kafka.client.serialization.VertxSerdes;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.Deserializer;

public interface KafkaReadStream<K, V>
extends ReadStream<ConsumerRecord<K, V>> {
    @Override
    public KafkaReadStream<K, V> exceptionHandler(Handler<Throwable> var1);

    public KafkaReadStream<K, V> handler(@Nullable Handler<ConsumerRecord<K, V>> var1);

    public KafkaReadStream<K, V> pause();

    public KafkaReadStream<K, V> resume();

    public KafkaReadStream<K, V> fetch(long var1);

    public KafkaReadStream<K, V> endHandler(@Nullable Handler<Void> var1);

    public long demand();

    public static <K, V> KafkaReadStream<K, V> create(Vertx vertx, Properties config) {
        return new KafkaReadStreamImpl(vertx, new KafkaConsumer(config), KafkaClientOptions.fromProperties(config, false));
    }

    public static <K, V> KafkaReadStream<K, V> create(Vertx vertx, Properties config, Class<K> keyType, Class<V> valueType) {
        Deserializer<K> keyDeserializer = VertxSerdes.serdeFrom(keyType).deserializer();
        Deserializer<V> valueDeserializer = VertxSerdes.serdeFrom(valueType).deserializer();
        return KafkaReadStream.create(vertx, config, keyDeserializer, valueDeserializer);
    }

    public static <K, V> KafkaReadStream<K, V> create(Vertx vertx, Properties config, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        return new KafkaReadStreamImpl<K, V>(vertx, new KafkaConsumer<K, V>(config, keyDeserializer, valueDeserializer), KafkaClientOptions.fromProperties(config, false));
    }

    public static <K, V> KafkaReadStream<K, V> create(Vertx vertx, Map<String, Object> config) {
        return new KafkaReadStreamImpl(vertx, new KafkaConsumer(config), KafkaClientOptions.fromMap(config, false));
    }

    public static <K, V> KafkaReadStream<K, V> create(Vertx vertx, Map<String, Object> config, Class<K> keyType, Class<V> valueType) {
        Deserializer<K> keyDeserializer = VertxSerdes.serdeFrom(keyType).deserializer();
        Deserializer<V> valueDeserializer = VertxSerdes.serdeFrom(valueType).deserializer();
        return KafkaReadStream.create(vertx, config, keyDeserializer, valueDeserializer);
    }

    public static <K, V> KafkaReadStream<K, V> create(Vertx vertx, Map<String, Object> config, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        return new KafkaReadStreamImpl<K, V>(vertx, new KafkaConsumer<K, V>(config, keyDeserializer, valueDeserializer), KafkaClientOptions.fromMap(config, false));
    }

    public static <K, V> KafkaReadStream<K, V> create(Vertx vertx, KafkaClientOptions options) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        if (options.getConfig() != null) {
            config.putAll(options.getConfig());
        }
        return new KafkaReadStreamImpl(vertx, new KafkaConsumer(config), options);
    }

    public static <K, V> KafkaReadStream<K, V> create(Vertx vertx, KafkaClientOptions options, Class<K> keyType, Class<V> valueType) {
        Deserializer<K> keyDeserializer = VertxSerdes.serdeFrom(keyType).deserializer();
        Deserializer<V> valueDeserializer = VertxSerdes.serdeFrom(valueType).deserializer();
        return KafkaReadStream.create(vertx, options, keyDeserializer, valueDeserializer);
    }

    public static <K, V> KafkaReadStream<K, V> create(Vertx vertx, KafkaClientOptions options, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        if (options.getConfig() != null) {
            config.putAll(options.getConfig());
        }
        return new KafkaReadStreamImpl<K, V>(vertx, new KafkaConsumer<K, V>(config, keyDeserializer, valueDeserializer), options);
    }

    public static <K, V> KafkaReadStream<K, V> create(Vertx vertx, Consumer<K, V> consumer) {
        return KafkaReadStream.create(vertx, consumer, new KafkaClientOptions());
    }

    public static <K, V> KafkaReadStream<K, V> create(Vertx vertx, Consumer<K, V> consumer, KafkaClientOptions options) {
        return new KafkaReadStreamImpl<K, V>(vertx, consumer, options);
    }

    public void committed(TopicPartition var1, Handler<AsyncResult<OffsetAndMetadata>> var2);

    public Future<OffsetAndMetadata> committed(TopicPartition var1);

    public Future<Void> pause(Set<TopicPartition> var1);

    public KafkaReadStream<K, V> pause(Set<TopicPartition> var1, Handler<AsyncResult<Void>> var2);

    public void paused(Handler<AsyncResult<Set<TopicPartition>>> var1);

    public Future<Set<TopicPartition>> paused();

    public Future<Void> resume(Set<TopicPartition> var1);

    public KafkaReadStream<K, V> resume(Set<TopicPartition> var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> seekToEnd(Set<TopicPartition> var1);

    public KafkaReadStream<K, V> seekToEnd(Set<TopicPartition> var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> seekToBeginning(Set<TopicPartition> var1);

    public KafkaReadStream<K, V> seekToBeginning(Set<TopicPartition> var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> seek(TopicPartition var1, long var2);

    public KafkaReadStream<K, V> seek(TopicPartition var1, long var2, Handler<AsyncResult<Void>> var4);

    public KafkaReadStream<K, V> partitionsRevokedHandler(Handler<Set<TopicPartition>> var1);

    public KafkaReadStream<K, V> partitionsAssignedHandler(Handler<Set<TopicPartition>> var1);

    public Future<Void> subscribe(Set<String> var1);

    public KafkaReadStream<K, V> subscribe(Set<String> var1, Handler<AsyncResult<Void>> var2);

    public KafkaReadStream<K, V> subscribe(Pattern var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> subscribe(Pattern var1);

    public Future<Void> unsubscribe();

    public KafkaReadStream<K, V> unsubscribe(Handler<AsyncResult<Void>> var1);

    public KafkaReadStream<K, V> subscription(Handler<AsyncResult<Set<String>>> var1);

    public Future<Set<String>> subscription();

    public Future<Void> assign(Set<TopicPartition> var1);

    public KafkaReadStream<K, V> assign(Set<TopicPartition> var1, Handler<AsyncResult<Void>> var2);

    public KafkaReadStream<K, V> assignment(Handler<AsyncResult<Set<TopicPartition>>> var1);

    public Future<Set<TopicPartition>> assignment();

    public KafkaReadStream<K, V> listTopics(Handler<AsyncResult<Map<String, List<PartitionInfo>>>> var1);

    public Future<Map<String, List<PartitionInfo>>> listTopics();

    public Future<Map<TopicPartition, OffsetAndMetadata>> commit();

    public void commit(Handler<AsyncResult<Map<TopicPartition, OffsetAndMetadata>>> var1);

    public Future<Map<TopicPartition, OffsetAndMetadata>> commit(Map<TopicPartition, OffsetAndMetadata> var1);

    public void commit(Map<TopicPartition, OffsetAndMetadata> var1, Handler<AsyncResult<Map<TopicPartition, OffsetAndMetadata>>> var2);

    public KafkaReadStream<K, V> partitionsFor(String var1, Handler<AsyncResult<List<PartitionInfo>>> var2);

    public Future<List<PartitionInfo>> partitionsFor(String var1);

    public Future<Void> close();

    public void close(Handler<AsyncResult<Void>> var1);

    public void position(TopicPartition var1, Handler<AsyncResult<Long>> var2);

    public Future<Long> position(TopicPartition var1);

    public void offsetsForTimes(Map<TopicPartition, Long> var1, Handler<AsyncResult<Map<TopicPartition, OffsetAndTimestamp>>> var2);

    public Future<Map<TopicPartition, OffsetAndTimestamp>> offsetsForTimes(Map<TopicPartition, Long> var1);

    public void offsetsForTimes(TopicPartition var1, long var2, Handler<AsyncResult<OffsetAndTimestamp>> var4);

    public Future<OffsetAndTimestamp> offsetsForTimes(TopicPartition var1, long var2);

    public void beginningOffsets(Set<TopicPartition> var1, Handler<AsyncResult<Map<TopicPartition, Long>>> var2);

    public Future<Map<TopicPartition, Long>> beginningOffsets(Set<TopicPartition> var1);

    public void beginningOffsets(TopicPartition var1, Handler<AsyncResult<Long>> var2);

    public Future<Long> beginningOffsets(TopicPartition var1);

    public void endOffsets(Set<TopicPartition> var1, Handler<AsyncResult<Map<TopicPartition, Long>>> var2);

    public Future<Map<TopicPartition, Long>> endOffsets(Set<TopicPartition> var1);

    public void endOffsets(TopicPartition var1, Handler<AsyncResult<Long>> var2);

    public Future<Long> endOffsets(TopicPartition var1);

    public Consumer<K, V> unwrap();

    public KafkaReadStream<K, V> batchHandler(Handler<ConsumerRecords<K, V>> var1);

    public KafkaReadStream<K, V> pollTimeout(Duration var1);

    public void poll(Duration var1, Handler<AsyncResult<ConsumerRecords<K, V>>> var2);

    public Future<ConsumerRecords<K, V>> poll(Duration var1);
}

