package org.eclipse.incquery.viewers.runtime.model.patterns;

import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedPatternGroup;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.viewers.runtime.model.patterns.Param2containmentMatcher;
import org.eclipse.incquery.viewers.runtime.model.patterns.Param2edgeMatcher;
import org.eclipse.incquery.viewers.runtime.model.patterns.Param2itemMatcher;
import org.eclipse.incquery.viewers.runtime.model.patterns.util.Param2containmentQuerySpecification;
import org.eclipse.incquery.viewers.runtime.model.patterns.util.Param2edgeQuerySpecification;
import org.eclipse.incquery.viewers.runtime.model.patterns.util.Param2itemQuerySpecification;

/**
 * A pattern group formed of all patterns defined in traceability.eiq.
 * 
 * <p>Use the static instance as any {@link org.eclipse.incquery.runtime.api.IPatternGroup}, to conveniently prepare
 * an EMF-IncQuery engine for matching all patterns originally defined in file traceability.eiq,
 * in order to achieve better performance than one-by-one on-demand matcher initialization.
 * 
 * <p> From package org.eclipse.incquery.viewers.runtime.model.patterns, the group contains the definition of the following patterns: <ul>
 * <li>param2item</li>
 * <li>param2edge</li>
 * <li>param2containment</li>
 * </ul>
 * 
 * @see IPatternGroup
 * 
 */
@SuppressWarnings("all")
public final class Traceability extends BaseGeneratedPatternGroup {
  /**
   * Access the pattern group.
   * 
   * @return the singleton instance of the group
   * @throws IncQueryException if there was an error loading the generated code of pattern specifications
   * 
   */
  public static Traceability instance() throws IncQueryException {
    if (INSTANCE == null) {
    	INSTANCE = new Traceability();
    }
    return INSTANCE;
  }
  
  private static Traceability INSTANCE;
  
  private Traceability() throws IncQueryException {
    querySpecifications.add(Param2itemQuerySpecification.instance());
    querySpecifications.add(Param2edgeQuerySpecification.instance());
    querySpecifications.add(Param2containmentQuerySpecification.instance());
  }
  
  public Param2itemQuerySpecification getParam2item() throws IncQueryException {
    return Param2itemQuerySpecification.instance();
  }
  
  public Param2itemMatcher getParam2item(final IncQueryEngine engine) throws IncQueryException {
    return Param2itemMatcher.on(engine);
  }
  
  public Param2edgeQuerySpecification getParam2edge() throws IncQueryException {
    return Param2edgeQuerySpecification.instance();
  }
  
  public Param2edgeMatcher getParam2edge(final IncQueryEngine engine) throws IncQueryException {
    return Param2edgeMatcher.on(engine);
  }
  
  public Param2containmentQuerySpecification getParam2containment() throws IncQueryException {
    return Param2containmentQuerySpecification.instance();
  }
  
  public Param2containmentMatcher getParam2containment(final IncQueryEngine engine) throws IncQueryException {
    return Param2containmentMatcher.on(engine);
  }
}
