/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.helper;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.incquery.patternlanguage.patternLanguage.AggregatedValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.Annotation;
import org.eclipse.incquery.patternlanguage.patternLanguage.AnnotationParameter;
import org.eclipse.incquery.patternlanguage.patternLanguage.CompareConstraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.Constraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.FunctionEvaluationValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.Modifiers;
import org.eclipse.incquery.patternlanguage.patternLanguage.ParameterRef;
import org.eclipse.incquery.patternlanguage.patternLanguage.PathExpressionConstraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.PathExpressionHead;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternBody;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternCall;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternCompositionConstraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternLanguageFactory;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternModel;
import org.eclipse.incquery.patternlanguage.patternLanguage.ValueReference;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.patternlanguage.patternLanguage.VariableReference;
import org.eclipse.incquery.patternlanguage.patternLanguage.VariableValue;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public final class CorePatternLanguageHelper {
    private CorePatternLanguageHelper() {
    }

    public static String getFullyQualifiedName(Pattern pattern) {
        String packageName;
        if (pattern == null) {
            throw new IllegalArgumentException("No pattern specified for getFullyQualifiedName");
        }
        PatternModel patternModel = (PatternModel)pattern.eContainer();
        String string = packageName = patternModel == null ? null : patternModel.getPackageName();
        if (packageName == null || packageName.isEmpty()) {
            return pattern.getName();
        }
        return String.valueOf(packageName) + "." + pattern.getName();
    }

    public static boolean isPrivate(Pattern pattern) {
        for (Modifiers mod : pattern.getModifiers()) {
            if (!mod.isPrivate()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasXBaseExpression(Pattern pattern) {
        TreeIterator eAllContents = pattern.eAllContents();
        while (eAllContents.hasNext()) {
            if (!(eAllContents.next() instanceof XExpression)) continue;
            return true;
        }
        return false;
    }

    public static Collection<XExpression> getAllTopLevelXBaseExpressions(EObject patternOrBody) {
        ArrayList<XExpression> result = new ArrayList<XExpression>();
        TreeIterator eAllContents = patternOrBody.eAllContents();
        while (eAllContents.hasNext()) {
            EObject content = (EObject)eAllContents.next();
            if (!(content instanceof XExpression)) continue;
            result.add((XExpression)content);
            eAllContents.prune();
        }
        return result;
    }

    public static Variable getParameterByName(Pattern pattern, final String name) {
        return (Variable)Iterables.find(pattern.getParameters(), (Predicate)new Predicate<Variable>(){

            public boolean apply(Variable variable) {
                return name.equals(variable.getName());
            }
        }, null);
    }

    public static Map<String, Integer> getParameterPositionsByName(Pattern pattern) {
        HashMap<String, Integer> posMapping = new HashMap<String, Integer>();
        int parameterPosition = 0;
        for (Variable parameter : pattern.getParameters()) {
            posMapping.put(parameter.getName(), parameterPosition++);
        }
        return posMapping;
    }

    public static Set<Variable> getReferencedPatternVariablesOfXExpression(XExpression xExpression, IJvmModelAssociations associations) {
        HashSet<Variable> result = new HashSet<Variable>();
        if (xExpression != null) {
            TreeIterator eAllContents = xExpression.eAllContents();
            while (eAllContents.hasNext()) {
                EObject expression = (EObject)eAllContents.next();
                EList eCrossReferences = expression.eCrossReferences();
                for (EObject eObject : eCrossReferences) {
                    if (!(eObject instanceof JvmFormalParameter) || EcoreUtil.isAncestor((EObject)xExpression, (EObject)eObject)) continue;
                    for (EObject obj : associations.getSourceElements(eObject)) {
                        if (!(obj instanceof Variable)) continue;
                        result.add((Variable)obj);
                    }
                }
            }
        }
        return result;
    }

    public static List<Variable> getUsedVariables(XExpression xExpression, Iterable<Variable> allVariables) {
        TreeIterator _eAllContents = xExpression.eAllContents();
        UnmodifiableIterator _filter = Iterators.filter((Iterator)_eAllContents, XFeatureCall.class);
        Functions.Function1<XFeatureCall, String> _function = new Functions.Function1<XFeatureCall, String>(){

            public String apply(XFeatureCall it) {
                String _concreteSyntaxFeatureName = it.getFeature().getSimpleName();
                return _concreteSyntaxFeatureName;
            }
        };
        Iterator _map = IteratorExtensions.map((Iterator)_filter, (Functions.Function1)_function);
        final List valNames = IteratorExtensions.toList((Iterator)_map);
        Functions.Function1<Variable, Boolean> _function_1 = new Functions.Function1<Variable, Boolean>(){

            public Boolean apply(Variable it) {
                String _name = it.getName();
                boolean _contains = valNames.contains(_name);
                return _contains;
            }
        };
        Iterable _filter_1 = IterableExtensions.filter(allVariables, (Functions.Function1)_function_1);
        Functions.Function1<Variable, String> _function_2 = new Functions.Function1<Variable, String>(){

            public String apply(Variable it) {
                String _name = it.getName();
                return _name;
            }
        };
        return IterableExtensions.sortBy((Iterable)_filter_1, (Functions.Function1)_function_2);
    }

    public static EList<Variable> getAllVariablesInBody(PatternBody body, EList<Variable> previous) {
        EList<Variable> variables = previous;
        HashMap<String, Variable> parameterMap = new HashMap<String, Variable>();
        EList<Variable> parameters = ((Pattern)body.eContainer()).getParameters();
        for (Variable var : variables) {
            parameterMap.put(var.getName(), var);
        }
        for (Variable var : parameters) {
            if (parameterMap.containsKey(var.getName())) continue;
            ParameterRef refVar = CorePatternLanguageHelper.initializeParameterRef(var);
            parameterMap.put(var.getName(), refVar);
            variables.add((Object)refVar);
        }
        int unnamedCounter = 0;
        for (Constraint constraint : body.getConstraints()) {
            TreeIterator it = constraint.eAllContents();
            while (it.hasNext()) {
                Variable var;
                EObject obj = (EObject)it.next();
                if (!(obj instanceof VariableReference)) continue;
                VariableReference varRef = (VariableReference)obj;
                String varName = varRef.getVar();
                if ("_".equals(varName)) {
                    varName = String.format("_<%d>", unnamedCounter);
                    ++unnamedCounter;
                }
                if (parameterMap.containsKey(varName)) {
                    var = (Variable)parameterMap.get(varName);
                } else {
                    var = CorePatternLanguageHelper.initializeLocalVariable(varName);
                    variables.add((Object)var);
                    parameterMap.put(varName, var);
                }
                varRef.setVariable(var);
            }
        }
        return variables;
    }

    private static Variable initializeLocalVariable(String varName) {
        Variable decl = PatternLanguageFactory.eINSTANCE.createVariable();
        decl.setName(varName);
        return decl;
    }

    private static ParameterRef initializeParameterRef(Variable var) {
        ParameterRef refVar = PatternLanguageFactory.eINSTANCE.createParameterRef();
        refVar.setName(var.getName());
        refVar.setReferredParam(var);
        return refVar;
    }

    public static Set<Pattern> getReferencedPatterns(Pattern sourcePattern) {
        HashSet<Pattern> result = new HashSet<Pattern>();
        TreeIterator eAllContents = sourcePattern.eAllContents();
        while (eAllContents.hasNext()) {
            PatternCall call;
            Pattern patternRef;
            EObject element = (EObject)eAllContents.next();
            if (!(element instanceof PatternCall) || (patternRef = (call = (PatternCall)element).getPatternRef()) == null) continue;
            result.add(patternRef);
        }
        return result;
    }

    public static Set<Pattern> getReferencedPatternsTransitive(Pattern pattern) {
        HashSet<Pattern> referencedPatterns = new HashSet<Pattern>();
        CorePatternLanguageHelper.calculateReferencedPatternsTransitive(pattern, referencedPatterns);
        return referencedPatterns;
    }

    private static void calculateReferencedPatternsTransitive(Pattern pattern, Set<Pattern> addedPatterns) {
        Set<Pattern> candidates = CorePatternLanguageHelper.getReferencedPatterns(pattern);
        candidates.removeAll(addedPatterns);
        addedPatterns.addAll(candidates);
        for (Pattern newCandidate : candidates) {
            CorePatternLanguageHelper.calculateReferencedPatternsTransitive(newCandidate, addedPatterns);
        }
    }

    public static Annotation getFirstAnnotationByName(Pattern pattern, String name) {
        return (Annotation)Iterables.find(pattern.getAnnotations(), (Predicate)new AnnotationNameFilter(name), null);
    }

    public static Collection<Annotation> getAnnotationsByName(Pattern pattern, String name) {
        return Collections2.filter(pattern.getAnnotations(), (Predicate)new AnnotationNameFilter(name));
    }

    public static ListMultimap<String, ValueReference> getAnnotationParameters(Annotation annotation) {
        ArrayListMultimap parameterMap = ArrayListMultimap.create();
        for (AnnotationParameter param : annotation.getParameters()) {
            parameterMap.put((Object)param.getName(), (Object)param.getValue());
        }
        return parameterMap;
    }

    public static Collection<ValueReference> getAnnotationParameters(Annotation annotation, final String parameterName) {
        return Collections2.transform((Collection)Collections2.filter(annotation.getParameters(), (Predicate)new Predicate<AnnotationParameter>(){

            public boolean apply(AnnotationParameter parameter) {
                Preconditions.checkArgument((parameter != null ? 1 : 0) != 0);
                return parameter.getName().equals(parameterName);
            }
        }), (Function)new Function<AnnotationParameter, ValueReference>(){

            public ValueReference apply(AnnotationParameter parameter) {
                Preconditions.checkArgument((parameter != null ? 1 : 0) != 0);
                return parameter.getValue();
            }
        });
    }

    public static ValueReference getFirstAnnotationParameter(Annotation annotation, String parameterName) {
        Collection<ValueReference> parameters = CorePatternLanguageHelper.getAnnotationParameters(annotation, parameterName);
        return !parameters.isEmpty() ? parameters.iterator().next() : null;
    }

    public static Set<Variable> getVariablesFromValueReference(ValueReference valueReference) {
        HashSet<Variable> resultSet = new HashSet<Variable>();
        if (valueReference != null) {
            if (valueReference instanceof VariableValue) {
                resultSet.add(((VariableValue)valueReference).getValue().getVariable());
            } else if (valueReference instanceof AggregatedValue) {
                AggregatedValue aggregatedValue = (AggregatedValue)valueReference;
                for (ValueReference valueReferenceInner : aggregatedValue.getCall().getParameters()) {
                    for (Variable variable : CorePatternLanguageHelper.getVariablesFromValueReference(valueReferenceInner)) {
                        resultSet.add(variable);
                    }
                }
            } else if (valueReference instanceof FunctionEvaluationValue) {
                FunctionEvaluationValue eval = (FunctionEvaluationValue)valueReference;
                List<Variable> usedVariables = CorePatternLanguageHelper.getUsedVariables(eval.getExpression(), CorePatternLanguageHelper.containerPatternBody(eval).getVariables());
                resultSet.addAll(usedVariables);
            }
        }
        return resultSet;
    }

    public static PatternBody containerPatternBody(ValueReference val) {
        ValueReference cursor = val;
        while (cursor != null) {
            if (cursor instanceof PatternBody) {
                return (PatternBody)((Object)cursor);
            }
            cursor = cursor.eContainer();
        }
        throw new IllegalArgumentException(String.format("Misplaced value reference %s not contained in any pattern body", val));
    }

    public static List<Variable> getUnnamedRunningVariables(PatternBody patternBody) {
        ArrayList<Variable> resultList = new ArrayList<Variable>();
        for (Constraint constraint : patternBody.getConstraints()) {
            if (constraint instanceof CompareConstraint) {
                CompareConstraint compareConstraint = (CompareConstraint)constraint;
                ValueReference leftValueReference = compareConstraint.getLeftOperand();
                ValueReference rightValueReference = compareConstraint.getRightOperand();
                resultList.addAll(CorePatternLanguageHelper.getUnnamedVariablesFromValueReference(leftValueReference, true));
                resultList.addAll(CorePatternLanguageHelper.getUnnamedVariablesFromValueReference(rightValueReference, true));
                continue;
            }
            if (constraint instanceof PatternCompositionConstraint) {
                PatternCompositionConstraint patternCompositionConstraint = (PatternCompositionConstraint)constraint;
                for (ValueReference valueReference : patternCompositionConstraint.getCall().getParameters()) {
                    resultList.addAll(CorePatternLanguageHelper.getUnnamedVariablesFromValueReference(valueReference, false));
                }
                continue;
            }
            if (!(constraint instanceof PathExpressionConstraint)) continue;
            PathExpressionConstraint pathExpressionConstraint = (PathExpressionConstraint)constraint;
            PathExpressionHead pathExpressionHead = pathExpressionConstraint.getHead();
            ValueReference valueReference = pathExpressionHead.getDst();
            resultList.addAll(CorePatternLanguageHelper.getUnnamedVariablesFromValueReference(valueReference, true));
        }
        return resultList;
    }

    private static Set<Variable> getUnnamedVariablesFromValueReference(ValueReference valueReference, boolean onlyFromAggregatedValues) {
        HashSet<Variable> resultSet;
        block7: {
            block8: {
                resultSet = new HashSet<Variable>();
                if (valueReference == null) break block7;
                if (!(valueReference instanceof VariableValue)) break block8;
                Variable variable = ((VariableValue)valueReference).getValue().getVariable();
                if (!variable.getName().startsWith("_") || onlyFromAggregatedValues) break block7;
                resultSet.add(variable);
                break block7;
            }
            if (valueReference instanceof AggregatedValue) {
                AggregatedValue aggregatedValue = (AggregatedValue)valueReference;
                for (ValueReference valueReferenceInner : aggregatedValue.getCall().getParameters()) {
                    for (Variable variable : CorePatternLanguageHelper.getUnnamedVariablesFromValueReference(valueReferenceInner, false)) {
                        if (!variable.getName().startsWith("_")) continue;
                        resultSet.add(variable);
                    }
                }
            } else if (valueReference instanceof FunctionEvaluationValue) {
                FunctionEvaluationValue eval = (FunctionEvaluationValue)valueReference;
                List<Variable> usedVariables = CorePatternLanguageHelper.getUsedVariables(eval.getExpression(), CorePatternLanguageHelper.containerPatternBody(eval).getVariables());
                if (!onlyFromAggregatedValues) {
                    for (Variable variable : usedVariables) {
                        if (!variable.getName().startsWith("_")) continue;
                        resultSet.add(variable);
                    }
                }
            }
        }
        return resultSet;
    }

    private static class AnnotationNameFilter
    implements Predicate<Annotation> {
        private final String name;

        public AnnotationNameFilter(String name) {
            this.name = name;
        }

        public boolean apply(Annotation annotation) {
            return this.name.equals(annotation.getName());
        }
    }
}

