package org.eclipse.incquery.testing.core.base;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.HashSet;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.snapshot.EIQSnapshot.IncQuerySnapshot;
import org.eclipse.incquery.snapshot.EIQSnapshot.MatchSetRecord;
import org.eclipse.incquery.testing.core.ModelLoadHelper;
import org.eclipse.incquery.testing.core.SnapshotHelper;
import org.eclipse.incquery.testing.core.TestExecutor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.junit.Assert;

/**
 * @deprecated use EIQTest api instead
 */
@Deprecated
@SuppressWarnings("all")
public abstract class CommonStaticQueryTester {
  @Inject
  @Extension
  private ModelLoadHelper _modelLoadHelper;
  
  @Inject
  @Extension
  private TestExecutor _testExecutor;
  
  @Inject
  @Extension
  private SnapshotHelper _snapshotHelper;
  
  @Inject
  private Injector injector;
  
  public void testQuery(final String queryFQN) {
    final IncQuerySnapshot sns = this.snapshot();
    Notifier _eMFRootForSnapshot = this._snapshotHelper.getEMFRootForSnapshot(sns);
    final IncQueryEngine engine = this.getEngine(_eMFRootForSnapshot);
    PatternModel _queryInput = this.queryInput();
    final IncQueryMatcher matcher = this._modelLoadHelper.initializeMatcherFromModel(_queryInput, engine, queryFQN);
    MatchSetRecord _matchSetRecordForPattern = this._snapshotHelper.getMatchSetRecordForPattern(sns, queryFQN);
    final HashSet<String> results = this._testExecutor.compareResultSets(matcher, _matchSetRecordForPattern);
    String _logDifference = this._testExecutor.logDifference(results);
    HashSet<Object> _newHashSet = CollectionLiterals.<Object>newHashSet();
    Assert.assertArrayEquals(_logDifference, ((Object[])Conversions.unwrapArray(_newHashSet, Object.class)), ((Object[])Conversions.unwrapArray(results, Object.class)));
  }
  
  public void testQuery(final IQuerySpecification queryMF) {
    final IncQuerySnapshot sns = this.snapshot();
    Notifier _eMFRootForSnapshot = this._snapshotHelper.getEMFRootForSnapshot(sns);
    final IncQueryEngine engine = this.getEngine(_eMFRootForSnapshot);
    this.testQuery(engine, sns, queryMF);
  }
  
  public void testQuery(final IncQueryEngine engine, final IncQuerySnapshot sns, final IQuerySpecification queryMF) {
    try {
      final IncQueryMatcher matcher = engine.<IncQueryMatcher<? extends IPatternMatch>>getMatcher(queryMF);
      String _fullyQualifiedName = queryMF.getFullyQualifiedName();
      MatchSetRecord _matchSetRecordForPattern = this._snapshotHelper.getMatchSetRecordForPattern(sns, _fullyQualifiedName);
      final HashSet<String> results = this._testExecutor.compareResultSets(matcher, _matchSetRecordForPattern);
      String _logDifference = this._testExecutor.logDifference(results);
      HashSet<Object> _newHashSet = CollectionLiterals.<Object>newHashSet();
      Assert.assertArrayEquals(_logDifference, ((Object[])Conversions.unwrapArray(_newHashSet, Object.class)), ((Object[])Conversions.unwrapArray(results, Object.class)));
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public IncQueryEngine getEngine(final Notifier root) {
    try {
      return IncQueryEngine.on(root);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  public IncQuerySnapshot snapshot() {
    String _snapshotURI = this.snapshotURI();
    IncQuerySnapshot _loadExpectedResultsFromUri = this._modelLoadHelper.loadExpectedResultsFromUri(_snapshotURI);
    return ((IncQuerySnapshot) _loadExpectedResultsFromUri);
  }
  
  public PatternModel queryInput() {
    String _queryInputEIQURI = this.queryInputEIQURI();
    Iterable<String> _queryInputDependencyURIs = this.queryInputDependencyURIs();
    PatternModel _loadPatternModelFromUri = this._modelLoadHelper.loadPatternModelFromUri(_queryInputEIQURI, this.injector, ((String[])Conversions.unwrapArray(_queryInputDependencyURIs, String.class)));
    return ((PatternModel) _loadPatternModelFromUri);
  }
  
  public abstract String snapshotURI();
  
  public abstract String queryInputEIQURI();
  
  public abstract Iterable<String> queryInputDependencyURIs();
}
