/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.databinding.runtime.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.AbstractObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.runtime.Assert;
import org.eclipse.incquery.databinding.runtime.collection.IObservablePatternMatchCollectionUpdate;
import org.eclipse.incquery.databinding.runtime.collection.ObservableCollectionHelper;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.evm.api.RuleEngine;
import org.eclipse.incquery.runtime.evm.api.RuleSpecification;
import org.eclipse.incquery.runtime.evm.api.event.EventFilter;
import org.eclipse.incquery.runtime.evm.specific.Rules;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryFilterSemantics;

public class ObservablePatternMatchList<Match extends IPatternMatch>
extends AbstractObservableList {
    private final List<Match> cache = Collections.synchronizedList(new ArrayList());
    private final ListCollectionUpdate updater = new ListCollectionUpdate();
    private RuleSpecification<Match> specification;

    public <Matcher extends IncQueryMatcher<Match>> ObservablePatternMatchList(IQuerySpecification<Matcher> querySpecification, IncQueryEngine engine) {
        this((Matcher)querySpecification);
        ObservableCollectionHelper.prepareRuleEngine(engine, this.specification, null);
    }

    public <Matcher extends IncQueryMatcher<Match>> ObservablePatternMatchList(IQuerySpecification<Matcher> querySpecification, IncQueryEngine engine, Match filter) {
        this((Matcher)querySpecification);
        ObservableCollectionHelper.prepareRuleEngine(engine, this.specification, filter);
    }

    public <Matcher extends IncQueryMatcher<Match>> ObservablePatternMatchList(IQuerySpecification<Matcher> querySpecification, IncQueryEngine engine, Collection<Match> multifilters, IncQueryFilterSemantics semantics) {
        this((Matcher)querySpecification);
        ObservableCollectionHelper.prepareRuleEngine(engine, this.specification, multifilters, semantics);
    }

    public <Matcher extends IncQueryMatcher<Match>> ObservablePatternMatchList(IQuerySpecification<Matcher> querySpecification, RuleEngine engine) {
        this((Matcher)querySpecification);
        engine.addRule(this.specification);
        ObservableCollectionHelper.fireActivations(engine, this.specification, this.specification.createEmptyFilter());
    }

    public <Matcher extends IncQueryMatcher<Match>> ObservablePatternMatchList(IQuerySpecification<Matcher> querySpecification, RuleEngine engine, Match filter) {
        this((Matcher)querySpecification);
        EventFilter matchFilter = Rules.newSingleMatchFilter(filter);
        engine.addRule(this.specification, matchFilter);
        ObservableCollectionHelper.fireActivations(engine, this.specification, matchFilter);
    }

    public <Matcher extends IncQueryMatcher<Match>> ObservablePatternMatchList(IQuerySpecification<Matcher> querySpecification, RuleEngine engine, Collection<Match> multifilter, IncQueryFilterSemantics semantics) {
        this((Matcher)querySpecification);
        EventFilter matchFilter = Rules.newMultiMatchFilter(multifilter, (IncQueryFilterSemantics)semantics);
        engine.addRule(this.specification, matchFilter);
        ObservableCollectionHelper.fireActivations(engine, this.specification, matchFilter);
    }

    protected <Matcher extends IncQueryMatcher<Match>> ObservablePatternMatchList(IQuerySpecification<Matcher> querySpecification) {
        this.specification = ObservableCollectionHelper.createRuleSpecification(this.updater, querySpecification);
    }

    public <Matcher extends IncQueryMatcher<Match>> ObservablePatternMatchList(Matcher matcher) {
        this.specification = ObservableCollectionHelper.createRuleSpecification(this.updater, matcher);
        ObservableCollectionHelper.prepareRuleEngine(matcher.getEngine(), this.specification, null);
    }

    public Object getElementType() {
        return IPatternMatch.class;
    }

    protected int doGetSize() {
        return this.cache.size();
    }

    public Object get(int index) {
        return this.cache.get(index);
    }

    public RuleSpecification<Match> getSpecification() {
        return this.specification;
    }

    public class ListCollectionUpdate
    implements IObservablePatternMatchCollectionUpdate<Match> {
        @Override
        public void addMatch(Match match) {
            ListDiffEntry diffentry = Diffs.createListDiffEntry((int)ObservablePatternMatchList.this.cache.size(), (boolean)true, match);
            ObservablePatternMatchList.this.cache.add(match);
            final ListDiff diff = Diffs.createListDiff((ListDiffEntry)diffentry);
            Realm realm = ObservablePatternMatchList.this.getRealm();
            Assert.isNotNull((Object)realm, (String)"Data binding Realm must not be null");
            realm.exec(new Runnable(){

                @Override
                public void run() {
                    if (!ObservablePatternMatchList.this.isDisposed()) {
                        ObservablePatternMatchList.this.fireListChange(diff);
                    }
                }
            });
        }

        @Override
        public void removeMatch(Match match) {
            int index = ObservablePatternMatchList.this.cache.indexOf(match);
            ListDiffEntry diffentry = Diffs.createListDiffEntry((int)index, (boolean)false, match);
            ObservablePatternMatchList.this.cache.remove(match);
            final ListDiff diff = Diffs.createListDiff((ListDiffEntry)diffentry);
            Realm realm = ObservablePatternMatchList.this.getRealm();
            Assert.isNotNull((Object)realm, (String)"Data binding Realm must not be null");
            realm.exec(new Runnable(){

                @Override
                public void run() {
                    if (!ObservablePatternMatchList.this.isDisposed()) {
                        ObservablePatternMatchList.this.fireListChange(diff);
                    }
                }
            });
        }
    }
}

