/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.databinding.runtime.collection;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.eclipse.incquery.databinding.runtime.collection.IObservablePatternMatchCollectionUpdate;
import org.eclipse.incquery.databinding.runtime.collection.ObservableCollectionProcessor;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.base.itc.alg.incscc.Direction;
import org.eclipse.incquery.runtime.evm.api.Activation;
import org.eclipse.incquery.runtime.evm.api.ActivationLifeCycle;
import org.eclipse.incquery.runtime.evm.api.Context;
import org.eclipse.incquery.runtime.evm.api.ExecutionSchema;
import org.eclipse.incquery.runtime.evm.api.Job;
import org.eclipse.incquery.runtime.evm.api.RuleEngine;
import org.eclipse.incquery.runtime.evm.api.RuleSpecification;
import org.eclipse.incquery.runtime.evm.api.Scheduler;
import org.eclipse.incquery.runtime.evm.api.event.EventFilter;
import org.eclipse.incquery.runtime.evm.specific.ExecutionSchemas;
import org.eclipse.incquery.runtime.evm.specific.Jobs;
import org.eclipse.incquery.runtime.evm.specific.Lifecycles;
import org.eclipse.incquery.runtime.evm.specific.Rules;
import org.eclipse.incquery.runtime.evm.specific.Schedulers;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryActivationStateEnum;
import org.eclipse.incquery.runtime.evm.specific.job.SequentialProcessorsJob;

public final class ObservableCollectionHelper {
    private ObservableCollectionHelper() {
    }

    protected static <Match extends IPatternMatch, Matcher extends IncQueryMatcher<Match>> RuleSpecification<Match> createRuleSpecification(IObservablePatternMatchCollectionUpdate<Match> observableCollectionUpdate, IQuerySpecification<Matcher> querySpecification) {
        Set<Job<Match>> jobs = ObservableCollectionHelper.getObservableCollectionJobs(observableCollectionUpdate);
        return Rules.newMatcherRuleSpecification(querySpecification, (ActivationLifeCycle)Lifecycles.getDefault((boolean)false, (boolean)true), jobs);
    }

    protected static <Match extends IPatternMatch, Matcher extends IncQueryMatcher<Match>> RuleSpecification<Match> createUpdatingRuleSpecification(IObservablePatternMatchCollectionUpdate<Match> observableCollectionUpdate, IQuerySpecification<Matcher> querySpecification) {
        Set<Job<Match>> jobs = ObservableCollectionHelper.getObservableCollectionJobs(observableCollectionUpdate);
        Job updateJob = Jobs.newErrorLoggingJob((Job)new SequentialProcessorsJob(IncQueryActivationStateEnum.UPDATED, (List)ImmutableList.of(new ObservableCollectionProcessor<Match>(Direction.DELETE, observableCollectionUpdate), new ObservableCollectionProcessor<Match>(Direction.INSERT, observableCollectionUpdate))));
        ImmutableSet allJobs = ImmutableSet.builder().addAll(jobs).add((Object)updateJob).build();
        return Rules.newMatcherRuleSpecification(querySpecification, (ActivationLifeCycle)Lifecycles.getDefault((boolean)true, (boolean)true), (Set)allJobs);
    }

    protected static <Match extends IPatternMatch, Matcher extends IncQueryMatcher<Match>> RuleSpecification<Match> createRuleSpecification(IObservablePatternMatchCollectionUpdate<Match> observableCollectionUpdate, Matcher matcher) {
        Set<Job<Match>> jobs = ObservableCollectionHelper.getObservableCollectionJobs(observableCollectionUpdate);
        return Rules.newMatcherRuleSpecification(matcher, (ActivationLifeCycle)Lifecycles.getDefault((boolean)false, (boolean)true), jobs);
    }

    private static <Match extends IPatternMatch> Set<Job<Match>> getObservableCollectionJobs(IObservablePatternMatchCollectionUpdate<Match> observableCollectionUpdate) {
        Job insertJob = Jobs.newErrorLoggingJob((Job)Jobs.newStatelessJob((IncQueryActivationStateEnum)IncQueryActivationStateEnum.APPEARED, new ObservableCollectionProcessor<Match>(Direction.INSERT, observableCollectionUpdate)));
        Job deleteJob = Jobs.newErrorLoggingJob((Job)Jobs.newStatelessJob((IncQueryActivationStateEnum)IncQueryActivationStateEnum.DISAPPEARED, new ObservableCollectionProcessor<Match>(Direction.DELETE, observableCollectionUpdate)));
        return ImmutableSet.of((Object)insertJob, (Object)deleteJob);
    }

    protected static <Match extends IPatternMatch> RuleEngine prepareRuleEngine(IncQueryEngine engine, RuleSpecification<Match> specification, EventFilter<Match> filter) {
        ExecutionSchema ruleEngine = ExecutionSchemas.createIncQueryExecutionSchema((IncQueryEngine)engine, (Scheduler.ISchedulerFactory)Schedulers.getIQEngineSchedulerFactory((IncQueryEngine)engine));
        ruleEngine.addRule(specification, filter);
        ObservableCollectionHelper.fireActivations((RuleEngine)ruleEngine, specification, filter);
        return ruleEngine;
    }

    static <Match extends IPatternMatch> void fireActivations(RuleEngine ruleEngine, RuleSpecification<Match> specification, EventFilter<Match> filter) {
        Set activations = ruleEngine.getActivations(specification, filter);
        Context context = Context.create();
        for (Activation activation : activations) {
            activation.fire(context);
        }
    }
}

