/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.emf.ui.feedback;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.incquery.tooling.core.generator.builder.IErrorFeedback;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.ui.editor.validation.MarkerCreator;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.Issue;

public class GeneratorMarkerFeedback
implements IErrorFeedback {
    @Inject
    private MarkerCreator markerCreator;
    @Inject
    private ILocationInFileProvider locationProvider;
    @Inject
    private Logger logger;

    public void reportError(EObject ctx, String message, String errorCode, Severity severity, String markerType) {
        try {
            Resource res = ctx.eResource();
            if (res != null && res.getURI().isPlatformResource()) {
                ITextRegion region = this.locationProvider.getSignificantTextRegion(ctx);
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IFile file = root.getFile((IPath)new Path(res.getURI().toPlatformString(true)));
                this.createMarker(message, errorCode, markerType, file, region, severity);
            }
        }
        catch (CoreException e) {
            this.logger.error((Object)"Error while creating error marker", (Throwable)e);
        }
    }

    public void reportErrorNoLocation(EObject ctx, String message, String errorCode, Severity severity, String markerType) {
        try {
            Resource res = ctx.eResource();
            if (res != null && res.getURI().isPlatformResource()) {
                ITextRegion region = ITextRegion.EMPTY_REGION;
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IFile file = root.getFile((IPath)new Path(res.getURI().toPlatformString(true)));
                this.createMarker(message, errorCode, markerType, file, region, severity);
            }
        }
        catch (CoreException e) {
            this.logger.error((Object)"Error while creating error marker", (Throwable)e);
        }
    }

    public void reportError(IFile file, String message, String errorCode, Severity severity, String markerType) {
        try {
            ITextRegion region = ITextRegion.EMPTY_REGION;
            this.createMarker(message, errorCode, markerType, file, region, severity);
        }
        catch (CoreException e) {
            this.logger.error((Object)"Error while creating error marker", (Throwable)e);
        }
    }

    private void createMarker(String message, String errorCode, String markerType, IFile file, ITextRegion region, Severity severity) throws CoreException {
        Issue.IssueImpl issue = new Issue.IssueImpl();
        issue.setOffset(Integer.valueOf(region.getOffset()));
        issue.setLength(Integer.valueOf(region.getLength()));
        issue.setMessage(message);
        issue.setCode(errorCode);
        issue.setSeverity(severity);
        issue.setType(CheckType.EXPENSIVE);
        this.markerCreator.createMarker((Issue)issue, (IResource)file, markerType);
    }

    public void clearMarkers(IResource resource, String markerType) {
        try {
            resource.deleteMarkers(markerType, true, 2);
        }
        catch (CoreException e) {
            this.logger.error((Object)"Error while clearing markers", (Throwable)e);
        }
    }
}

