/**
 * Copyright (c) 2010-2012, Mark Czotter, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Mark Czotter - initial API and implementation
 */
package org.eclipse.incquery.tooling.core.generator.jvmmodel;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedQuerySpecification;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.extensibility.IQuerySpecificationProvider;
import org.eclipse.incquery.tooling.core.generator.jvmmodel.JavadocInferrer;
import org.eclipse.incquery.tooling.core.generator.util.EMFJvmTypesBuilder;
import org.eclipse.incquery.tooling.core.generator.util.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * {@link IQuerySpecification} implementation inferrer.
 * 
 * @author Mark Czotter
 */
@SuppressWarnings("all")
public class PatternQuerySpecificationClassInferrer {
  @Inject
  @Extension
  private EMFJvmTypesBuilder _eMFJvmTypesBuilder;
  
  @Inject
  @Extension
  private EMFPatternLanguageJvmModelInferrerUtil _eMFPatternLanguageJvmModelInferrerUtil;
  
  @Inject
  @Extension
  private JavadocInferrer _javadocInferrer;
  
  @Inject
  @Extension
  private TypeReferences types;
  
  /**
   * Infers the {@link IQuerySpecification} implementation class from {@link Pattern}.
   */
  public JvmDeclaredType inferQuerySpecificationClass(final Pattern pattern, final boolean isPrelinkingPhase, final String querySpecificationPackageName, final JvmTypeReference matchClassRef, final JvmTypeReference matcherClassRef) {
    String _querySpecificationClassName = this._eMFPatternLanguageJvmModelInferrerUtil.querySpecificationClassName(pattern);
    final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
        public void apply(final JvmGenericType it) {
          it.setPackageName(querySpecificationPackageName);
          CharSequence _javadocQuerySpecificationClass = PatternQuerySpecificationClassInferrer.this._javadocInferrer.javadocQuerySpecificationClass(pattern);
          String _string = _javadocQuerySpecificationClass.toString();
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
          it.setFinal(true);
          EList<JvmTypeReference> _superTypes = it.getSuperTypes();
          JvmTypeReference _cloneWithProxies = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.cloneWithProxies(matcherClassRef);
          JvmTypeReference _newTypeRef = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, BaseGeneratedQuerySpecification.class, _cloneWithProxies);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes, _newTypeRef);
        }
      };
    final JvmGenericType querySpecificationClass = this._eMFJvmTypesBuilder.toClass(pattern, _querySpecificationClassName, _function);
    this.inferQuerySpecificationMethods(querySpecificationClass, pattern, matcherClassRef);
    this.inferQuerySpecificationConstructor(querySpecificationClass, pattern);
    this.inferQuerySpecificationField(querySpecificationClass, pattern);
    this.inferQuerySpecificationInnerClasses(querySpecificationClass, pattern);
    return querySpecificationClass;
  }
  
  /**
   * Infers methods for QuerySpecification class based on the input 'pattern'.
   */
  public boolean inferQuerySpecificationMethods(final JvmDeclaredType querySpecificationClass, final Pattern pattern, final JvmTypeReference matcherClassRef) {
    boolean _xblockexpression = false;
    {
      EList<JvmMember> _members = querySpecificationClass.getMembers();
      JvmParameterizedTypeReference _createTypeRef = this.types.createTypeRef(querySpecificationClass);
      final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
          public void apply(final JvmOperation it) {
            it.setVisibility(JvmVisibility.PUBLIC);
            it.setStatic(true);
            EList<JvmTypeReference> _exceptions = it.getExceptions();
            JvmTypeReference _newTypeRef = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, IncQueryException.class);
            PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, _newTypeRef);
            CharSequence _javadocQuerySpecificationInstanceMethod = PatternQuerySpecificationClassInferrer.this._javadocInferrer.javadocQuerySpecificationInstanceMethod(pattern);
            String _string = _javadocQuerySpecificationInstanceMethod.toString();
            PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setDocumentation(it, _string);
            final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
                public void apply(final ITreeAppendable it) {
                  StringConcatenation _builder = new StringConcatenation();
                  _builder.append("try {");
                  _builder.newLine();
                  _builder.append("\t");
                  _builder.append("return ");
                  String _querySpecificationHolderClassName = PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.querySpecificationHolderClassName(pattern);
                  _builder.append(_querySpecificationHolderClassName, "	");
                  _builder.append(".INSTANCE;");
                  _builder.newLineIfNotEmpty();
                  _builder.append("} catch (");
                  it.append(_builder);
                  PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.referClass(it, pattern, ExceptionInInitializerError.class);
                  it.append(" ");
                  StringConcatenation _builder_1 = new StringConcatenation();
                  _builder_1.append("err) {");
                  _builder_1.newLine();
                  _builder_1.append("\t");
                  _builder_1.append("processInitializerError(err);");
                  _builder_1.newLine();
                  _builder_1.append("\t");
                  _builder_1.append("throw err;");
                  _builder_1.newLine();
                  _builder_1.append("}");
                  _builder_1.newLine();
                  it.append(_builder_1);
                }
              };
            PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
          }
        };
      JvmOperation _method = this._eMFJvmTypesBuilder.toMethod(pattern, "instance", _createTypeRef, _function);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
      EList<JvmMember> _members_1 = querySpecificationClass.getMembers();
      JvmTypeReference _cloneWithProxies = this._eMFJvmTypesBuilder.cloneWithProxies(matcherClassRef);
      final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
          public void apply(final JvmOperation it) {
            it.setVisibility(JvmVisibility.PROTECTED);
            EList<JvmAnnotationReference> _annotations = it.getAnnotations();
            JvmAnnotationReference _annotation = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toAnnotation(pattern, Override.class);
            PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotation);
            EList<JvmFormalParameter> _parameters = it.getParameters();
            JvmTypeReference _newTypeRef = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, IncQueryEngine.class);
            JvmFormalParameter _parameter = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toParameter(pattern, "engine", _newTypeRef);
            PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
            EList<JvmTypeReference> _exceptions = it.getExceptions();
            JvmTypeReference _newTypeRef_1 = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, IncQueryException.class);
            PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, _newTypeRef_1);
            final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
                public void apply(final ITreeAppendable it) {
                  StringConcatenation _builder = new StringConcatenation();
                  _builder.append("return ");
                  String _matcherClassName = PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.matcherClassName(pattern);
                  _builder.append(_matcherClassName, "");
                  _builder.append(".on(engine);");
                  _builder.newLineIfNotEmpty();
                  it.append(_builder);
                }
              };
            PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
          }
        };
      JvmOperation _method_1 = this._eMFJvmTypesBuilder.toMethod(pattern, "instantiate", _cloneWithProxies, _function_1);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method_1);
      EList<JvmMember> _members_2 = querySpecificationClass.getMembers();
      JvmTypeReference _newTypeRef = this._eMFJvmTypesBuilder.newTypeRef(pattern, String.class);
      final Procedure1<JvmOperation> _function_2 = new Procedure1<JvmOperation>() {
          public void apply(final JvmOperation it) {
            it.setVisibility(JvmVisibility.PROTECTED);
            EList<JvmAnnotationReference> _annotations = it.getAnnotations();
            JvmAnnotationReference _annotation = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toAnnotation(pattern, Override.class);
            PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotation);
            final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
                public void apply(final ITreeAppendable it) {
                  StringConcatenation _builder = new StringConcatenation();
                  _builder.append("return \"");
                  String _bundleName = PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.bundleName(pattern);
                  _builder.append(_bundleName, "");
                  _builder.append("\";");
                  _builder.newLineIfNotEmpty();
                  it.append(_builder);
                }
              };
            PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
          }
        };
      JvmOperation _method_2 = this._eMFJvmTypesBuilder.toMethod(pattern, "getBundleName", _newTypeRef, _function_2);
      this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_2, _method_2);
      EList<JvmMember> _members_3 = querySpecificationClass.getMembers();
      JvmTypeReference _newTypeRef_1 = this._eMFJvmTypesBuilder.newTypeRef(pattern, String.class);
      final Procedure1<JvmOperation> _function_3 = new Procedure1<JvmOperation>() {
          public void apply(final JvmOperation it) {
            it.setVisibility(JvmVisibility.PROTECTED);
            EList<JvmAnnotationReference> _annotations = it.getAnnotations();
            JvmAnnotationReference _annotation = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toAnnotation(pattern, Override.class);
            PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotation);
            final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
                public void apply(final ITreeAppendable it) {
                  StringConcatenation _builder = new StringConcatenation();
                  _builder.append("return \"");
                  String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
                  _builder.append(_fullyQualifiedName, "");
                  _builder.append("\";");
                  _builder.newLineIfNotEmpty();
                  it.append(_builder);
                }
              };
            PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
          }
        };
      JvmOperation _method_3 = this._eMFJvmTypesBuilder.toMethod(pattern, "patternName", _newTypeRef_1, _function_3);
      boolean _add = this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_3, _method_3);
      _xblockexpression = (_add);
    }
    return _xblockexpression;
  }
  
  /**
   * Infers constructor for QuerySpecification class based on the input 'pattern'.
   */
  public boolean inferQuerySpecificationConstructor(final JvmDeclaredType querySpecificationClass, final Pattern pattern) {
    EList<JvmMember> _members = querySpecificationClass.getMembers();
    final Procedure1<JvmConstructor> _function = new Procedure1<JvmConstructor>() {
        public void apply(final JvmConstructor it) {
          String _simpleName = querySpecificationClass.getSimpleName();
          it.setSimpleName(_simpleName);
          it.setVisibility(JvmVisibility.PRIVATE);
          EList<JvmTypeReference> _exceptions = it.getExceptions();
          JvmTypeReference _newTypeRef = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, IncQueryException.class);
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, _newTypeRef);
          final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
              public void apply(final ITreeAppendable it) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("super();");
                it.append(_builder);
              }
            };
          PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
        }
      };
    JvmConstructor _constructor = this._eMFJvmTypesBuilder.toConstructor(pattern, _function);
    boolean _add = this._eMFJvmTypesBuilder.<JvmConstructor>operator_add(_members, _constructor);
    return _add;
  }
  
  /**
   * Infers field for QuerySpecification class based on the input 'pattern'.
   */
  public Object inferQuerySpecificationField(final JvmDeclaredType querySpecificationClass, final Pattern pattern) {
    return null;
  }
  
  /**
   * Infers inner class for QuerySpecification class based on the input 'pattern'.
   */
  public boolean inferQuerySpecificationInnerClasses(final JvmDeclaredType querySpecificationClass, final Pattern pattern) {
    boolean _xblockexpression = false;
    {
      EList<JvmMember> _members = querySpecificationClass.getMembers();
      String _querySpecificationProviderClassName = this._eMFPatternLanguageJvmModelInferrerUtil.querySpecificationProviderClassName(pattern);
      final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
          public void apply(final JvmGenericType it) {
            it.setVisibility(JvmVisibility.PUBLIC);
            it.setStatic(true);
            EList<JvmTypeReference> _superTypes = it.getSuperTypes();
            JvmParameterizedTypeReference _createTypeRef = PatternQuerySpecificationClassInferrer.this.types.createTypeRef(querySpecificationClass);
            JvmTypeReference _newTypeRef = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, IQuerySpecificationProvider.class, _createTypeRef);
            PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes, _newTypeRef);
            EList<JvmMember> _members = it.getMembers();
            JvmParameterizedTypeReference _createTypeRef_1 = PatternQuerySpecificationClassInferrer.this.types.createTypeRef(querySpecificationClass);
            final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
                public void apply(final JvmOperation it) {
                  it.setVisibility(JvmVisibility.PUBLIC);
                  EList<JvmAnnotationReference> _annotations = it.getAnnotations();
                  JvmAnnotationReference _annotation = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toAnnotation(pattern, Override.class);
                  PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmAnnotationReference>operator_add(_annotations, _annotation);
                  EList<JvmTypeReference> _exceptions = it.getExceptions();
                  JvmTypeReference _newTypeRef = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(pattern, IncQueryException.class);
                  PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, _newTypeRef);
                  final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
                      public void apply(final ITreeAppendable it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("return instance();");
                        it.append(_builder);
                      }
                    };
                  PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
                }
              };
            JvmOperation _method = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toMethod(pattern, "get", _createTypeRef_1, _function);
            PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
          }
        };
      JvmGenericType _class = this._eMFJvmTypesBuilder.toClass(pattern, _querySpecificationProviderClassName, _function);
      this._eMFJvmTypesBuilder.<JvmGenericType>operator_add(_members, _class);
      EList<JvmMember> _members_1 = querySpecificationClass.getMembers();
      String _querySpecificationHolderClassName = this._eMFPatternLanguageJvmModelInferrerUtil.querySpecificationHolderClassName(pattern);
      final Procedure1<JvmGenericType> _function_1 = new Procedure1<JvmGenericType>() {
          public void apply(final JvmGenericType it) {
            it.setVisibility(JvmVisibility.PRIVATE);
            it.setStatic(true);
            EList<JvmMember> _members = it.getMembers();
            JvmParameterizedTypeReference _createTypeRef = PatternQuerySpecificationClassInferrer.this.types.createTypeRef(querySpecificationClass);
            final Procedure1<JvmField> _function = new Procedure1<JvmField>() {
                public void apply(final JvmField it) {
                  it.setFinal(true);
                  it.setStatic(true);
                  final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
                      public void apply(final ITreeAppendable it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("make()");
                        it.append(_builder);
                      }
                    };
                  PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setInitializer(it, _function);
                }
              };
            JvmField _field = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toField(pattern, "INSTANCE", _createTypeRef, _function);
            PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmField>operator_add(_members, _field);
            EList<JvmMember> _members_1 = it.getMembers();
            JvmParameterizedTypeReference _createTypeRef_1 = PatternQuerySpecificationClassInferrer.this.types.createTypeRef(querySpecificationClass);
            final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
                public void apply(final JvmOperation it) {
                  it.setVisibility(JvmVisibility.PUBLIC);
                  it.setStatic(true);
                  final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
                      public void apply(final ITreeAppendable it) {
                        StringConcatenation _builder = new StringConcatenation();
                        _builder.append("try {");
                        _builder.newLine();
                        _builder.append("\t");
                        _builder.append("return new ");
                        String _querySpecificationClassName = PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.querySpecificationClassName(pattern);
                        _builder.append(_querySpecificationClassName, "	");
                        _builder.append("();");
                        _builder.newLineIfNotEmpty();
                        _builder.append("} catch (");
                        it.append(_builder);
                        PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.referClass(it, pattern, IncQueryException.class);
                        it.append(" ");
                        StringConcatenation _builder_1 = new StringConcatenation();
                        _builder_1.append("ex) {");
                        _builder_1.newLine();
                        _builder_1.append("\t");
                        _builder_1.append("throw new ");
                        it.append(_builder_1);
                        PatternQuerySpecificationClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.referClass(it, pattern, RuntimeException.class);
                        StringConcatenation _builder_2 = new StringConcatenation();
                        _builder_2.append("\t");
                        _builder_2.append("(ex);");
                        _builder_2.newLine();
                        _builder_2.append("}");
                        _builder_2.newLine();
                        it.append(_builder_2);
                      }
                    };
                  PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
                }
              };
            JvmOperation _method = PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.toMethod(pattern, "make", _createTypeRef_1, _function_1);
            PatternQuerySpecificationClassInferrer.this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method);
          }
        };
      JvmGenericType _class_1 = this._eMFJvmTypesBuilder.toClass(pattern, _querySpecificationHolderClassName, _function_1);
      boolean _add = this._eMFJvmTypesBuilder.<JvmGenericType>operator_add(_members_1, _class_1);
      _xblockexpression = (_add);
    }
    return _xblockexpression;
  }
}
