/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.base.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.incquery.runtime.base.api.DataTypeListener;
import org.eclipse.incquery.runtime.base.api.FeatureListener;
import org.eclipse.incquery.runtime.base.api.InstanceListener;
import org.eclipse.incquery.runtime.base.api.LightweightEObjectObserver;
import org.eclipse.incquery.runtime.base.comprehension.EMFModelComprehension;
import org.eclipse.incquery.runtime.base.comprehension.EMFVisitor;
import org.eclipse.incquery.runtime.base.core.NavigationHelperImpl;
import org.eclipse.incquery.runtime.base.core.NavigationHelperVisitor;
import org.eclipse.incquery.runtime.base.exception.IncQueryBaseException;

public class NavigationHelperContentAdapter
extends EContentAdapter {
    public static final EClass EOBJECT_CLASS = EcorePackage.eINSTANCE.getEObject();
    private final NavigationHelperImpl navigationHelper;
    private boolean isDirty = false;
    private Table<Object, Object, Set<EObject>> valueToFeatureToHolderMap;
    private Map<Object, Multiset<EObject>> featureToHolderMap;
    private Table<EObject, Object, Set<Object>> holderToFeatureToValueMap;
    private Map<Object, Set<EObject>> instanceMap;
    private Map<Object, Map<Object, Integer>> dataTypeMap;
    private Table<EObject, EReference, ListMultimap<EObject, EMFVisitor>> unresolvableProxyFeaturesMap;
    private ListMultimap<EObject, EMFVisitor> unresolvableProxyObjectsMap;
    private Set<EClassifier> knownClassifiers;
    private static Map<EClass, Set<EClass>> subTypeMap = new HashMap<EClass, Set<EClass>>();
    private Multimap<String, EPackage> ePackageMap;
    private static Map<EClassifier, String> uniqueIDFromClassifier = new HashMap<EClassifier, String>();
    private static Map<ETypedElement, String> uniqueIDFromTypedElement = new HashMap<ETypedElement, String>();
    private static Multimap<String, EClassifier> uniqueIDToClassifier = HashMultimap.create((int)100, (int)1);
    private static Multimap<String, ETypedElement> uniqueIDToTypedElement = HashMultimap.create((int)100, (int)1);
    protected EObject ignoreInsertionAndDeletion;
    private Multimap<String, EStructuralFeature> knownFeatures;
    private boolean isDynamicModel;

    public NavigationHelperContentAdapter(NavigationHelperImpl navigationHelper, boolean isDynamicModel) {
        this.navigationHelper = navigationHelper;
        this.isDynamicModel = isDynamicModel;
        this.unresolvableProxyFeaturesMap = HashBasedTable.create();
        this.unresolvableProxyObjectsMap = ArrayListMultimap.create();
        this.knownFeatures = ArrayListMultimap.create();
        this.valueToFeatureToHolderMap = HashBasedTable.create();
        this.instanceMap = new HashMap<Object, Set<EObject>>();
        this.dataTypeMap = new HashMap<Object, Map<Object, Integer>>();
        this.ePackageMap = HashMultimap.create();
        this.knownClassifiers = new HashSet<EClassifier>();
    }

    protected static String getUniqueIdentifier(EClassifier classifier) {
        String id = uniqueIDFromClassifier.get(classifier);
        if (id == null) {
            Preconditions.checkArgument((!classifier.eIsProxy() ? 1 : 0) != 0, (Object)String.format("Classifier %s is an unresolved proxy", classifier));
            id = String.valueOf(classifier.getEPackage().getNsURI()) + "##" + classifier.getName();
            uniqueIDFromClassifier.put(classifier, id);
            uniqueIDToClassifier.put((Object)id, (Object)classifier);
        }
        return id;
    }

    protected static String getUniqueIdentifier(ETypedElement typedElement) {
        String id = uniqueIDFromTypedElement.get(typedElement);
        if (id == null) {
            Preconditions.checkArgument((!typedElement.eIsProxy() ? 1 : 0) != 0, (Object)String.format("Element %s is an unresolved proxy", typedElement));
            id = String.valueOf(NavigationHelperContentAdapter.getUniqueIdentifier((EClassifier)typedElement.eContainer())) + "##" + typedElement.getEType().getName() + "##" + typedElement.getName();
            uniqueIDFromTypedElement.put(typedElement, id);
            uniqueIDToTypedElement.put((Object)id, (Object)typedElement);
        }
        return id;
    }

    public void notifyChanged(Notification notification) {
        try {
            super.notifyChanged(notification);
            Object oFeature = notification.getFeature();
            Object oNotifier = notification.getNotifier();
            if (oNotifier instanceof EObject && oFeature instanceof EStructuralFeature) {
                EObject notifier = (EObject)oNotifier;
                EStructuralFeature feature = (EStructuralFeature)oFeature;
                Object oldValue = notification.getOldValue();
                Object newValue = notification.getNewValue();
                int eventType = notification.getEventType();
                switch (eventType) {
                    case 3: {
                        this.featureUpdate(true, notifier, feature, newValue);
                        this.notifyLightweightObservers(notifier, feature, notification);
                        break;
                    }
                    case 5: {
                        for (Object newElement : (Collection)newValue) {
                            this.featureUpdate(true, notifier, feature, newElement);
                        }
                        this.notifyLightweightObservers(notifier, feature, notification);
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 4: {
                        this.featureUpdate(false, notifier, feature, oldValue);
                        this.notifyLightweightObservers(notifier, feature, notification);
                        break;
                    }
                    case 6: {
                        for (Object oldElement : (Collection)oldValue) {
                            this.featureUpdate(false, notifier, feature, oldElement);
                        }
                        this.notifyLightweightObservers(notifier, feature, notification);
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 9: {
                        this.featureResolve(notifier, feature, oldValue, newValue);
                        break;
                    }
                    case 1: 
                    case 2: {
                        this.featureUpdate(false, notifier, feature, oldValue);
                        this.notifyLightweightObservers(notifier, feature, notification);
                        this.featureUpdate(true, notifier, feature, newValue);
                        this.notifyLightweightObservers(notifier, feature, notification);
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (Exception ex) {
            this.processingFatal(ex, "handle the following update notification: " + notification);
        }
        this.notifyBaseIndexChangeListeners();
    }

    protected void notifyBaseIndexChangeListeners() {
        this.navigationHelper.notifyBaseIndexChangeListeners(this.isDirty);
        if (this.isDirty) {
            this.isDirty = false;
        }
    }

    private void featureResolve(EObject source, EStructuralFeature feature, Object oldValue, Object newValue) {
        EReference reference = (EReference)feature;
        EObject proxy = (EObject)oldValue;
        EObject resolved = (EObject)newValue;
        List<EMFVisitor> objectVisitors = this.popVisitorsSuspendedOnObject(proxy);
        for (EMFVisitor visitor : objectVisitors) {
            EMFModelComprehension.traverseObject(visitor, resolved);
        }
        List<EMFVisitor> featureVisitors = this.popVisitorsSuspendedOnFeature(source, reference, proxy);
        for (EMFVisitor visitor : featureVisitors) {
            EMFModelComprehension.traverseFeature(visitor, source, (EStructuralFeature)reference, resolved);
        }
    }

    private void featureUpdate(boolean isInsertion, EObject notifier, EStructuralFeature feature, Object value) {
        EMFModelComprehension.traverseFeature(this.visitor(isInsertion), notifier, feature, value);
    }

    protected void addAdapter(final Notifier notifier) {
        if (notifier == this.ignoreInsertionAndDeletion) {
            return;
        }
        try {
            this.navigationHelper.coalesceTraversals(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (notifier instanceof EObject) {
                        EMFModelComprehension.traverseObject(NavigationHelperContentAdapter.this.visitor(true), (EObject)notifier);
                    }
                    NavigationHelperContentAdapter.super.addAdapter(notifier);
                    return null;
                }
            });
        }
        catch (InvocationTargetException ex) {
            this.processingFatal(ex.getCause(), "add the object: " + notifier);
        }
        catch (Exception ex) {
            this.processingFatal(ex, "add the object: " + notifier);
        }
    }

    protected void removeAdapter(final Notifier notifier) {
        if (notifier == this.ignoreInsertionAndDeletion) {
            return;
        }
        try {
            this.navigationHelper.coalesceTraversals(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (notifier instanceof EObject) {
                        EMFModelComprehension.traverseObject(NavigationHelperContentAdapter.this.visitor(false), (EObject)notifier);
                    }
                    NavigationHelperContentAdapter.super.removeAdapter(notifier);
                    return null;
                }
            });
        }
        catch (InvocationTargetException ex) {
            this.processingFatal(ex.getCause(), "remove the object: " + notifier);
        }
        catch (Exception ex) {
            this.processingFatal(ex, "remove the object: " + notifier);
        }
    }

    protected void processingFatal(Throwable ex, String task) {
        this.navigationHelper.getLogger().fatal((Object)this.logTaskFormat(task), ex);
    }

    protected void processingError(Throwable ex, String task) {
        this.navigationHelper.getLogger().error((Object)this.logTaskFormat(task), ex);
    }

    private String logTaskFormat(String task) {
        return "EMF-IncQuery encountered an error in processing the EMF model. This happened while trying to " + task;
    }

    protected EMFVisitor visitor(boolean isInsertion) {
        return new NavigationHelperVisitor.ChangeVisitor(this.navigationHelper, isInsertion);
    }

    private void addToFeatureMap(EStructuralFeature feature, Object value, EObject holder) {
        HashSet<EObject> setVal;
        Set<Object> set = setVal = this.isDynamicModel ? (Set)this.valueToFeatureToHolderMap.get(value, (Object)NavigationHelperContentAdapter.getUniqueIdentifier((ETypedElement)feature)) : (HashSet<EObject>)this.valueToFeatureToHolderMap.get(value, (Object)feature);
        if (setVal == null) {
            setVal = new HashSet<EObject>();
            if (this.isDynamicModel) {
                this.valueToFeatureToHolderMap.put(value, (Object)NavigationHelperContentAdapter.getUniqueIdentifier((ETypedElement)feature), setVal);
            } else {
                this.valueToFeatureToHolderMap.put(value, (Object)feature, setVal);
            }
        }
        setVal.add(holder);
    }

    private void addToReversedFeatureMap(Object feature, EObject holder) {
        HashMultiset setVal = this.featureToHolderMap.get(feature);
        if (setVal == null) {
            setVal = HashMultiset.create();
            this.featureToHolderMap.put(feature, (Multiset<EObject>)setVal);
        }
        setVal.add((Object)holder);
    }

    private void addToDirectFeatureMap(EObject holder, Object feature, Object value) {
        HashSet<Object> setVal = (HashSet<Object>)this.holderToFeatureToValueMap.get((Object)holder, feature);
        if (setVal == null) {
            setVal = new HashSet<Object>();
            this.holderToFeatureToValueMap.put((Object)holder, feature, setVal);
        }
        setVal.add(value);
    }

    private void removeFromReversedFeatureMap(Object feature, EObject holder) {
        Multiset<EObject> setVal = this.featureToHolderMap.get(feature);
        if (setVal != null) {
            setVal.remove((Object)holder);
            if (setVal.isEmpty()) {
                this.featureToHolderMap.remove(feature);
            }
        }
    }

    private void removeFromFeatureMap(EStructuralFeature feature, Object value, EObject holder) {
        Set setHolder;
        Set set = setHolder = this.isDynamicModel ? (Set)this.valueToFeatureToHolderMap.get(value, (Object)NavigationHelperContentAdapter.getUniqueIdentifier((ETypedElement)feature)) : (Set)this.valueToFeatureToHolderMap.get(value, (Object)feature);
        if (setHolder != null) {
            setHolder.remove(holder);
            if (setHolder.isEmpty()) {
                if (this.isDynamicModel) {
                    this.valueToFeatureToHolderMap.remove(value, (Object)NavigationHelperContentAdapter.getUniqueIdentifier((ETypedElement)feature));
                } else {
                    this.valueToFeatureToHolderMap.remove(value, (Object)feature);
                }
            }
        }
    }

    private void removeFromDirectFeatureMap(EObject holder, Object feature, Object value) {
        Set setVal = (Set)this.holderToFeatureToValueMap.get((Object)holder, feature);
        if (setVal != null) {
            setVal.remove(value);
            if (setVal.isEmpty()) {
                this.valueToFeatureToHolderMap.remove((Object)holder, feature);
            }
        }
    }

    public void insertFeatureTuple(EStructuralFeature feature, Object value, EObject holder) {
        Object dynamicFeature;
        this.addToFeatureMap(feature, value, holder);
        Object object = dynamicFeature = this.isDynamicModel ? NavigationHelperContentAdapter.getUniqueIdentifier((ETypedElement)feature) : feature;
        if (this.featureToHolderMap != null) {
            this.addToReversedFeatureMap(dynamicFeature, holder);
        }
        if (this.holderToFeatureToValueMap != null) {
            this.addToDirectFeatureMap(holder, dynamicFeature, value);
        }
        if (this.isDynamicModel) {
            this.knownFeatures.put((Object)NavigationHelperContentAdapter.getUniqueIdentifier((ETypedElement)feature), (Object)feature);
        }
        this.isDirty = true;
        this.notifyFeatureListeners(holder, feature, value, true);
    }

    public void removeFeatureTuple(EStructuralFeature feature, Object value, EObject holder) {
        Object dynamicFeature;
        this.removeFromFeatureMap(feature, value, holder);
        Object object = dynamicFeature = this.isDynamicModel ? NavigationHelperContentAdapter.getUniqueIdentifier((ETypedElement)feature) : feature;
        if (this.featureToHolderMap != null) {
            this.removeFromReversedFeatureMap(dynamicFeature, holder);
        }
        if (this.holderToFeatureToValueMap != null) {
            this.removeFromDirectFeatureMap(holder, dynamicFeature, value);
        }
        if (this.isDynamicModel) {
            this.knownFeatures.remove((Object)NavigationHelperContentAdapter.getUniqueIdentifier((ETypedElement)feature), (Object)feature);
        }
        this.isDirty = true;
        this.notifyFeatureListeners(holder, feature, value, false);
    }

    public Set<EObject> getInstanceSet(EClass keyClass) {
        if (this.isDynamicModel) {
            return this.instanceMap.get(NavigationHelperContentAdapter.getUniqueIdentifier((EClassifier)keyClass));
        }
        return this.instanceMap.get(keyClass);
    }

    public void removeInstanceSet(EClass keyClass) {
        if (this.isDynamicModel) {
            this.instanceMap.remove(NavigationHelperContentAdapter.getUniqueIdentifier((EClassifier)keyClass));
        } else {
            this.instanceMap.remove(keyClass);
        }
    }

    public void insertIntoInstanceSet(EClass keyClass, EObject value) {
        Set<EObject> set;
        Set<EObject> set2 = set = this.isDynamicModel ? this.instanceMap.get(NavigationHelperContentAdapter.getUniqueIdentifier((EClassifier)keyClass)) : this.instanceMap.get(keyClass);
        if (set == null) {
            set = new HashSet<EObject>();
            if (this.isDynamicModel) {
                this.instanceMap.put(NavigationHelperContentAdapter.getUniqueIdentifier((EClassifier)keyClass), set);
            } else {
                this.instanceMap.put(keyClass, set);
            }
        }
        set.add(value);
        this.isDirty = true;
        this.notifyInstanceListeners(keyClass, value, true);
    }

    public void removeFromInstanceSet(EClass keyClass, EObject value) {
        Set<EObject> set;
        Set<EObject> set2 = set = this.isDynamicModel ? this.instanceMap.get(NavigationHelperContentAdapter.getUniqueIdentifier((EClassifier)keyClass)) : this.instanceMap.get(keyClass);
        if (set != null) {
            set.remove(value);
            if (set.isEmpty()) {
                if (this.isDynamicModel) {
                    this.instanceMap.remove(NavigationHelperContentAdapter.getUniqueIdentifier((EClassifier)keyClass));
                } else {
                    this.instanceMap.remove(keyClass);
                }
            }
        }
        this.isDirty = true;
        this.notifyInstanceListeners(keyClass, value, false);
    }

    public Map<Object, Integer> getDataTypeMap(EDataType keyType) {
        if (this.isDynamicModel) {
            return this.dataTypeMap.get(NavigationHelperContentAdapter.getUniqueIdentifier((EClassifier)keyType));
        }
        return this.dataTypeMap.get(keyType);
    }

    public void removeDataTypeMap(EDataType keyType) {
        if (this.isDynamicModel) {
            this.dataTypeMap.remove(NavigationHelperContentAdapter.getUniqueIdentifier((EClassifier)keyType));
        } else {
            this.dataTypeMap.remove(keyType);
        }
    }

    public void insertIntoDataTypeMap(EDataType keyType, Object value) {
        Map<Object, Integer> valMap;
        Map<Object, Integer> map = valMap = this.isDynamicModel ? this.dataTypeMap.get(NavigationHelperContentAdapter.getUniqueIdentifier((EClassifier)keyType)) : this.dataTypeMap.get(keyType);
        if (valMap == null) {
            valMap = new HashMap<Object, Integer>();
            if (this.isDynamicModel) {
                this.dataTypeMap.put(NavigationHelperContentAdapter.getUniqueIdentifier((EClassifier)keyType), valMap);
            } else {
                this.dataTypeMap.put(keyType, valMap);
            }
        }
        if (valMap.get(value) == null) {
            valMap.put(value, 1);
        } else {
            Integer count = valMap.get(value);
            count = count + 1;
            valMap.put(value, count);
        }
        this.isDirty = true;
        this.notifyDataTypeListeners(keyType, value, true);
    }

    public void removeFromDataTypeMap(EDataType keyType, Object value) {
        Map<Object, Integer> valMap;
        Map<Object, Integer> map = valMap = this.isDynamicModel ? this.dataTypeMap.get(NavigationHelperContentAdapter.getUniqueIdentifier((EClassifier)keyType)) : this.dataTypeMap.get(keyType);
        if (valMap != null) {
            if (valMap.get(value) != null) {
                Integer count = valMap.get(value);
                if ((count = Integer.valueOf(count - 1)) == 0) {
                    valMap.remove(value);
                } else {
                    valMap.put(value, count);
                }
            }
            if (valMap.size() == 0) {
                if (this.isDynamicModel) {
                    this.dataTypeMap.remove(NavigationHelperContentAdapter.getUniqueIdentifier((EClassifier)keyType));
                } else {
                    this.dataTypeMap.remove(keyType);
                }
            }
        }
        this.isDirty = true;
        this.notifyDataTypeListeners(keyType, value, false);
    }

    private boolean isSubTypeOf(EClass sub, EClass sup) {
        Set<EClass> set = subTypeMap.get(sup);
        if (set != null) {
            return set.contains(sub);
        }
        return false;
    }

    protected <T extends EClassifier> void maintainMetamodel(Collection<T> classifiers) {
        for (EClassifier classifier : classifiers) {
            this.maintainMetamodel(classifier);
        }
    }

    protected void maintainMetamodel(EStructuralFeature feature) {
        this.maintainMetamodel((EClassifier)feature.getEContainingClass());
        this.maintainMetamodel(feature.getEType());
    }

    protected void maintainMetamodel(EClassifier classifier) {
        if (!this.knownClassifiers.contains(classifier)) {
            this.checkEPackage(classifier);
            this.knownClassifiers.add(classifier);
            if (classifier instanceof EClass) {
                EClass clazz = (EClass)classifier;
                for (EClass superType : clazz.getEAllSuperTypes()) {
                    this.maintainTypeHierarhyInternal(clazz, superType);
                }
                this.maintainTypeHierarhyInternal(clazz, EOBJECT_CLASS);
            }
        }
    }

    private void checkEPackage(EClassifier classifier) {
        Collection otherPackages = this.ePackageMap.get((Object)classifier.getEPackage().getNsURI());
        if (!otherPackages.contains(classifier.getEPackage())) {
            this.ePackageMap.put((Object)classifier.getEPackage().getNsURI(), (Object)classifier.getEPackage());
            if (!this.isDynamicModel && otherPackages.size() == 2) {
                this.processingError(new IncQueryBaseException("NsURI (" + classifier.getEPackage().getNsURI() + ") collision detected between different instances of EPackages. If this is normal, try using dynamic EMF mode."), "process new metamodel elements.");
            }
        }
    }

    private void maintainTypeHierarhyInternal(EClass clazz, EClass superType) {
        Set<EClass> set;
        if (this.navigationHelper.directlyObservedClasses.contains(superType)) {
            this.navigationHelper.getAllObservedClasses().add(clazz);
        }
        if ((set = subTypeMap.get(superType)) == null) {
            set = new HashSet<EClass>();
            subTypeMap.put(superType, set);
        }
        set.add(clazz);
    }

    private void notifyDataTypeListeners(EDataType type, Object value, boolean isInsertion) {
        for (Map.Entry<DataTypeListener, Collection<EDataType>> entry : this.navigationHelper.getDataTypeListeners().entrySet()) {
            if (!entry.getValue().contains(type)) continue;
            if (isInsertion) {
                entry.getKey().dataTypeInstanceInserted(type, value);
                continue;
            }
            entry.getKey().dataTypeInstanceDeleted(type, value);
        }
    }

    private void notifyFeatureListeners(EObject host, EStructuralFeature feature, Object value, boolean isInsertion) {
        for (Map.Entry<FeatureListener, Collection<EStructuralFeature>> entry : this.navigationHelper.getFeatureListeners().entrySet()) {
            if (!entry.getValue().contains(feature)) continue;
            if (isInsertion) {
                entry.getKey().featureInserted(host, feature, value);
                continue;
            }
            entry.getKey().featureDeleted(host, feature, value);
        }
    }

    private void notifyInstanceListeners(EClass clazz, EObject instance, boolean isInsertion) {
        for (Map.Entry<InstanceListener, Collection<EClass>> entry : this.navigationHelper.getInstanceListeners().entrySet()) {
            for (EClass sup : entry.getValue()) {
                if (!this.isSubTypeOf(clazz, sup) && !clazz.equals(sup)) continue;
                if (isInsertion) {
                    entry.getKey().instanceInserted(sup, instance);
                    continue;
                }
                entry.getKey().instanceDeleted(sup, instance);
            }
        }
    }

    private void notifyLightweightObservers(EObject host, EStructuralFeature feature, Notification notification) {
        for (Map.Entry<LightweightEObjectObserver, Collection<EObject>> entry : this.navigationHelper.getLightweightObservers().entrySet()) {
            if (!entry.getValue().contains(host)) continue;
            entry.getKey().notifyFeatureChanged(host, feature, notification);
        }
    }

    private void initReversedFeatureMap() {
        for (Table.Cell valueToFeatureHolderMap : this.valueToFeatureToHolderMap.cellSet()) {
            Object feature = valueToFeatureHolderMap.getColumnKey();
            for (EObject holder : (Set)valueToFeatureHolderMap.getValue()) {
                this.addToReversedFeatureMap(feature, holder);
            }
        }
    }

    private void initDirectFeatureMap() {
        for (Table.Cell valueToFeatureHolderMap : this.valueToFeatureToHolderMap.cellSet()) {
            Object value = valueToFeatureHolderMap.getRowKey();
            Object feature = valueToFeatureHolderMap.getColumnKey();
            for (EObject holder : (Set)valueToFeatureHolderMap.getValue()) {
                this.addToDirectFeatureMap(holder, feature, value);
            }
        }
    }

    protected void setTarget(ResourceSet target) {
        this.basicSetTarget((Notifier)target);
        EList resources = target.getResources();
        int i = 0;
        while (i < resources.size()) {
            Notifier notifier = (Notifier)resources.get(i);
            if (!notifier.eAdapters().contains((Object)this)) {
                this.addAdapter(notifier);
            }
            ++i;
        }
    }

    protected void setTarget(EObject target) {
        this.basicSetTarget((Notifier)target);
        this.spreadToChildren(target, true);
    }

    protected void unsetTarget(EObject target) {
        this.basicUnsetTarget((Notifier)target);
        this.spreadToChildren(target, false);
    }

    protected void spreadToChildren(EObject target, boolean add) {
        EList features = target.eClass().getEAllReferences();
        for (EReference feature : features) {
            if (!feature.isContainment() || !EMFModelComprehension.representable((EStructuralFeature)feature)) continue;
            if (feature.isMany()) {
                Collection values = (Collection)target.eGet((EStructuralFeature)feature);
                for (Object value : values) {
                    Notifier notifier = (Notifier)value;
                    if (add) {
                        this.addAdapter(notifier);
                        continue;
                    }
                    this.removeAdapter(notifier);
                }
                continue;
            }
            Object value = target.eGet((EStructuralFeature)feature);
            if (value == null) continue;
            Notifier notifier = (Notifier)value;
            if (add) {
                this.addAdapter(notifier);
                continue;
            }
            this.removeAdapter(notifier);
        }
    }

    public void suspendVisitorOnUnresolvableFeature(EMFVisitor visitor, EObject source, EReference reference, EObject target, boolean isInsertion) {
        ListMultimap targetToVisitor = (ListMultimap)this.unresolvableProxyFeaturesMap.get((Object)source, (Object)reference);
        if (targetToVisitor == null) {
            targetToVisitor = ArrayListMultimap.create();
            this.unresolvableProxyFeaturesMap.put((Object)source, (Object)reference, (Object)targetToVisitor);
        }
        if (isInsertion) {
            targetToVisitor.put((Object)target, (Object)visitor);
        } else {
            targetToVisitor.remove((Object)target, (Object)visitor);
        }
        if (targetToVisitor.isEmpty()) {
            this.unresolvableProxyFeaturesMap.remove((Object)source, (Object)reference);
        }
    }

    public void suspendVisitorOnUnresolvableObject(EMFVisitor visitor, EObject source, boolean isInsertion) {
        if (isInsertion) {
            this.unresolvableProxyObjectsMap.put((Object)source, (Object)visitor);
        } else {
            this.unresolvableProxyObjectsMap.remove((Object)source, (Object)visitor);
        }
    }

    private List<EMFVisitor> popVisitorsSuspendedOnFeature(EObject source, EReference reference, EObject target) {
        ListMultimap targetToVisitor = (ListMultimap)this.unresolvableProxyFeaturesMap.get((Object)source, (Object)reference);
        if (targetToVisitor == null) {
            return Collections.emptyList();
        }
        List result = targetToVisitor.removeAll((Object)target);
        if (targetToVisitor.isEmpty()) {
            this.unresolvableProxyFeaturesMap.remove((Object)source, (Object)reference);
        }
        return result;
    }

    private List<EMFVisitor> popVisitorsSuspendedOnObject(EObject source) {
        return this.unresolvableProxyObjectsMap.removeAll((Object)source);
    }

    protected Table<Object, Object, Set<EObject>> getValueToFeatureToHolderMap() {
        return this.valueToFeatureToHolderMap;
    }

    protected Map<Object, Multiset<EObject>> getFeatureToHolderMap() {
        if (this.featureToHolderMap == null) {
            this.featureToHolderMap = new HashMap<Object, Multiset<EObject>>();
            this.initReversedFeatureMap();
        }
        return this.featureToHolderMap;
    }

    protected Table<EObject, Object, Set<Object>> getHolderToFeatureToValueMap() {
        if (this.holderToFeatureToValueMap == null) {
            this.holderToFeatureToValueMap = HashBasedTable.create();
            this.initDirectFeatureMap();
        }
        return this.holderToFeatureToValueMap;
    }

    protected Table<EObject, EReference, ListMultimap<EObject, EMFVisitor>> getUnresolvableProxyFeaturesMap() {
        return this.unresolvableProxyFeaturesMap;
    }

    protected ListMultimap<EObject, EMFVisitor> getUnresolvableProxyObjectsMap() {
        return this.unresolvableProxyObjectsMap;
    }

    protected static Map<EClass, Set<EClass>> getSubTypeMap() {
        return subTypeMap;
    }

    public EStructuralFeature getKnownFeature(String featureId) {
        Collection features = this.knownFeatures.get((Object)featureId);
        if (features.size() == 0) {
            return null;
        }
        return (EStructuralFeature)features.iterator().next();
    }

    public Set<EClass> getAllCurrentClasses() {
        HashSet result = Sets.newHashSet();
        Set<Object> classifiers = this.instanceMap.keySet();
        for (Object classifierElement : classifiers) {
            if (this.isDynamicModel) {
                Collection classifiersOfThisID = uniqueIDToClassifier.get((Object)((String)classifierElement));
                if (classifiersOfThisID.isEmpty()) continue;
                result.add((EClass)classifiersOfThisID.iterator().next());
                continue;
            }
            result.add((EClass)classifierElement);
        }
        return result;
    }

    public boolean isDynamicModel() {
        return this.isDynamicModel;
    }
}

