/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.vocabulary.importer.importWizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.opencert.userguidance.util.CdoConnection;
import org.eclipse.opencert.userguidance.util.CdoUtil;
import org.eclipse.opencert.vocabulary.Vocabulary;
import org.eclipse.opencert.vocabulary.importer.importWizards.CdoImportWizardPage;
import org.eclipse.opencert.vocabulary.importer.parser.Parser;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class CdoVocabularyImportWizard
extends Wizard
implements IImportWizard {
    CdoImportWizardPage mainPage;
    private List<CDOResourceNode> cdoNodes;
    private CdoConnection connection = new CdoConnection();

    public boolean performFinish() {
        try {
            String inputFilename = this.mainPage.getInputFilename();
            FileInputStream inputStream = new FileInputStream(new File(inputFilename));
            Vocabulary vocabulary = Parser.parseVocabulary((InputStream)inputStream);
            String targetResourceName = this.mainPage.getResourceName();
            CDOTransaction transaction = this.connection.getTransaction("Vocabulary Import");
            CDOResource resource = transaction.createResource(targetResourceName);
            resource.getContents().add((Object)vocabulary);
            resource.save(Collections.EMPTY_MAP);
            transaction.commit();
            transaction.close();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("Vocabulary Import Wizard");
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.cdoNodes = CdoUtil.getResources((CdoConnection)this.connection, (boolean)false);
        this.mainPage = new CdoImportWizardPage("Import from File", this.cdoNodes);
        this.addPage((IWizardPage)this.mainPage);
    }

    public void dispose() {
        super.dispose();
    }
}

