/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.internal.resource.index;

import com.google.common.base.Objects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.papyrus.infra.core.utils.JobBasedFuture;
import org.eclipse.papyrus.infra.core.utils.JobExecutorService;
import org.eclipse.papyrus.infra.emf.Activator;
import org.eclipse.papyrus.infra.emf.internal.resource.index.InternalModelIndex;
import org.eclipse.papyrus.infra.emf.resource.index.IWorkspaceModelIndexListener;
import org.eclipse.papyrus.infra.emf.resource.index.IWorkspaceModelIndexProvider;
import org.eclipse.papyrus.infra.emf.resource.index.WorkspaceModelIndex;
import org.eclipse.papyrus.infra.emf.resource.index.WorkspaceModelIndexEvent;
import org.eclipse.papyrus.infra.tools.util.ReferenceCounted;

public class IndexManager {
    private static final int MAX_INDEX_RETRIES = 3;
    private static final IndexManager INSTANCE = new IndexManager();
    private final IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
    private final IResourceChangeListener workspaceListener = new WorkspaceListener();
    private final Map<IProject, AbstractIndexJob> activeJobs = Maps.newHashMap();
    private final ContentTypeService contentTypeService;
    private Map<QualifiedName, InternalModelIndex> indices;
    private JobWrangler jobWrangler;
    private final CopyOnWriteArrayList<IndexListener> listeners = new CopyOnWriteArrayList();

    public IndexManager() {
        this.contentTypeService = ContentTypeService.getInstance();
    }

    public static IndexManager getInstance() {
        return INSTANCE;
    }

    public void dispose() {
        if (this.indices != null) {
            this.wsRoot.getWorkspace().removeResourceChangeListener(this.workspaceListener);
            Job.getJobManager().cancel((Object)this);
            this.indices.values().forEach(InternalModelIndex::dispose);
            ContentTypeService.dispose(this.contentTypeService);
        }
    }

    public void startManager() {
        if (this.indices != null) {
            throw new IllegalStateException("index manager already started");
        }
        this.indices = this.loadIndices();
        int maxConcurrentJobs = this.indices.values().stream().mapToInt(InternalModelIndex::getMaxIndexJobs).max().orElse(5);
        this.jobWrangler = new JobWrangler(maxConcurrentJobs);
        this.indices.values().forEach(this::startIndex);
        this.index(Arrays.asList(this.wsRoot.getProjects()));
        this.wsRoot.getWorkspace().addResourceChangeListener(this.workspaceListener, 1);
    }

    private void startIndex(InternalModelIndex index) {
        index.start(this);
    }

    protected Map<QualifiedName, InternalModelIndex> loadIndices() {
        HashMap result = Maps.newHashMap();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.emf", "index");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            if ("indexProvider".equals(config.getName())) {
                try {
                    IWorkspaceModelIndexProvider provider = (IWorkspaceModelIndexProvider)config.createExecutableExtension("class");
                    WorkspaceModelIndex index = (WorkspaceModelIndex)provider.get();
                    if (index == null) {
                        Activator.log.warn("No index provided by " + config.getContributor().getName());
                    } else {
                        QualifiedName key = index.getIndexKey();
                        if (key == null) {
                            Activator.log.warn("Index has no key and will be ignored: " + index);
                        } else {
                            WorkspaceModelIndex internal = index;
                            internal.setOwnerClassLoader(provider.getClass().getClassLoader());
                            result.put(key, internal);
                        }
                    }
                }
                catch (ClassCastException e) {
                    Activator.log.error("Expected IWorkspaceModelIndexProvider in " + config.getContributor().getName(), (Throwable)e);
                }
                catch (CoreException e) {
                    Activator.log.log(e.getStatus());
                }
                catch (Exception e) {
                    Activator.log.error("Failed to obtain index from provider in " + config.getContributor().getName(), (Throwable)e);
                }
            }
            ++n2;
        }
        return result;
    }

    IContentType[] getContentTypes(IFile file) {
        return this.contentTypeService.getContentTypes(file);
    }

    <V> ListenableFuture<V> afterIndex(InternalModelIndex index, final Callable<V> callable) {
        Object result;
        if (Job.getJobManager().find((Object)this).length == 0 || this.wsRoot.getWorkspace().isTreeLocked()) {
            try {
                result = Futures.immediateFuture(callable.call());
            }
            catch (Exception e) {
                result = Futures.immediateFailedFuture((Throwable)e);
            }
        } else {
            JobBasedFuture job = new JobBasedFuture<V>("Wait for workspace model index"){
                {
                    super($anonymous0);
                    this.setSystem(true);
                }

                protected V compute(IProgressMonitor monitor) throws Exception {
                    Job.getJobManager().join((Object)IndexManager.this, monitor);
                    Object result = callable.call();
                    return result;
                }
            };
            job.schedule();
            result = job;
        }
        return result;
    }

    <V> V ifAvailable(Callable<V> callable) throws CoreException {
        V result = null;
        if (Job.getJobManager().find((Object)this).length == 0) {
            try {
                result = callable.call();
            }
            catch (CoreException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.infra.emf", e.getMessage(), (Throwable)e));
            }
        }
        return result;
    }

    void index(Collection<? extends IProject> projects) {
        ArrayList jobs = Lists.newArrayListWithCapacity((int)projects.size());
        for (IProject iProject : projects) {
            jobs.add(new IndexProjectJob(iProject));
        }
        this.schedule(jobs);
    }

    void index(IProject project) {
        this.schedule(new IndexProjectJob(project));
    }

    void process(IFile file) throws CoreException {
        IProject project = file.getProject();
        this.safeIterateIndices(index -> {
            if (index.match(file)) {
                index.process(file);
            } else {
                index.remove(project, file);
            }
        });
    }

    private void safeIterateIndices(IndexAction action) throws CoreException {
        CoreException exception = null;
        for (InternalModelIndex index : this.indices.values()) {
            try {
                action.apply(index);
            }
            catch (CoreException e) {
                if (exception == null) continue;
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    void remove(IProject project, IFile file) throws CoreException {
        this.safeIterateIndices(index -> index.remove(project, file));
    }

    void remove(IProject project) throws CoreException {
        this.safeIterateIndices(index -> index.remove(project));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReindexProjectJob reindex(IProject project, Collection<? extends IndexDelta> deltas) {
        ReindexProjectJob result = null;
        Map<IProject, AbstractIndexJob> map = this.activeJobs;
        synchronized (map) {
            AbstractIndexJob active = this.activeJobs.get(project);
            if (active != null) {
                switch (active.kind()) {
                    case REINDEX: {
                        ReindexProjectJob reindex = (ReindexProjectJob)active;
                        reindex.addDeltas(deltas);
                        break;
                    }
                    case INDEX: {
                        IndexProjectJob index = (IndexProjectJob)active;
                        ReindexProjectJob followup = index.getFollowup();
                        if (followup != null) {
                            followup.addDeltas(deltas);
                            break;
                        }
                        followup = new ReindexProjectJob(project, deltas);
                        index.setFollowup(followup);
                        break;
                    }
                    case MASTER: {
                        throw new IllegalStateException("Master job is in the active table.");
                    }
                }
            } else {
                result = new ReindexProjectJob(project, deltas);
            }
        }
        return result;
    }

    IResourceVisitor getWorkspaceVisitor(final IProgressMonitor monitor) {
        return new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (resource.getType() == 1) {
                    IndexManager.this.process((IFile)resource);
                }
                return !monitor.isCanceled();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedule(Collection<? extends AbstractIndexJob> jobs) {
        Map<IProject, AbstractIndexJob> map = this.activeJobs;
        synchronized (map) {
            this.jobWrangler.add(jobs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedule(AbstractIndexJob job) {
        Map<IProject, AbstractIndexJob> map = this.activeJobs;
        synchronized (map) {
            this.jobWrangler.add(job);
        }
    }

    public void addListener(WorkspaceModelIndex<?> index, IWorkspaceModelIndexListener listener) {
        this.listeners.addIfAbsent(new IndexListener(index, listener));
    }

    public void removeListener(WorkspaceModelIndex<?> index, IWorkspaceModelIndexListener listener) {
        this.listeners.removeIf(l -> Objects.equal(l.index, (Object)index) && Objects.equal((Object)l.listener, (Object)listener));
    }

    private void notifyStarting(AbstractIndexJob indexJob) {
        if (!this.listeners.isEmpty()) {
            HashMap events = Maps.newHashMap();
            Function<WorkspaceModelIndex, WorkspaceModelIndexEvent> eventFunction = index -> {
                switch (indexJob.kind()) {
                    case INDEX: {
                        return new WorkspaceModelIndexEvent((WorkspaceModelIndex<?>)index, 2, indexJob.getProject());
                    }
                    case REINDEX: {
                        return new WorkspaceModelIndexEvent((WorkspaceModelIndex<?>)index, 0, indexJob.getProject());
                    }
                }
                throw new IllegalArgumentException(indexJob.kind().name());
            };
            switch (indexJob.kind()) {
                case INDEX: {
                    for (IndexListener next : this.listeners) {
                        try {
                            next.listener.indexAboutToCalculate(events.computeIfAbsent(next.index, eventFunction));
                        }
                        catch (Exception e) {
                            Activator.log.error("Uncaught exception in index listsner.", (Throwable)e);
                        }
                    }
                    break;
                }
                case REINDEX: {
                    for (IndexListener next : this.listeners) {
                        try {
                            next.listener.indexAboutToRecalculate(events.computeIfAbsent(next.index, eventFunction));
                        }
                        catch (Exception e) {
                            Activator.log.error("Uncaught exception in index listsner.", (Throwable)e);
                        }
                    }
                    break;
                }
            }
        }
    }

    private void notifyFinished(AbstractIndexJob indexJob, IStatus status) {
        if (!this.listeners.isEmpty()) {
            if (status != null && status.getSeverity() >= 4) {
                HashMap events = Maps.newHashMap();
                Function<WorkspaceModelIndex, WorkspaceModelIndexEvent> eventFunction = index -> new WorkspaceModelIndexEvent((WorkspaceModelIndex<?>)index, 4, indexJob.getProject());
                for (IndexListener next : this.listeners) {
                    try {
                        next.listener.indexFailed(events.computeIfAbsent(next.index, eventFunction));
                    }
                    catch (Exception e) {
                        Activator.log.error("Uncaught exception in index listsner.", (Throwable)e);
                    }
                }
            } else {
                HashMap events = Maps.newHashMap();
                Function<WorkspaceModelIndex, WorkspaceModelIndexEvent> eventFunction = index -> {
                    switch (indexJob.kind()) {
                        case INDEX: {
                            return new WorkspaceModelIndexEvent((WorkspaceModelIndex<?>)index, 3, indexJob.getProject());
                        }
                        case REINDEX: {
                            return new WorkspaceModelIndexEvent((WorkspaceModelIndex<?>)index, 1, indexJob.getProject());
                        }
                    }
                    throw new IllegalArgumentException(indexJob.kind().name());
                };
                switch (indexJob.kind()) {
                    case INDEX: {
                        for (IndexListener next : this.listeners) {
                            try {
                                next.listener.indexCalculated(events.computeIfAbsent(next.index, eventFunction));
                            }
                            catch (Exception e) {
                                Activator.log.error("Uncaught exception in index listsner.", (Throwable)e);
                            }
                        }
                        break;
                    }
                    case REINDEX: {
                        for (IndexListener next : this.listeners) {
                            try {
                                next.listener.indexRecalculated(events.computeIfAbsent(next.index, eventFunction));
                            }
                            catch (Exception e) {
                                Activator.log.error("Uncaught exception in index listsner.", (Throwable)e);
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    private abstract class AbstractIndexJob
    extends Job {
        private final IProject project;
        private volatile Semaphore permit;

        AbstractIndexJob(String name, IProject project) {
            this(name, project, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AbstractIndexJob(String name, IProject project, boolean register) {
            super(name);
            this.project = project;
            this.permit = this.permit;
            if (project != null && register) {
                this.setRule((ISchedulingRule)project);
                Map map = IndexManager.this.activeJobs;
                synchronized (map) {
                    if (!IndexManager.this.activeJobs.containsKey(project)) {
                        IndexManager.this.activeJobs.put(project, this);
                    }
                }
            }
            this.setSystem(this.kind().isSystem());
        }

        public boolean belongsTo(Object family) {
            return family == IndexManager.this;
        }

        final IProject getProject() {
            return this.project;
        }

        abstract JobKind kind();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final IStatus run(IProgressMonitor monitor) {
            IStatus result;
            try {
                result = this.doRun(monitor);
            }
            catch (Throwable throwable) {
                Map map = IndexManager.this.activeJobs;
                synchronized (map) {
                    AbstractIndexJob followup = this.getFollowup();
                    if (this.project != null) {
                        if (followup == null) {
                            IndexManager.this.activeJobs.remove(this.project);
                        } else {
                            IndexManager.this.activeJobs.put(this.project, followup);
                        }
                    }
                    if (followup != null) {
                        IndexManager.this.schedule(followup);
                    }
                }
                throw throwable;
            }
            Map map = IndexManager.this.activeJobs;
            synchronized (map) {
                AbstractIndexJob followup = this.getFollowup();
                if (this.project != null) {
                    if (followup == null) {
                        IndexManager.this.activeJobs.remove(this.project);
                    } else {
                        IndexManager.this.activeJobs.put(this.project, followup);
                    }
                }
                if (followup != null) {
                    IndexManager.this.schedule(followup);
                }
            }
            return result;
        }

        final Semaphore getPermit() {
            return this.permit;
        }

        final void setPermit(Semaphore permit) {
            this.permit = permit;
        }

        protected abstract IStatus doRun(IProgressMonitor var1);

        protected AbstractIndexJob getFollowup() {
            return null;
        }
    }

    private static final class ContentTypeService
    extends ReferenceCounted<ContentTypeService> {
        private static ContentTypeService instance = null;
        private final ExecutorService serialExecution = new JobExecutorService();
        private final IContentTypeManager mgr = Platform.getContentTypeManager();

        private ContentTypeService() {
        }

        static synchronized ContentTypeService getInstance() {
            ContentTypeService result = instance;
            if (result == null) {
                instance = result = new ContentTypeService();
            }
            return (ContentTypeService)((Object)result.retain());
        }

        static synchronized void dispose(ContentTypeService service) {
            service.release();
        }

        protected void dispose() {
            this.serialExecution.shutdownNow();
            if (instance == this) {
                instance = null;
            }
        }

        IContentType[] getContentTypes(final IFile file) {
            Future<IContentType[]> futureResult = this.serialExecution.submit(new Callable<IContentType[]>(){

                @Override
                public IContentType[] call() {
                    IContentType[] result;
                    block13: {
                        result = null;
                        InputStream input = null;
                        if (file.isAccessible()) {
                            try {
                                try {
                                    input = file.getContents(true);
                                    result = mgr.findContentTypesFor(input, file.getName());
                                }
                                catch (Exception e) {
                                    Activator.log.error("Failed to index file " + file.getFullPath(), (Throwable)e);
                                    if (input == null) break block13;
                                    try {
                                        input.close();
                                    }
                                    catch (IOException e2) {
                                        Activator.log.error("Failed to close indexed file " + file.getFullPath(), (Throwable)e2);
                                    }
                                }
                            }
                            finally {
                                if (input != null) {
                                    try {
                                        input.close();
                                    }
                                    catch (IOException e) {
                                        Activator.log.error("Failed to close indexed file " + file.getFullPath(), (Throwable)e);
                                    }
                                }
                            }
                        }
                    }
                    return result;
                }
            });
            return (IContentType[])Futures.getUnchecked(futureResult);
        }
    }

    @FunctionalInterface
    private static interface IndexAction {
        public void apply(InternalModelIndex var1) throws CoreException;
    }

    private static final class IndexDelta {
        private final IFile file;
        private final DeltaKind kind;

        IndexDelta(IFile file, DeltaKind kind) {
            this.file = file;
            this.kind = kind;
        }

        DeltaKind kind() {
            return this.kind;
        }

        IFile file() {
            return this.file;
        }

        static enum DeltaKind {
            INDEX,
            REINDEX,
            UNINDEX;

        }
    }

    private static final class IndexListener {
        final WorkspaceModelIndex<?> index;
        final IWorkspaceModelIndexListener listener;

        IndexListener(WorkspaceModelIndex<?> index, IWorkspaceModelIndexListener listener) {
            this.index = index;
            this.listener = listener;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.index == null ? 0 : this.index.hashCode());
            result = 31 * result + (this.listener == null ? 0 : this.listener.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof IndexListener)) {
                return false;
            }
            IndexListener other = (IndexListener)obj;
            if (this.index == null ? other.index != null : !this.index.equals(other.index)) {
                return false;
            }
            return !(this.listener == null ? other.listener != null : !this.listener.equals(other.listener));
        }
    }

    private class IndexProjectJob
    extends AbstractIndexJob {
        private ReindexProjectJob followup;

        IndexProjectJob(IProject project) {
            super("Indexing project " + project.getName(), project);
        }

        @Override
        JobKind kind() {
            return JobKind.INDEX;
        }

        @Override
        protected IStatus doRun(IProgressMonitor monitor) {
            IStatus result = Status.OK_STATUS;
            IProject project = this.getProject();
            monitor.beginTask("Indexing models in project " + project.getName(), -1);
            try {
                try {
                    if (project.isAccessible()) {
                        project.accept(IndexManager.this.getWorkspaceVisitor(monitor));
                    } else {
                        IndexManager.this.remove(project);
                    }
                    if (monitor.isCanceled()) {
                        result = Status.CANCEL_STATUS;
                    }
                }
                catch (CoreException e) {
                    result = e.getStatus();
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
            return result;
        }

        void setFollowup(ReindexProjectJob followup) {
            this.followup = followup;
        }

        @Override
        protected ReindexProjectJob getFollowup() {
            return this.followup;
        }
    }

    private static enum JobKind {
        MASTER,
        INDEX,
        REINDEX;


        boolean isSystem() {
            return this != MASTER;
        }
    }

    private class JobWrangler
    extends AbstractIndexJob {
        private final Lock lock;
        private final Deque<AbstractIndexJob> queue;
        private final AtomicBoolean active;
        private final Semaphore indexJobSemaphore;
        private volatile boolean cancelled;

        JobWrangler(int maxConcurrentJobs) {
            super("Workspace model indexer", null);
            this.lock = new ReentrantLock();
            this.queue = Queues.newArrayDeque();
            this.active = new AtomicBoolean();
            this.indexJobSemaphore = new Semaphore(maxConcurrentJobs <= 0 ? Integer.MAX_VALUE : maxConcurrentJobs);
        }

        @Override
        JobKind kind() {
            return JobKind.MASTER;
        }

        void add(AbstractIndexJob job) {
            this.lock.lock();
            try {
                this.scheduleIfNeeded();
                this.queue.add(job);
            }
            finally {
                this.lock.unlock();
            }
        }

        private void scheduleIfNeeded() {
            if (this.active.compareAndSet(false, true)) {
                this.schedule();
            }
        }

        void add(Iterable<? extends AbstractIndexJob> jobs) {
            this.lock.lock();
            try {
                for (AbstractIndexJob abstractIndexJob : jobs) {
                    this.add(abstractIndexJob);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        protected void canceling() {
            this.cancelled = true;
            this.getThread().interrupt();
        }

        /*
         * Exception decompiling
         */
        @Override
        protected IStatus doRun(IProgressMonitor progressMonitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 18[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class ReindexProjectJob
    extends AbstractIndexJob {
        private final IProject project;
        private final ConcurrentLinkedQueue<IndexDelta> deltas;

        ReindexProjectJob(IProject project, Collection<? extends IndexDelta> deltas) {
            super("Re-indexing project " + project.getName(), project);
            this.project = project;
            this.deltas = Queues.newConcurrentLinkedQueue(deltas);
        }

        @Override
        JobKind kind() {
            return JobKind.REINDEX;
        }

        void addDeltas(Iterable<? extends IndexDelta> deltas) {
            Iterables.addAll(this.deltas, deltas);
        }

        @Override
        protected IStatus doRun(IProgressMonitor monitor) {
            IStatus result = Status.OK_STATUS;
            monitor.beginTask("Re-indexing models in project " + this.project.getName(), -1);
            try {
                IndexDelta next = this.deltas.poll();
                while (next != null) {
                    if (monitor.isCanceled()) {
                        result = Status.CANCEL_STATUS;
                        break;
                    }
                    try {
                        try {
                            switch (next.kind()) {
                                case INDEX: 
                                case REINDEX: {
                                    IndexManager.this.process(next.file());
                                    break;
                                }
                                case UNINDEX: {
                                    IndexManager.this.remove(this.project, next.file());
                                }
                            }
                        }
                        catch (CoreException e) {
                            result = e.getStatus();
                            monitor.worked(1);
                            break;
                        }
                    }
                    finally {
                        monitor.worked(1);
                    }
                    next = this.deltas.poll();
                }
            }
            finally {
                monitor.done();
            }
            return result;
        }

        @Override
        protected AbstractIndexJob getFollowup() {
            return this.deltas.isEmpty() ? null : this;
        }
    }

    private class WorkspaceListener
    implements IResourceChangeListener {
        private WorkspaceListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            ArrayListMultimap deltas = ArrayListMultimap.create();
            try {
                event.getDelta().accept(new IResourceDeltaVisitor((Multimap)deltas){
                    private final /* synthetic */ Multimap val$deltas;
                    {
                        this.val$deltas = multimap;
                    }

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if (delta.getResource().getType() == 1) {
                            IFile file = (IFile)delta.getResource();
                            switch (delta.getKind()) {
                                case 4: {
                                    if ((delta.getFlags() & 0x50100) == 0) break;
                                    this.val$deltas.put((Object)file.getProject(), (Object)new IndexDelta(file, IndexDelta.DeltaKind.REINDEX));
                                    break;
                                }
                                case 2: {
                                    this.val$deltas.put((Object)file.getProject(), (Object)new IndexDelta(file, IndexDelta.DeltaKind.UNINDEX));
                                    break;
                                }
                                case 1: {
                                    this.val$deltas.put((Object)file.getProject(), (Object)new IndexDelta(file, IndexDelta.DeltaKind.INDEX));
                                }
                            }
                        }
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                Activator.log.error("Failed to analyze resource changes for re-indexing.", (Throwable)e);
            }
            if (!deltas.isEmpty()) {
                ArrayList jobs = Lists.newArrayListWithCapacity((int)deltas.keySet().size());
                for (IProject next : deltas.keySet()) {
                    ReindexProjectJob reindex = IndexManager.this.reindex(next, deltas.get((Object)next));
                    if (reindex == null) continue;
                    jobs.add(reindex);
                }
                IndexManager.this.schedule(jobs);
            }
        }
    }
}

