/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.userguidance.hover;

import java.awt.MouseInfo;
import java.util.List;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.opencert.userguidance.label.LabelHighlighter;
import org.eclipse.opencert.userguidance.labelparser.tokens.HighlightItem;
import org.eclipse.opencert.userguidance.util.HitTestUtil;
import org.eclipse.opencert.userguidance.util.VocabFetcher;
import org.eclipse.opencert.vocabulary.Term;
import org.eclipse.opencert.vocabulary.Vocabulary;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ToolTip
extends MouseTrackAdapter
implements MouseMoveListener,
MouseListener {
    private DiagramEditor editor;
    private StyledText textLabel;
    private Shell shell;

    public ToolTip(DiagramEditor editor) {
        this.editor = editor;
        editor.getDiagramGraphicalViewer().getControl().addMouseTrackListener((MouseTrackListener)this);
        editor.getDiagramGraphicalViewer().getControl().addMouseMoveListener((MouseMoveListener)this);
        editor.getDiagramGraphicalViewer().getControl().addMouseListener((MouseListener)this);
    }

    public void mouseHover(MouseEvent e) {
        final HighlightItem item = HitTestUtil.getHighlightItem(this.editor, e.x, e.y);
        if (item == null) {
            return;
        }
        final String[] itemDefinition = new String[1];
        VocabFetcher fetcher = new VocabFetcher(){

            @Override
            public void readFromVocab(List<Vocabulary> vocabularies) {
                for (Vocabulary vocabulary : vocabularies) {
                    if (vocabulary == null) continue;
                    for (Term t : vocabulary.getTerms()) {
                        if (!t.getName().toLowerCase().equals(item.getBody().toLowerCase())) continue;
                        itemDefinition[0] = ToolTip.this.createDescription(t);
                        break;
                    }
                    if (itemDefinition != null) break;
                }
            }
        };
        fetcher.execute();
        if (itemDefinition[0] == null) {
            return;
        }
        this.shell = new Shell(this.editor.getDiagramGraphicalViewer().getControl().getShell(), 16388);
        this.shell.setLayout((Layout)new GridLayout());
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(29));
        this.shell.setBackgroundMode(2);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 512;
        fillLayout.marginHeight = 10;
        fillLayout.marginWidth = 10;
        this.shell.setLayout((Layout)fillLayout);
        this.textLabel = new StyledText((Composite)this.shell, 64);
        LabelHighlighter highlighter = new LabelHighlighter(itemDefinition[0], this.textLabel.getFont(), this.textLabel.getFont());
        highlighter.calculateHighlighting();
        this.textLabel.setText(highlighter.getOutputText());
        this.textLabel.setStyleRanges(highlighter.getStylesArray());
        Point textLabelSize = this.textLabel.computeSize(-1, -1);
        if (textLabelSize.x > 500) {
            textLabelSize = this.textLabel.computeSize(500, -1);
        }
        int x = MouseInfo.getPointerInfo().getLocation().x;
        int y = MouseInfo.getPointerInfo().getLocation().y + this.shell.getDisplay().getCursorSizes()[0].y - 6;
        int width = textLabelSize.x + 22;
        int height = textLabelSize.y + 22;
        int screenWidth = this.shell.getDisplay().getBounds().x + this.shell.getDisplay().getBounds().width;
        int screenHeight = this.shell.getDisplay().getBounds().y + this.shell.getDisplay().getBounds().height;
        if (width > screenWidth - 10) {
            width = screenWidth - 10;
        }
        if (x + width > screenWidth - 5) {
            x = screenWidth - width - 5;
        }
        if (y + height > screenHeight - 5) {
            y = MouseInfo.getPointerInfo().getLocation().y - height - 5;
        }
        this.shell.setBounds(x, y, width, height);
        this.shell.setVisible(true);
    }

    public void mouseMove(MouseEvent e) {
        this.disposeShell();
    }

    public void mouseDoubleClick(MouseEvent e) {
        this.disposeShell();
    }

    public void mouseDown(MouseEvent e) {
        this.disposeShell();
    }

    public void mouseUp(MouseEvent e) {
        this.disposeShell();
    }

    private void disposeShell() {
        if (this.textLabel != null && !this.textLabel.isDisposed()) {
            this.textLabel.dispose();
        }
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.dispose();
        }
    }

    private String createDescription(Term t) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < t.getDefinitions().size()) {
            if (i > 0) {
                result.append("\n\n");
            }
            result.append((String)t.getDefinitions().get(i));
            ++i;
        }
        return result.toString();
    }
}

